/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.server;

import com.intellij.openapi.util.SystemInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class MavenServerUtil {
    private static final Properties mySystemPropertiesCache;

    public static Properties collectSystemProperties() {
        return mySystemPropertiesCache;
    }

    private static boolean isMagicalProperty(String key) {
        return key.startsWith("=");
    }

    static {
        Properties res = new Properties();
        res.putAll((Map<?, ?>)System.getProperties());
        Iterator<Object> itr = res.keySet().iterator();
        while (itr.hasNext()) {
            String propertyName = itr.next().toString();
            if (!propertyName.startsWith("idea.")) continue;
            itr.remove();
        }
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            String key = entry.getKey();
            if (MavenServerUtil.isMagicalProperty(key)) continue;
            if (SystemInfo.isWindows) {
                key = key.toUpperCase();
            }
            res.setProperty("env." + key, entry.getValue());
        }
        mySystemPropertiesCache = res;
    }
}

