/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.service.settings;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.settings.LocationSettingType;
import com.intellij.openapi.externalSystem.service.settings.AbstractExternalProjectSettingsControl;
import com.intellij.openapi.externalSystem.service.ui.ExternalSystemJdkComboBox;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemUiUtil;
import com.intellij.openapi.externalSystem.util.PaintAwarePanel;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.TextComponentAccessor;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.concurrent.TimeUnit;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.gradle.service.GradleInstallationManager;
import org.jetbrains.plugins.gradle.settings.DistributionType;
import org.jetbrains.plugins.gradle.settings.GradleProjectSettings;
import org.jetbrains.plugins.gradle.util.GradleBundle;
import org.jetbrains.plugins.gradle.util.GradleConstants;
import org.jetbrains.plugins.gradle.util.GradleUtil;

public class GradleProjectSettingsControl
extends AbstractExternalProjectSettingsControl<GradleProjectSettings> {
    private static final long BALLOON_DELAY_MILLIS = TimeUnit.SECONDS.toMillis(1L);
    @NotNull
    private final Alarm myAlarm;
    @NotNull
    private LocationSettingType myGradleHomeSettingType;
    @NotNull
    private final GradleInstallationManager myInstallationManager;
    private JLabel myGradleHomeLabel;
    private JLabel myGradleJdkLabel;
    private ExternalSystemJdkComboBox myGradleJdkComboBox;
    private TextFieldWithBrowseButton myGradleHomePathField;
    private JBRadioButton myUseWrapperButton;
    private JBRadioButton myUseWrapperWithVerificationButton;
    private JBLabel myUseWrapperVerificationLabel;
    private JBRadioButton myUseLocalDistributionButton;
    private JBRadioButton myUseBundledDistributionButton;
    private boolean myShowBalloonIfNecessary;

    public GradleProjectSettingsControl(@NotNull GradleProjectSettings initialSettings) {
        if (initialSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "initialSettings", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl", "<init>"));
        }
        super((ExternalProjectSettings)initialSettings);
        this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
        this.myInstallationManager = (GradleInstallationManager)ServiceManager.getService(GradleInstallationManager.class);
    }

    protected void fillExtraControls(@NotNull PaintAwarePanel content, int indentLevel) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl", "fillExtraControls"));
        }
        content.setPaintCallback((Consumer)new Consumer<Graphics>(){

            public void consume(Graphics graphics) {
                GradleProjectSettingsControl.this.showBalloonIfNecessary();
            }
        });
        content.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (!"ancestor".equals(evt.getPropertyName())) {
                    return;
                }
                GradleProjectSettingsControl.this.myShowBalloonIfNecessary = evt.getNewValue() != null && evt.getOldValue() == null;
                if (evt.getNewValue() == null && evt.getOldValue() != null) {
                    GradleProjectSettingsControl.this.myAlarm.cancelAllRequests();
                }
            }
        });
        this.myGradleHomeLabel = new JBLabel(GradleBundle.message("gradle.settings.text.home.path", new Object[0]));
        this.initGradleHome();
        this.myGradleJdkLabel = new JBLabel(GradleBundle.message("gradle.settings.text.jvm.path", new Object[0]));
        this.myGradleJdkComboBox = new ExternalSystemJdkComboBox().withoutJre();
        this.initControls();
        content.add((Component)this.myUseWrapperButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        content.add((Component)this.myUseWrapperWithVerificationButton, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        content.add((Component)this.myUseWrapperVerificationLabel, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        content.add((Component)this.myUseLocalDistributionButton, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)indentLevel));
        content.add((Component)this.myGradleHomeLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        content.add((Component)this.myGradleHomePathField, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
        content.add((Component)this.myGradleJdkLabel, (Object)ExternalSystemUiUtil.getLabelConstraints((int)indentLevel));
        content.add((Component)this.myGradleJdkComboBox, (Object)ExternalSystemUiUtil.getFillLineConstraints((int)0));
    }

    private void initControls() {
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                boolean localDistributionEnabled = GradleProjectSettingsControl.this.myUseLocalDistributionButton.isSelected();
                GradleProjectSettingsControl.this.myGradleHomePathField.setEnabled(localDistributionEnabled);
                if (localDistributionEnabled) {
                    if (GradleProjectSettingsControl.this.myGradleHomePathField.getText().isEmpty()) {
                        GradleProjectSettingsControl.this.deduceGradleHomeIfPossible();
                    } else if (GradleProjectSettingsControl.this.myInstallationManager.isGradleSdkHome(GradleProjectSettingsControl.this.myGradleHomePathField.getText())) {
                        GradleProjectSettingsControl.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_CORRECT;
                    } else {
                        GradleProjectSettingsControl.this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                        GradleProjectSettingsControl.this.myShowBalloonIfNecessary = true;
                    }
                    GradleProjectSettingsControl.this.showBalloonIfNecessary();
                } else {
                    GradleProjectSettingsControl.this.myAlarm.cancelAllRequests();
                }
            }
        };
        this.myUseWrapperButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
        this.myUseWrapperButton.addActionListener(listener);
        this.myUseWrapperWithVerificationButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.customizable_wrapper", new Object[0]));
        this.myUseWrapperWithVerificationButton.addActionListener(listener);
        this.myUseWrapperVerificationLabel = new JBLabel(GradleBundle.message("gradle.settings.text.wrapper.customization.compatibility", new Object[0]));
        this.myUseWrapperVerificationLabel.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.MINI));
        this.myUseWrapperVerificationLabel.setIcon(UIUtil.getBalloonInformationIcon());
        this.myUseLocalDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.local.distribution", new Object[0]));
        this.myUseLocalDistributionButton.addActionListener(listener);
        this.myUseBundledDistributionButton = new JBRadioButton(GradleBundle.message("gradle.settings.text.use.bundled.distribution", GradleVersion.current().getVersion()));
        this.myUseBundledDistributionButton.addActionListener(listener);
        this.myUseBundledDistributionButton.setEnabled(false);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add((AbstractButton)this.myUseWrapperButton);
        buttonGroup.add((AbstractButton)this.myUseWrapperWithVerificationButton);
        buttonGroup.add((AbstractButton)this.myUseBundledDistributionButton);
        buttonGroup.add((AbstractButton)this.myUseLocalDistributionButton);
    }

    private void initGradleHome() {
        this.myGradleHomePathField = new TextFieldWithBrowseButton();
        FileChooserDescriptor fileChooserDescriptor = GradleUtil.getGradleHomeFileChooserDescriptor();
        this.myGradleHomePathField.addBrowseFolderListener("", GradleBundle.message("gradle.settings.text.home.path", new Object[0]), null, fileChooserDescriptor, TextComponentAccessor.TEXT_FIELD_WHOLE_TEXT, false);
        this.myGradleHomePathField.getTextField().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                GradleProjectSettingsControl.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GradleProjectSettingsControl.this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    public boolean validate(@NotNull GradleProjectSettings settings) throws ConfigurationException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl", "validate"));
        }
        String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (this.myUseLocalDistributionButton.isSelected()) {
            if (StringUtil.isEmpty((String)gradleHomePath)) {
                this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.empty", gradleHomePath));
            }
            if (!this.myInstallationManager.isGradleSdkHome(new File(gradleHomePath))) {
                this.myGradleHomeSettingType = LocationSettingType.EXPLICIT_INCORRECT;
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
                throw new ConfigurationException(GradleBundle.message("gradle.home.setting.type.explicit.incorrect", gradleHomePath));
            }
        }
        return true;
    }

    protected void applyExtraSettings(@NotNull GradleProjectSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl", "applyExtraSettings"));
        }
        String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHomePath)) {
            settings.setGradleHome(null);
        } else {
            settings.setGradleHome(gradleHomePath);
            GradleUtil.storeLastUsedGradleHome(gradleHomePath);
        }
        String gradleJvm = FileUtil.toCanonicalPath((String)this.myGradleJdkComboBox.getSelectedValue());
        settings.setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        if (this.myUseLocalDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.LOCAL);
        } else if (this.myUseWrapperButton.isSelected()) {
            settings.setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (this.myUseWrapperWithVerificationButton.isSelected() || this.myUseBundledDistributionButton.isSelected()) {
            settings.setDistributionType(DistributionType.WRAPPED);
        }
    }

    protected void updateInitialExtraSettings() {
        String gradleHomePath = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        ((GradleProjectSettings)this.getInitialSettings()).setGradleHome(StringUtil.isEmpty((String)gradleHomePath) ? null : gradleHomePath);
        String gradleJvm = FileUtil.toCanonicalPath((String)this.myGradleJdkComboBox.getSelectedValue());
        ((GradleProjectSettings)this.getInitialSettings()).setGradleJvm(StringUtil.isEmpty((String)gradleJvm) ? null : gradleJvm);
        if (this.myUseLocalDistributionButton.isSelected()) {
            ((GradleProjectSettings)this.getInitialSettings()).setDistributionType(DistributionType.LOCAL);
        } else if (this.myUseWrapperButton.isSelected()) {
            ((GradleProjectSettings)this.getInitialSettings()).setDistributionType(DistributionType.DEFAULT_WRAPPED);
        } else if (this.myUseWrapperWithVerificationButton.isSelected() || this.myUseBundledDistributionButton.isSelected()) {
            ((GradleProjectSettings)this.getInitialSettings()).setDistributionType(DistributionType.WRAPPED);
        }
    }

    protected boolean isExtraSettingModified() {
        DistributionType distributionType = ((GradleProjectSettings)this.getInitialSettings()).getDistributionType();
        if (this.myUseBundledDistributionButton.isSelected() && distributionType != DistributionType.BUNDLED) {
            return true;
        }
        if (this.myUseWrapperButton.isSelected() && distributionType != DistributionType.DEFAULT_WRAPPED) {
            return true;
        }
        if (this.myUseWrapperWithVerificationButton.isSelected() && distributionType != DistributionType.WRAPPED) {
            return true;
        }
        if (this.myUseLocalDistributionButton.isSelected() && distributionType != DistributionType.LOCAL) {
            return true;
        }
        if (!StringUtil.equals((CharSequence)this.myGradleJdkComboBox.getSelectedValue(), (CharSequence)((GradleProjectSettings)this.getInitialSettings()).getGradleJvm())) {
            return true;
        }
        String gradleHome = FileUtil.toCanonicalPath((String)this.myGradleHomePathField.getText());
        if (StringUtil.isEmpty((String)gradleHome)) {
            return !StringUtil.isEmpty((String)((GradleProjectSettings)this.getInitialSettings()).getGradleHome());
        }
        return !gradleHome.equals(((GradleProjectSettings)this.getInitialSettings()).getGradleHome());
    }

    protected void resetExtraSettings(boolean isDefaultModuleCreation) {
        String gradleHome = ((GradleProjectSettings)this.getInitialSettings()).getGradleHome();
        this.myGradleHomePathField.setText(gradleHome == null ? "" : gradleHome);
        this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.EXPLICIT_CORRECT.getColor());
        this.resetGradleJdkComboBox(this.getProject());
        this.updateWrapperControls(((GradleProjectSettings)this.getInitialSettings()).getExternalProjectPath(), isDefaultModuleCreation);
        if (!this.myUseLocalDistributionButton.isSelected()) {
            this.myGradleHomePathField.setEnabled(false);
            return;
        }
        if (StringUtil.isEmpty((String)gradleHome)) {
            this.myGradleHomeSettingType = LocationSettingType.UNKNOWN;
            this.deduceGradleHomeIfPossible();
        } else {
            this.myGradleHomeSettingType = this.myInstallationManager.isGradleSdkHome(new File(gradleHome)) ? LocationSettingType.EXPLICIT_CORRECT : LocationSettingType.EXPLICIT_INCORRECT;
            this.myAlarm.cancelAllRequests();
            if (this.myGradleHomeSettingType == LocationSettingType.EXPLICIT_INCORRECT && ((GradleProjectSettings)this.getInitialSettings()).getDistributionType() == DistributionType.LOCAL) {
                new DelayedBalloonInfo(MessageType.ERROR, this.myGradleHomeSettingType, 0L).run();
            }
        }
    }

    public void updateWrapperControls(@Nullable String linkedProjectPath, boolean isDefaultModuleCreation) {
        if (StringUtil.isEmpty((String)linkedProjectPath) && !isDefaultModuleCreation) {
            this.myUseLocalDistributionButton.setSelected(true);
            this.myGradleHomePathField.setEnabled(true);
            return;
        }
        boolean isGradleDefaultWrapperFilesExist = GradleUtil.isGradleDefaultWrapperFilesExist(linkedProjectPath);
        if (isGradleDefaultWrapperFilesExist || isDefaultModuleCreation) {
            this.myUseWrapperButton.setEnabled(true);
            this.myUseWrapperButton.setSelected(true);
            this.myGradleHomePathField.setEnabled(false);
            this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.configured", new Object[0]));
        } else {
            this.myUseWrapperButton.setEnabled(false);
            this.myUseLocalDistributionButton.setSelected(true);
            this.myGradleHomePathField.setEnabled(true);
            this.myUseWrapperButton.setText(GradleBundle.message("gradle.settings.text.use.default_wrapper.not_configured", new Object[0]));
        }
        if (((GradleProjectSettings)this.getInitialSettings()).getDistributionType() == null) {
            return;
        }
        switch (((GradleProjectSettings)this.getInitialSettings()).getDistributionType()) {
            case LOCAL: {
                this.myGradleHomePathField.setEnabled(true);
                this.myUseLocalDistributionButton.setSelected(true);
                break;
            }
            case DEFAULT_WRAPPED: {
                this.myGradleHomePathField.setEnabled(false);
                this.myUseWrapperButton.setSelected(true);
                this.myUseWrapperButton.setEnabled(true);
                break;
            }
            case WRAPPED: {
                this.myGradleHomePathField.setEnabled(false);
                this.myUseWrapperWithVerificationButton.setSelected(true);
                break;
            }
            case BUNDLED: {
                this.myGradleHomePathField.setEnabled(false);
                this.myUseBundledDistributionButton.setSelected(true);
            }
        }
    }

    private void deduceGradleHomeIfPossible() {
        File gradleHome = this.myInstallationManager.getAutodetectedGradleHome();
        if (gradleHome == null) {
            new DelayedBalloonInfo(MessageType.WARNING, LocationSettingType.UNKNOWN, BALLOON_DELAY_MILLIS).run();
            return;
        }
        this.myGradleHomeSettingType = LocationSettingType.DEDUCED;
        new DelayedBalloonInfo(MessageType.INFO, LocationSettingType.DEDUCED, BALLOON_DELAY_MILLIS).run();
        this.myGradleHomePathField.setText(gradleHome.getPath());
        this.myGradleHomePathField.getTextField().setForeground(LocationSettingType.DEDUCED.getColor());
    }

    void showBalloonIfNecessary() {
        if (!this.myShowBalloonIfNecessary || !this.myGradleHomePathField.isEnabled()) {
            return;
        }
        this.myShowBalloonIfNecessary = false;
        MessageType messageType = null;
        switch (this.myGradleHomeSettingType) {
            case DEDUCED: {
                messageType = MessageType.INFO;
                break;
            }
            case EXPLICIT_INCORRECT: 
            case UNKNOWN: {
                messageType = MessageType.ERROR;
                break;
            }
        }
        if (messageType != null) {
            new DelayedBalloonInfo(messageType, this.myGradleHomeSettingType, BALLOON_DELAY_MILLIS).run();
        }
    }

    public void setCurrentProject(@Nullable Project project) {
        super.setCurrentProject(project);
        this.resetGradleJdkComboBox(project);
    }

    private void resetGradleJdkComboBox(final @Nullable Project project) {
        String gradleJvm = ((GradleProjectSettings)this.getInitialSettings()).getGradleJvm();
        this.myGradleJdkComboBox.setProject(project);
        String sdkItem = (String)ObjectUtils.nullizeByCondition((Object)gradleJvm, (Condition)new Condition<String>(){

            public boolean value(String s) {
                return project == null && StringUtil.equals((CharSequence)"#USE_PROJECT_JDK", (CharSequence)s) || StringUtil.isEmpty((String)s);
            }
        });
        this.myGradleJdkComboBox.refreshData(sdkItem);
    }

    private class DelayedBalloonInfo
    implements Runnable {
        private final MessageType myMessageType;
        private final String myText;
        private final long myTriggerTime;

        DelayedBalloonInfo(@NotNull MessageType messageType, LocationSettingType settingType, long delayMillis) {
            if (messageType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messageType", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl$DelayedBalloonInfo", "<init>"));
            }
            if (settingType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settingType", "org/jetbrains/plugins/gradle/service/settings/GradleProjectSettingsControl$DelayedBalloonInfo", "<init>"));
            }
            this.myMessageType = messageType;
            this.myText = settingType.getDescription(GradleConstants.SYSTEM_ID);
            this.myTriggerTime = System.currentTimeMillis() + delayMillis;
        }

        @Override
        public void run() {
            long diff = this.myTriggerTime - System.currentTimeMillis();
            if (diff > 0L) {
                GradleProjectSettingsControl.this.myAlarm.cancelAllRequests();
                GradleProjectSettingsControl.this.myAlarm.addRequest((Runnable)this, diff);
                return;
            }
            if (GradleProjectSettingsControl.this.myGradleHomePathField == null || !GradleProjectSettingsControl.this.myGradleHomePathField.isShowing()) {
                return;
            }
            ExternalSystemUiUtil.showBalloon((JComponent)GradleProjectSettingsControl.this.myGradleHomePathField, (MessageType)this.myMessageType, (String)this.myText);
        }
    }
}

