/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.reference.SoftReference;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.lang.ref.Reference;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;

public class ExceptionInfoCache {
    private final ConcurrentMap<String, SoftReference<Pair<PsiClass[], PsiFile[]>>> myCache = ContainerUtil.newConcurrentMap();
    private final Project myProject;
    private final GlobalSearchScope mySearchScope;

    public ExceptionInfoCache(GlobalSearchScope searchScope) {
        this.myProject = (Project)ObjectUtils.assertNotNull((Object)searchScope.getProject());
        this.mySearchScope = searchScope;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionInfoCache", "getProject"));
        }
        return project;
    }

    @NotNull
    private PsiClass[] findClassesPreferringMyScope(String className) {
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance(this.myProject);
        PsiClass[] result = psiFacade.findClasses(className, this.mySearchScope);
        PsiClass[] psiClassArray = result.length != 0 ? result : psiFacade.findClasses(className, GlobalSearchScope.allScope(this.myProject));
        if (psiClassArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/filters/ExceptionInfoCache", "findClassesPreferringMyScope"));
        }
        return psiClassArray;
    }

    Pair<PsiClass[], PsiFile[]> resolveClass(String className) {
        int dollarIndex;
        Pair cached = (Pair)SoftReference.dereference((Reference)((Reference)this.myCache.get(className)));
        if (cached != null) {
            return cached;
        }
        if (DumbService.isDumb(this.myProject)) {
            return Pair.create((Object)PsiClass.EMPTY_ARRAY, (Object)PsiFile.EMPTY_ARRAY);
        }
        PsiClass[] classes = this.findClassesPreferringMyScope(className);
        if (classes.length == 0 && (dollarIndex = className.indexOf(36)) >= 0) {
            classes = this.findClassesPreferringMyScope(className.substring(0, dollarIndex));
        }
        PsiFile[] files = new PsiFile[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            files[i] = (PsiFile)classes[i].getContainingFile().getNavigationElement();
        }
        Pair result = Pair.create((Object)classes, (Object)files);
        this.myCache.put(className, (SoftReference<Pair<PsiClass[], PsiFile[]>>)new SoftReference((Object)result));
        return result;
    }
}

