/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.MasterDetails;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.MultiLineTooltipUI;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xmlb.XmlSerializerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JToolTip;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MasterDetailsComponent
implements Configurable,
DetailsComponent.Facade,
MasterDetails {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.MasterDetailsComponent");
    protected static final Icon COPY_ICON = PlatformIcons.COPY_ICON;
    protected NamedConfigurable myCurrentConfigurable;
    private final JBSplitter mySplitter;
    @NonNls
    public static final String TREE_OBJECT = "treeObject";
    @NonNls
    public static final String TREE_NAME = "treeName";
    protected History myHistory = new History(new Place.Navigator(){

        @Override
        public void setHistory(History history) {
            MasterDetailsComponent.this.myHistory = history;
        }

        @Override
        @Nullable
        public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
            return null;
        }

        @Override
        public void queryPlace(@NotNull Place place) {
            if (place == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/openapi/ui/MasterDetailsComponent$1", "queryPlace"));
            }
        }
    });
    private JComponent myMaster;
    protected final MasterDetailsState myState;
    protected Runnable TREE_UPDATER = new Runnable(){

        @Override
        public void run() {
            TreePath selectionPath = MasterDetailsComponent.this.myTree.getSelectionPath();
            if (selectionPath == null) {
                return;
            }
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            if (node == null) {
                return;
            }
            MasterDetailsComponent.this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
            MasterDetailsComponent.this.myDetails.setText(node.getConfigurable().getBannerSlogan());
            ((DefaultTreeModel)MasterDetailsComponent.this.myTree.getModel()).reload(node);
            MasterDetailsComponent.this.fireItemsChangedExternally();
        }
    };
    protected MyNode myRoot = new MyRootNode();
    protected Tree myTree = new Tree();
    private final DetailsComponent myDetails = new DetailsComponent(!Registry.is((String)"ide.new.project.settings"), !Registry.is((String)"ide.new.project.settings"));
    protected JPanel myWholePanel;
    public JPanel myNorthPanel = new JPanel(new BorderLayout());
    private final List<ItemsChangeListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    private final Set<NamedConfigurable> myInitializedConfigurables = new HashSet();
    private boolean myHasDeletedItems;
    protected AutoScrollToSourceHandler myAutoScrollHandler;
    protected boolean myToReInitWholePanel = true;

    public void setHistory(History history) {
        this.myHistory = history;
    }

    protected MasterDetailsComponent() {
        this(new MasterDetailsState());
    }

    protected MasterDetailsComponent(MasterDetailsState state) {
        this.myState = state;
        this.mySplitter = this.isNewProjectSettings() ? new OnePixelSplitter(false, 0.2f) : new JBSplitter(false, 0.2f);
        this.mySplitter.setSplitterProportionKey("ProjectStructure.SecondLevelElements");
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.installAutoScroll();
        this.reInitWholePanelIfNeeded();
    }

    private boolean isNewProjectSettings() {
        if (!Registry.is((String)"ide.new.project.settings")) {
            return false;
        }
        try {
            String name = "com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable";
            return Class.forName(name).isAssignableFrom(this.getClass());
        }
        catch (ClassNotFoundException ignored) {
            return false;
        }
    }

    protected void reInitWholePanelIfNeeded() {
        if (!this.myToReInitWholePanel) {
            return;
        }
        this.myWholePanel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                super.addNotify();
                MasterDetailsComponent.this.addNotify();
                TreeModel m = MasterDetailsComponent.this.myTree.getModel();
                if (m instanceof DefaultTreeModel) {
                    DefaultTreeModel model = (DefaultTreeModel)m;
                    for (int eachRow = 0; eachRow < MasterDetailsComponent.this.myTree.getRowCount(); ++eachRow) {
                        TreePath eachPath = MasterDetailsComponent.this.myTree.getPathForRow(eachRow);
                        Object component = eachPath.getLastPathComponent();
                        if (!(component instanceof TreeNode)) continue;
                        model.nodeChanged((TreeNode)component);
                    }
                }
            }
        };
        this.mySplitter.setHonorComponentsMinimumSize(true);
        this.myWholePanel.add((Component)((Object)this.mySplitter), "Center");
        JPanel left = new JPanel(new BorderLayout()){

            @Override
            public Dimension getMinimumSize() {
                Dimension original = super.getMinimumSize();
                return new Dimension(Math.max(original.width, 100), original.height);
            }
        };
        if (this.isNewProjectSettings()) {
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator(this.myTree);
            DefaultActionGroup group = this.createToolbarActionGroup();
            if (group != null) {
                decorator.setActionGroup(group);
            }
            this.myMaster = decorator.setAsUsualTopToolbar().setPanelBorder(new EmptyBorder(0, 0, 0, 0)).createPanel();
            this.myNorthPanel.setVisible(false);
        } else {
            left.add((Component)this.myNorthPanel, "North");
            this.myMaster = ScrollPaneFactory.createScrollPane(this.myTree);
        }
        left.add((Component)this.myMaster, "Center");
        this.mySplitter.setFirstComponent(left);
        JPanel right = new JPanel(new BorderLayout());
        right.add((Component)this.myDetails.getComponent(), "Center");
        if (!this.isNewProjectSettings()) {
            this.myWholePanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }
        this.mySplitter.setSecondComponent(right);
        GuiUtils.replaceJSplitPaneWithIDEASplitter(this.myWholePanel);
        this.myToReInitWholePanel = false;
    }

    private void installAutoScroll() {
        this.myAutoScrollHandler = new AutoScrollToSourceHandler(){

            @Override
            protected boolean isAutoScrollMode() {
                return MasterDetailsComponent.this.isAutoScrollEnabled();
            }

            @Override
            protected void setAutoScrollMode(boolean state) {
            }

            @Override
            protected void scrollToSource(Component tree) {
                MasterDetailsComponent.this.updateSelectionFromTree();
            }

            @Override
            protected boolean needToCheckFocus() {
                return false;
            }
        };
        this.myAutoScrollHandler.install(this.myTree);
    }

    protected void addNotify() {
        this.updateSelectionFromTree();
    }

    private void updateSelectionFromTree() {
        TreePath path;
        TreePath[] treePaths = this.myTree.getSelectionPaths();
        if (treePaths != null) {
            ArrayList<NamedConfigurable> selectedConfigurables = new ArrayList<NamedConfigurable>();
            for (TreePath path2 : treePaths) {
                Object lastPathComponent = path2.getLastPathComponent();
                if (!(lastPathComponent instanceof MyNode)) continue;
                selectedConfigurables.add(((MyNode)lastPathComponent).getConfigurable());
            }
            if (selectedConfigurables.size() > 1 && this.updateMultiSelection(selectedConfigurables)) {
                return;
            }
        }
        if ((path = this.myTree.getSelectionPath()) != null) {
            Object lastPathComp = path.getLastPathComponent();
            if (!(lastPathComp instanceof MyNode)) {
                return;
            }
            MyNode node = (MyNode)lastPathComp;
            this.setSelectedNode(node);
        } else {
            this.setSelectedNode(null);
        }
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> selectedConfigurables) {
        return false;
    }

    @Override
    public DetailsComponent getDetailsComponent() {
        return this.myDetails;
    }

    public Splitter getSplitter() {
        return this.mySplitter;
    }

    protected boolean isAutoScrollEnabled() {
        return this.myHistory == null || !this.myHistory.isNavigatingNow();
    }

    protected DefaultActionGroup createToolbarActionGroup() {
        ArrayList<AnAction> actions = this.createActions(false);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                if (action instanceof ActionGroupWithPreselection) {
                    group.add(new MyActionGroupWrapper((ActionGroupWithPreselection)((Object)action)));
                    continue;
                }
                group.add(action);
            }
            return group;
        }
        return null;
    }

    private void initToolbar() {
        if (this.isNewProjectSettings()) {
            return;
        }
        DefaultActionGroup group = this.createToolbarActionGroup();
        if (group != null) {
            JComponent component = ActionManager.getInstance().createActionToolbar("unknown", group, true).getComponent();
            this.myNorthPanel.add((Component)component, "North");
        }
    }

    public void addItemsChangeListener(ItemsChangeListener l) {
        this.myListeners.add(l);
    }

    protected Dimension getPanelPreferredSize() {
        return new Dimension(800, 600);
    }

    @Override
    @NotNull
    public JComponent createComponent() {
        this.myTree.updateUI();
        this.reInitWholePanelIfNeeded();
        this.updateSelectionFromTree();
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public Dimension getPreferredSize() {
                return MasterDetailsComponent.this.getPanelPreferredSize();
            }
        };
        panel.add((Component)this.myWholePanel, "Center");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MasterDetailsComponent", "createComponent"));
        }
        return jPanel;
    }

    @Override
    public boolean isModified() {
        if (this.myHasDeletedItems) {
            return true;
        }
        final boolean[] modified = new boolean[1];
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                NamedConfigurable configurable;
                if (node instanceof MyNode && MasterDetailsComponent.this.isInitialized(configurable = ((MyNode)node).getConfigurable()) && configurable.isModified()) {
                    modified[0] = true;
                    return false;
                }
                return true;
            }
        });
        return modified[0];
    }

    protected boolean isInitialized(NamedConfigurable configurable) {
        return this.myInitializedConfigurables.contains(configurable);
    }

    @Override
    public void apply() throws ConfigurationException {
        this.processRemovedItems();
        final ConfigurationException[] ex = new ConfigurationException[1];
        TreeUtil.traverse(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    try {
                        NamedConfigurable configurable = ((MyNode)node).getConfigurable();
                        if (MasterDetailsComponent.this.isInitialized(configurable) && configurable.isModified()) {
                            configurable.apply();
                        }
                    }
                    catch (ConfigurationException e) {
                        ex[0] = e;
                        return false;
                    }
                }
                return true;
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        this.myHasDeletedItems = false;
    }

    protected abstract void processRemovedItems();

    protected abstract boolean wasObjectStored(Object var1);

    @Override
    public void reset() {
        this.loadComponentState();
        this.myHasDeletedItems = false;
        ((DefaultTreeModel)this.myTree.getModel()).reload();
        this.myState.getProportions().restoreSplitterProportions(this.myWholePanel);
        Enumeration<TreeNode> enumeration = this.myRoot.breadthFirstEnumeration();
        boolean selected = false;
        while (enumeration.hasMoreElements()) {
            MyNode node = (MyNode)enumeration.nextElement();
            if (node instanceof MyRootNode) continue;
            String path = MasterDetailsComponent.getNodePathString(node);
            if (selected || !Comparing.strEqual((String)path, (String)this.myState.getLastEditedConfigurable())) continue;
            TreeUtil.selectInTree(node, false, this.myTree);
            selected = true;
        }
        if (!selected) {
            TreeUtil.selectFirstNode(this.myTree);
        }
        this.updateSelectionFromTree();
    }

    protected void loadComponentState() {
        MasterDetailsState state;
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null && (state = stateService.getComponentState(key, this.myState.getClass())) != null) {
            this.loadState(state);
        }
    }

    private static String getNodePathString(MyNode node) {
        String displayName;
        Object userObject;
        StringBuilder path = new StringBuilder();
        MyNode current = node;
        while (current != null && (userObject = current.getUserObject()) instanceof NamedConfigurable && !StringUtil.isEmptyOrSpaces((String)(displayName = current.getDisplayName()))) {
            if (path.length() > 0) {
                path.append('|');
            }
            path.append(displayName);
            TreeNode parent = current.getParent();
            if (!(parent instanceof MyNode)) break;
            current = (MyNode)parent;
        }
        return path.toString();
    }

    @Nullable
    @NonNls
    protected String getComponentStateKey() {
        return null;
    }

    @Nullable
    protected MasterDetailsStateService getStateService() {
        return null;
    }

    protected MasterDetailsState getState() {
        return this.myState;
    }

    protected void loadState(MasterDetailsState object) {
        XmlSerializerUtil.copyBean((Object)object, (Object)this.myState);
    }

    @Override
    public void disposeUIResources() {
        this.myState.getProportions().saveSplitterProportions(this.myWholePanel);
        this.myAutoScrollHandler.cancelAllRequests();
        this.myDetails.disposeUIResources();
        this.myInitializedConfigurables.clear();
        this.clearChildren();
        String key = this.getComponentStateKey();
        MasterDetailsStateService stateService = this.getStateService();
        if (key != null && stateService != null) {
            stateService.setComponentState(key, this.getState());
        }
        this.myCurrentConfigurable = null;
    }

    protected void clearChildren() {
        TreeUtil.traverseDepth(this.myRoot, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (node instanceof MyNode) {
                    MyNode treeNode = (MyNode)node;
                    treeNode.getConfigurable().disposeUIResources();
                    if (!(treeNode instanceof MyRootNode)) {
                        treeNode.setUserObject(null);
                    }
                }
                return true;
            }
        });
        this.myRoot.removeAllChildren();
    }

    @Nullable
    protected ArrayList<AnAction> createActions(boolean fromPopup) {
        return null;
    }

    protected void initTree() {
        ((DefaultTreeModel)this.myTree.getModel()).setRoot(this.myRoot);
        this.myTree.setRootVisible(false);
        this.myTree.setShowsRootHandles(true);
        UIUtil.setLineStyleAngled((JTree)this.myTree);
        TreeUtil.installActions(this.myTree);
        this.myTree.setCellRenderer(new ColoredTreeCellRenderer(){

            @Override
            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MyNode) {
                    MyNode node = (MyNode)value;
                    this.setIcon(node.getIcon(expanded));
                    Font font = UIUtil.getTreeFont();
                    if (node.isDisplayInBold()) {
                        this.setFont(font.deriveFont(1));
                    } else {
                        this.setFont(font.deriveFont(0));
                    }
                    this.append(node.getDisplayName(), node.isDisplayInBold() ? SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES : SimpleTextAttributes.REGULAR_ATTRIBUTES);
                }
            }
        });
        this.initToolbar();
        ArrayList<AnAction> actions = this.createActions(true);
        if (actions != null) {
            DefaultActionGroup group = new DefaultActionGroup();
            for (AnAction action : actions) {
                group.add(action);
            }
            actions = this.getAdditionalActions();
            if (actions != null) {
                group.addSeparator();
                for (AnAction action : actions) {
                    group.add(action);
                }
            }
            PopupHandler.installPopupHandler(this.myTree, group, "unknown", ActionManager.getInstance());
        }
    }

    @Nullable
    protected ArrayList<AnAction> getAdditionalActions() {
        return null;
    }

    public void fireItemsChangeListener(Object editableObject) {
        for (ItemsChangeListener listener : this.myListeners) {
            listener.itemChanged(editableObject);
        }
    }

    private void fireItemsChangedExternally() {
        for (ItemsChangeListener listener : this.myListeners) {
            listener.itemsExternallyChanged();
        }
    }

    private void createUIComponents() {
        this.myTree = new Tree(){

            @Override
            public Dimension getPreferredScrollableViewportSize() {
                Dimension size = super.getPreferredScrollableViewportSize();
                size = new Dimension(size.width + 20, size.height);
                return size;
            }

            @Override
            public JToolTip createToolTip() {
                JToolTip toolTip = new JToolTip(){
                    {
                        this.setUI(new MultiLineTooltipUI());
                    }
                };
                toolTip.setComponent(this);
                return toolTip;
            }
        };
    }

    protected void addNode(MyNode nodeToAdd, MyNode parent) {
        parent.add(nodeToAdd);
        TreeUtil.sort(parent, this.getNodeComparator());
        ((DefaultTreeModel)this.myTree.getModel()).reload(parent);
    }

    protected Comparator<MyNode> getNodeComparator() {
        return new Comparator<MyNode>(){

            @Override
            public int compare(MyNode o1, MyNode o2) {
                return StringUtil.naturalCompare((String)o1.getDisplayName(), (String)o2.getDisplayName());
            }
        };
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect) {
        return this.selectNodeInTree(nodeToSelect, true, false);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean requestFocus) {
        return this.selectNodeInTree(nodeToSelect, true, requestFocus);
    }

    public ActionCallback selectNodeInTree(DefaultMutableTreeNode nodeToSelect, boolean center, boolean requestFocus) {
        if (requestFocus) {
            this.myTree.requestFocus();
        }
        if (nodeToSelect != null) {
            return TreeUtil.selectInTree(nodeToSelect, requestFocus, this.myTree, center);
        }
        return TreeUtil.selectFirstNode(this.myTree);
    }

    @Nullable
    public Object getSelectedObject() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null && selectionPath.getLastPathComponent() instanceof MyNode) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, (Object)"already disposed");
            return configurable.getEditableObject();
        }
        return null;
    }

    @Nullable
    public NamedConfigurable getSelectedConfigurable() {
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath != null) {
            MyNode node = (MyNode)selectionPath.getLastPathComponent();
            NamedConfigurable configurable = node.getConfigurable();
            LOG.assertTrue(configurable != null, (Object)"already disposed");
            return configurable;
        }
        return null;
    }

    public void selectNodeInTree(String displayName) {
        MyNode nodeByName = MasterDetailsComponent.findNodeByName(this.myRoot, displayName);
        this.selectNodeInTree(nodeByName, true);
    }

    public void selectNodeInTree(Object object) {
        this.selectNodeInTree(MasterDetailsComponent.findNodeByObject(this.myRoot, object), true);
    }

    @Nullable
    protected static MyNode findNodeByName(TreeNode root, final String profileName) {
        if (profileName == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            public boolean value(NamedConfigurable configurable) {
                return Comparing.strEqual((String)profileName, (String)configurable.getDisplayName());
            }
        });
    }

    @Nullable
    public static MyNode findNodeByObject(TreeNode root, final Object editableObject) {
        if (editableObject == null) {
            return null;
        }
        return MasterDetailsComponent.findNodeByCondition(root, new Condition<NamedConfigurable>(){

            public boolean value(NamedConfigurable configurable) {
                return Comparing.equal((Object)editableObject, configurable.getEditableObject());
            }
        });
    }

    protected static MyNode findNodeByCondition(TreeNode root, final Condition<NamedConfigurable> condition) {
        final MyNode[] nodeToSelect = new MyNode[1];
        TreeUtil.traverseDepth(root, new TreeUtil.Traverse(){

            @Override
            public boolean accept(Object node) {
                if (condition.value((Object)((MyNode)node).getConfigurable())) {
                    nodeToSelect[0] = (MyNode)node;
                    return false;
                }
                return true;
            }
        });
        return nodeToSelect[0];
    }

    protected void setSelectedNode(@Nullable MyNode node) {
        if (node != null) {
            this.myState.setLastEditedConfigurable(MasterDetailsComponent.getNodePathString(node));
        }
        this.updateSelection(node != null ? node.getConfigurable() : null);
    }

    protected void updateSelection(@Nullable NamedConfigurable configurable) {
        this.myDetails.setText(configurable != null ? configurable.getBannerSlogan() : null);
        this.myCurrentConfigurable = configurable;
        if (configurable != null) {
            JComponent comp = configurable.createComponent();
            if (comp == null) {
                this.setEmpty();
                LOG.error("createComponent() returned null. configurable=" + configurable);
            } else {
                this.myDetails.setContent(comp);
                this.ensureInitialized(configurable);
                this.myHistory.pushPlaceForElement(TREE_OBJECT, configurable.getEditableObject());
            }
        } else {
            this.setEmpty();
        }
    }

    public void ensureInitialized(NamedConfigurable configurable) {
        if (!this.isInitialized(configurable)) {
            configurable.reset();
            this.initializeConfigurable(configurable);
        }
    }

    private void setEmpty() {
        this.myDetails.setContent(null);
        this.myDetails.setEmptyContentText(this.getEmptySelectionString());
    }

    @Override
    public String getHelpTopic() {
        if (this.myCurrentConfigurable != null) {
            return this.myCurrentConfigurable.getHelpTopic();
        }
        return null;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return null;
    }

    protected void initializeConfigurable(NamedConfigurable configurable) {
        this.myInitializedConfigurables.add(configurable);
    }

    protected void checkApply(Set<MyNode> rootNodes, String prefix, String title) throws ConfigurationException {
        for (MyNode rootNode : rootNodes) {
            HashSet names = new HashSet();
            for (int i = 0; i < rootNode.getChildCount(); ++i) {
                MyNode node = (MyNode)rootNode.getChildAt(i);
                NamedConfigurable scopeConfigurable = node.getConfigurable();
                String name = scopeConfigurable.getDisplayName();
                if (name.trim().length() == 0) {
                    this.selectNodeInTree(node);
                    throw new ConfigurationException("Name should contain non-space characters");
                }
                if (names.contains(name)) {
                    NamedConfigurable selectedConfigurable = this.getSelectedConfigurable();
                    if (selectedConfigurable == null || !Comparing.strEqual((String)selectedConfigurable.getDisplayName(), (String)name)) {
                        this.selectNodeInTree(node);
                    }
                    throw new ConfigurationException(CommonBundle.message((String)"smth.already.exist.error.message", (Object[])new Object[]{prefix, name}), title);
                }
                names.add(name);
            }
        }
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected void removePaths(TreePath ... paths) {
        DefaultMutableTreeNode parentNode = null;
        int idx = -1;
        for (TreePath path : paths) {
            MyNode node = (MyNode)path.getLastPathComponent();
            NamedConfigurable namedConfigurable = node.getConfigurable();
            Object editableObject = namedConfigurable.getEditableObject();
            parentNode = (MyNode)node.getParent();
            idx = parentNode.getIndex(node);
            ((DefaultTreeModel)this.myTree.getModel()).removeNodeFromParent(node);
            this.myHasDeletedItems |= this.wasObjectStored(editableObject);
            this.fireItemsChangeListener(editableObject);
            this.onItemDeleted(editableObject);
            namedConfigurable.disposeUIResources();
        }
        if (paths.length > 0) {
            if (parentNode != null && idx != -1) {
                DefaultMutableTreeNode toSelect = null;
                if (idx < parentNode.getChildCount()) {
                    toSelect = (DefaultMutableTreeNode)parentNode.getChildAt(idx);
                } else if (idx > 0 && parentNode.getChildCount() > 0) {
                    toSelect = idx - 1 < parentNode.getChildCount() ? (DefaultMutableTreeNode)parentNode.getChildAt(idx - 1) : (DefaultMutableTreeNode)parentNode.getFirstChild();
                } else if (parentNode.isRoot() && this.myTree.isRootVisible()) {
                    toSelect = parentNode;
                } else if (parentNode.getChildCount() > 0) {
                    toSelect = (DefaultMutableTreeNode)parentNode.getFirstChild();
                }
                if (toSelect != null) {
                    TreeUtil.selectInTree(toSelect, true, this.myTree);
                }
            } else {
                TreeUtil.selectFirstNode(this.myTree);
            }
        }
    }

    protected void onItemDeleted(Object item) {
    }

    protected static Condition<Object[]> forAll(final Condition<Object> condition) {
        return new Condition<Object[]>(){

            public boolean value(Object[] objects) {
                for (Object object : objects) {
                    if (condition.value(object)) continue;
                    return false;
                }
                return true;
            }
        };
    }

    @Override
    public JComponent getToolbar() {
        this.myToReInitWholePanel = true;
        return this.myNorthPanel;
    }

    @Override
    public JComponent getMaster() {
        this.myToReInitWholePanel = true;
        return this.myMaster;
    }

    @Override
    public DetailsComponent getDetails() {
        this.myToReInitWholePanel = true;
        return this.myDetails;
    }

    @Override
    public void initUi() {
        this.createComponent();
    }

    protected class MyActionGroupWrapper
    extends AnAction
    implements DumbAware {
        private ActionGroup myActionGroup;
        private ActionGroupWithPreselection myPreselection;

        public MyActionGroupWrapper(ActionGroupWithPreselection actionGroup) {
            this(actionGroup.getActionGroup());
            this.myPreselection = actionGroup;
        }

        public MyActionGroupWrapper(ActionGroup actionGroup) {
            super(actionGroup.getTemplatePresentation().getText(), actionGroup.getTemplatePresentation().getDescription(), actionGroup.getTemplatePresentation().getIcon());
            this.myActionGroup = actionGroup;
            this.registerCustomShortcutSet(actionGroup.getShortcutSet(), MasterDetailsComponent.this.myTree);
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            JBPopupFactory popupFactory = JBPopupFactory.getInstance();
            ListPopupStep step = popupFactory.createActionsStep(this.myActionGroup, e.getDataContext(), false, false, this.myActionGroup.getTemplatePresentation().getText(), MasterDetailsComponent.this.myTree, true, this.myPreselection != null ? this.myPreselection.getDefaultIndex() : 0, true);
            ListPopup listPopup = popupFactory.createListPopup(step);
            listPopup.setHandleAutoSelectionBeforeShow(true);
            if (e instanceof AnActionButton.AnActionEventWrapper) {
                ((AnActionButton.AnActionEventWrapper)e).showPopup(listPopup);
            } else {
                listPopup.showUnderneathOf(MasterDetailsComponent.this.myNorthPanel);
            }
        }
    }

    public static interface ActionGroupWithPreselection {
        public ActionGroup getActionGroup();

        public int getDefaultIndex();
    }

    protected static interface ItemsChangeListener {
        public void itemChanged(@Nullable Object var1);

        public void itemsExternallyChanged();
    }

    protected static class MyRootNode
    extends MyNode {
        public MyRootNode() {
            super(new NamedConfigurable(false, null){

                @Override
                public void setDisplayName(String name) {
                }

                public Object getEditableObject() {
                    return null;
                }

                @Override
                public String getBannerSlogan() {
                    return null;
                }

                @Override
                public String getDisplayName() {
                    return "";
                }

                @Override
                @Nullable
                @NonNls
                public String getHelpTopic() {
                    return null;
                }

                @Override
                public JComponent createOptionsPanel() {
                    return null;
                }

                @Override
                public boolean isModified() {
                    return false;
                }

                @Override
                public void apply() throws ConfigurationException {
                }

                @Override
                public void reset() {
                }

                @Override
                public void disposeUIResources() {
                }
            }, false);
        }
    }

    public static class MyNode
    extends DefaultMutableTreeNode {
        private boolean myDisplayInBold;

        public MyNode(@NotNull NamedConfigurable userObject) {
            if (userObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/ui/MasterDetailsComponent$MyNode", "<init>"));
            }
            super(userObject);
        }

        public MyNode(@NotNull NamedConfigurable userObject, boolean displayInBold) {
            if (userObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "userObject", "com/intellij/openapi/ui/MasterDetailsComponent$MyNode", "<init>"));
            }
            super(userObject);
            this.myDisplayInBold = displayInBold;
        }

        @NotNull
        public String getDisplayName() {
            NamedConfigurable configurable = (NamedConfigurable)this.getUserObject();
            LOG.assertTrue(configurable != null, (Object)"Tree was already disposed");
            String string = configurable.getDisplayName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/ui/MasterDetailsComponent$MyNode", "getDisplayName"));
            }
            return string;
        }

        public NamedConfigurable getConfigurable() {
            return (NamedConfigurable)this.getUserObject();
        }

        public boolean isDisplayInBold() {
            return this.myDisplayInBold;
        }

        public void setDisplayInBold(boolean displayInBold) {
            this.myDisplayInBold = displayInBold;
        }

        @Nullable
        public Icon getIcon(boolean expanded) {
            NamedConfigurable configurable = this.getConfigurable();
            if (configurable != null) {
                return configurable.getIcon(expanded);
            }
            return null;
        }
    }

    protected class MyDeleteAction
    extends AnAction
    implements DumbAware {
        private final Condition<Object[]> myCondition;

        public MyDeleteAction() {
            this((Condition<Object[]>)Conditions.alwaysTrue());
        }

        public MyDeleteAction(Condition<Object[]> availableCondition) {
            super(CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), PlatformIcons.DELETE_ICON);
            this.registerCustomShortcutSet(CommonShortcuts.getDelete(), MasterDetailsComponent.this.myTree);
            this.myCondition = availableCondition;
        }

        @Override
        public void update(AnActionEvent e) {
            Presentation presentation = e.getPresentation();
            presentation.setEnabled(false);
            Object[] selectionPath = MasterDetailsComponent.this.myTree.getSelectionPaths();
            if (selectionPath != null) {
                Object[] nodes = ContainerUtil.map2Array((Object[])selectionPath, (Function)new Function<TreePath, Object>(){

                    public Object fun(TreePath treePath) {
                        return treePath.getLastPathComponent();
                    }
                });
                if (!this.myCondition.value((Object)nodes)) {
                    return;
                }
                presentation.setEnabled(true);
            }
        }

        @Override
        public void actionPerformed(AnActionEvent e) {
            MasterDetailsComponent.this.removePaths(MasterDetailsComponent.this.myTree.getSelectionPaths());
        }
    }
}

