/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.ui.tabs.JBTabsPosition;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.impl.JBTabsImpl;
import com.intellij.ui.tabs.impl.LayoutPassInfo;
import com.intellij.ui.tabs.impl.TabLabel;
import com.intellij.ui.tabs.impl.singleRow.SingleRowLayout;
import com.intellij.ui.tabs.impl.singleRow.SingleRowPassInfo;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.List;

public class CompressibleSingleRowLayout
extends SingleRowLayout {
    public CompressibleSingleRowLayout(JBTabsImpl tabs) {
        super(tabs);
    }

    @Override
    public LayoutPassInfo layoutSingleRow(List<TabInfo> visibleInfos) {
        SingleRowPassInfo data = (SingleRowPassInfo)super.layoutSingleRow(visibleInfos);
        if (data.toLayout.size() > 0) {
            TabLabel firstLabel = this.myTabs.myInfo2Label.get(data.toLayout.get(0));
            TabLabel lastLabel = this.findLastVisibleLabel(data);
            if (firstLabel != null && lastLabel != null) {
                data.tabRectangle.x = firstLabel.getBounds().x;
                data.tabRectangle.y = firstLabel.getBounds().y;
                data.tabRectangle.width = data.requiredLength;
                data.tabRectangle.height = (int)lastLabel.getBounds().getMaxY() - data.tabRectangle.y;
            }
        }
        return data;
    }

    @Override
    protected void recomputeToLayout(SingleRowPassInfo data) {
        this.calculateRequiredLength(data);
        data.firstGhostVisible = false;
        data.lastGhostVisible = false;
    }

    @Override
    protected void layoutLabelsAndGhosts(SingleRowPassInfo data) {
        if (this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.top && this.myTabs.getPresentation().getTabsPosition() != JBTabsPosition.bottom) {
            super.layoutLabelsAndGhosts(data);
            return;
        }
        int tabWidth = 0;
        boolean layoutStopped = false;
        int lengthEstimation = 0;
        for (TabInfo eachInfo : data.toLayout) {
            TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
            if (tabWidth == 0) {
                tabWidth = GraphicsUtil.stringWidth((String)"m", (Font)label.getLabelComponent().getFont()) * 20;
            }
            lengthEstimation += tabWidth;
        }
        double compressionFactor = (double)lengthEstimation / (double)data.toFitLength;
        int spentLength = 0;
        Iterator<TabInfo> iterator = data.toLayout.iterator();
        while (iterator.hasNext()) {
            int length;
            TabInfo eachInfo = iterator.next();
            TabLabel label = this.myTabs.myInfo2Label.get(eachInfo);
            if (layoutStopped) {
                label.setActionPanelVisible(false);
                Rectangle rec = this.getStrategy().getLayoutRect(data, 0, 0);
                this.myTabs.layout(label, rec);
                continue;
            }
            label.setActionPanelVisible(true);
            if (compressionFactor > 1.0) {
                length = iterator.hasNext() ? (int)((float)tabWidth * (float)data.toFitLength / (float)lengthEstimation) : data.toFitLength - spentLength - data.toLayout.size() / 2;
                spentLength += length;
            } else {
                length = tabWidth;
            }
            boolean continueLayout = this.applyTabLayout(data, label, length, 0);
            data.position = this.getStrategy().getMaxPosition(label.getBounds());
            data.position += this.myTabs.getInterTabSpaceLength();
            if (continueLayout) continue;
            layoutStopped = true;
        }
        for (TabInfo eachInfo : data.toDrop) {
            JBTabsImpl.resetLayout(this.myTabs.myInfo2Label.get(eachInfo));
        }
    }

    @Override
    protected boolean applyTabLayout(SingleRowPassInfo data, TabLabel label, int length, int deltaToFit) {
        boolean result = super.applyTabLayout(data, label, length, deltaToFit);
        label.setAlignmentToCenter(false);
        return result;
    }
}

