/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.application.options.colors;

import com.intellij.application.options.colors.ColorAndFontDescription;
import com.intellij.application.options.colors.ColorAndFontDescriptionPanel;
import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.application.options.colors.ColorAndFontSettingsListener;
import com.intellij.application.options.colors.EditorSchemeAttributeDescriptor;
import com.intellij.application.options.colors.OptionsPanel;
import com.intellij.application.options.colors.SchemesPanel;
import com.intellij.ide.DataManager;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ex.Settings;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListSpeedSearch;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.components.JBList;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;

public class OptionsPanelImpl
extends JPanel
implements OptionsPanel {
    private static final Comparator<EditorSchemeAttributeDescriptor> ATTR_COMPARATOR = new Comparator<EditorSchemeAttributeDescriptor>(){

        @Override
        public int compare(EditorSchemeAttributeDescriptor o1, EditorSchemeAttributeDescriptor o2) {
            return StringUtil.naturalCompare((String)o1.toString(), (String)o2.toString());
        }
    };
    private final JBList myOptionsList;
    private final ColorAndFontDescriptionPanel myOptionsPanel;
    private final ColorAndFontOptions myOptions;
    private final SchemesPanel mySchemesProvider;
    private final String myCategoryName;
    private final EventDispatcher<ColorAndFontSettingsListener> myDispatcher = EventDispatcher.create(ColorAndFontSettingsListener.class);
    private final CollectionListModel<EditorSchemeAttributeDescriptor> myListModel;

    public OptionsPanelImpl(ColorAndFontOptions options, SchemesPanel schemesProvider, String categoryName) {
        super(new BorderLayout());
        this.myOptions = options;
        this.mySchemesProvider = schemesProvider;
        this.myCategoryName = categoryName;
        this.myOptionsPanel = new ColorAndFontDescriptionPanel(){

            @Override
            protected void onSettingsChanged(ActionEvent e) {
                super.onSettingsChanged(e);
                ((ColorAndFontSettingsListener)OptionsPanelImpl.this.myDispatcher.getMulticaster()).settingsChanged();
            }

            @Override
            protected void onHyperLinkClicked(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    String pageName;
                    Settings settings = (Settings)Settings.KEY.getData(DataManager.getInstance().getDataContext((Component)OptionsPanelImpl.this));
                    String attrName = e.getDescription();
                    Element element = e.getSourceElement();
                    try {
                        pageName = element.getDocument().getText(element.getStartOffset(), element.getEndOffset() - element.getStartOffset());
                    }
                    catch (BadLocationException e1) {
                        return;
                    }
                    SearchableConfigurable page = OptionsPanelImpl.this.myOptions.findSubConfigurable(pageName);
                    if (page != null && settings != null) {
                        Runnable runnable = page.enableSearch(attrName);
                        ActionCallback callback = settings.select((Configurable)page);
                        if (runnable != null) {
                            callback.doWhenDone(runnable);
                        }
                    }
                }
            }
        };
        this.myListModel = new CollectionListModel((Object[])new EditorSchemeAttributeDescriptor[0]);
        this.myOptionsList = new JBList(this.myListModel);
        new ListSpeedSearch((JList)this.myOptionsList);
        this.myOptionsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (!OptionsPanelImpl.this.mySchemesProvider.areSchemesLoaded()) {
                    return;
                }
                OptionsPanelImpl.this.processListValueChanged();
            }
        });
        this.myOptionsList.setCellRenderer((ListCellRenderer)new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                Component component = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                if (value instanceof ColorAndFontDescription) {
                    this.setIcon(((ColorAndFontDescription)value).getIcon());
                    this.setToolTipText(((ColorAndFontDescription)value).getToolTip());
                }
                return component;
            }
        });
        this.myOptionsList.setSelectionMode(0);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myOptionsList);
        scrollPane.setPreferredSize(new Dimension(230, 60));
        JPanel north = new JPanel(new BorderLayout());
        north.add((Component)scrollPane, "Center");
        north.add((Component)this.myOptionsPanel, "East");
        this.add((Component)north, "North");
    }

    @Override
    public void addListener(ColorAndFontSettingsListener listener) {
        this.myDispatcher.addListener((EventListener)listener);
    }

    private void processListValueChanged() {
        Object selectedValue = this.myOptionsList.getSelectedValue();
        ColorAndFontDescription description = (ColorAndFontDescription)selectedValue;
        ColorAndFontDescriptionPanel optionsPanel = this.myOptionsPanel;
        if (description == null) {
            optionsPanel.resetDefault();
            return;
        }
        optionsPanel.reset(description);
        ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(description);
    }

    private void fillOptionsList() {
        int selIndex = this.myOptionsList.getSelectedIndex();
        this.myListModel.removeAll();
        ArrayList list = ContainerUtil.newArrayList();
        for (EditorSchemeAttributeDescriptor description : this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            list.add(description);
        }
        Collections.sort(list, ATTR_COMPARATOR);
        this.myListModel.add((List)list);
        if (selIndex >= 0) {
            this.myOptionsList.setSelectedIndex(selIndex);
        }
        ListScrollingUtil.ensureSelectionExists((JList)this.myOptionsList);
        Object selected = this.myOptionsList.getSelectedValue();
        if (selected instanceof EditorSchemeAttributeDescriptor) {
            ((ColorAndFontSettingsListener)this.myDispatcher.getMulticaster()).selectedOptionChanged(selected);
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void updateOptionsList() {
        this.fillOptionsList();
        this.processListValueChanged();
    }

    @Override
    public Runnable showOption(String attributeDisplayName) {
        final int index = this.getAttributeIndex(attributeDisplayName, true);
        return index < 0 ? null : new Runnable(){

            @Override
            public void run() {
                ListScrollingUtil.selectItem((JList)OptionsPanelImpl.this.myOptionsList, (int)index);
                OptionsPanelImpl.this.myOptionsList.requestFocus();
            }
        };
    }

    private int getAttributeIndex(final String option, final boolean byDisplayNamePlease) {
        return ContainerUtil.indexOf((List)this.myListModel.getItems(), (Condition)new Condition<EditorSchemeAttributeDescriptor>(){

            public boolean value(EditorSchemeAttributeDescriptor o) {
                return StringUtil.naturalCompare((String)(byDisplayNamePlease ? o.toString() : o.getType()), (String)option) == 0;
            }
        });
    }

    @Override
    public void applyChangesToScheme() {
        Object selectedValue = this.myOptionsList.getSelectedValue();
        if (selectedValue instanceof ColorAndFontDescription) {
            this.myOptionsPanel.apply((ColorAndFontDescription)selectedValue, this.myOptions.getSelectedScheme());
        }
    }

    @Override
    public void selectOption(String attributeType) {
        int index = this.getAttributeIndex(attributeType, false);
        if (index < 0) {
            return;
        }
        ListScrollingUtil.selectItem((JList)this.myOptionsList, (int)index);
    }

    @Override
    public Set<String> processListOptions() {
        EditorSchemeAttributeDescriptor[] descriptions;
        HashSet<String> result = new HashSet<String>();
        for (EditorSchemeAttributeDescriptor description : descriptions = this.myOptions.getCurrentDescriptions()) {
            if (!description.getGroup().equals(this.myCategoryName)) continue;
            result.add(description.toString());
        }
        return result;
    }
}

