/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.AutoPopupController;
import com.intellij.codeInsight.CodeInsightSettings;
import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.TailType;
import com.intellij.codeInsight.completion.CompletionInitializationContext;
import com.intellij.codeInsight.completion.CompletionLocation;
import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.completion.JavaClassNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaClassNameInsertHandler;
import com.intellij.codeInsight.completion.JavaLookupElementBuilder;
import com.intellij.codeInsight.completion.JavaMemberNameCompletionContributor;
import com.intellij.codeInsight.completion.JavaPsiClassReferenceElement;
import com.intellij.codeInsight.completion.JavaSmartCompletionContributor;
import com.intellij.codeInsight.completion.JavaStaticMemberProcessor;
import com.intellij.codeInsight.completion.OffsetKey;
import com.intellij.codeInsight.completion.OffsetMap;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.completion.StaticMemberProcessor;
import com.intellij.codeInsight.completion.impl.CamelHumpMatcher;
import com.intellij.codeInsight.completion.scope.CompletionElement;
import com.intellij.codeInsight.completion.scope.JavaCompletionProcessor;
import com.intellij.codeInsight.completion.util.ParenthesesInsertHandler;
import com.intellij.codeInsight.daemon.impl.analysis.LambdaHighlightingUtil;
import com.intellij.codeInsight.guess.GuessManager;
import com.intellij.codeInsight.lookup.InsertHandlerDecorator;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.codeInsight.lookup.LookupElementRenderer;
import com.intellij.codeInsight.lookup.LookupItem;
import com.intellij.codeInsight.lookup.LookupItemUtil;
import com.intellij.codeInsight.lookup.PsiTypeLookupItem;
import com.intellij.codeInsight.lookup.TypedLookupItem;
import com.intellij.codeInspection.java15api.Java15APIUsageInspectionBase;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableLazyKey;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.patterns.PsiElementPattern;
import com.intellij.patterns.PsiJavaElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportStaticReferenceElement;
import com.intellij.psi.PsiImportStaticStatement;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaReference;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeMapper;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.filters.ElementFilter;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.light.LightVariableBuilder;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.scope.BaseScopeProcessor;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.NameHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.util.PsiScopesUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairConsumer;
import com.intellij.util.PairFunction;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.SideEffectChecker;
import gnu.trove.THashSet;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaCompletionUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInsight.completion.JavaCompletionUtil");
    public static final Key<PairFunction<PsiExpression, CompletionParameters, PsiType>> DYNAMIC_TYPE_EVALUATOR = Key.create((String)"DYNAMIC_TYPE_EVALUATOR");
    private static final Key<PsiType> QUALIFIER_TYPE_ATTR = Key.create((String)"qualifierType");
    public static final OffsetKey LPAREN_OFFSET = OffsetKey.create((String)"lparen");
    public static final OffsetKey RPAREN_OFFSET = OffsetKey.create((String)"rparen");
    public static final OffsetKey ARG_LIST_END_OFFSET = OffsetKey.create((String)"argListEnd");
    static final NullableLazyKey<ExpectedTypeInfo[], CompletionLocation> EXPECTED_TYPES = NullableLazyKey.create((String)"expectedTypes", (NullableFunction)new NullableFunction<CompletionLocation, ExpectedTypeInfo[]>(){

        @Nullable
        public ExpectedTypeInfo[] fun(CompletionLocation location) {
            if (((PsiJavaElementPattern.Capture)PsiJavaPatterns.psiElement().beforeLeaf((ElementPattern)PsiJavaPatterns.psiElement().withText("."))).accepts((Object)location.getCompletionParameters().getPosition())) {
                return ExpectedTypeInfo.EMPTY_ARRAY;
            }
            return JavaSmartCompletionContributor.getExpectedTypes(location.getCompletionParameters());
        }
    });
    private static final ElementPattern<PsiElement> LEFT_PAREN = PlatformPatterns.psiElement((IElementType)JavaTokenType.LPARENTH).andOr(new ElementPattern[]{PlatformPatterns.psiElement().withParent(PsiExpressionList.class), PlatformPatterns.psiElement().afterLeaf(new String[]{".", "new"})});
    public static final Key<Boolean> SUPER_METHOD_PARAMETERS = Key.create((String)"SUPER_METHOD_PARAMETERS");
    public static final Key<List<PsiMethod>> ALL_METHODS_ATTRIBUTE = Key.create((String)"allMethods");

    @Nullable
    public static Set<PsiType> getExpectedTypes(CompletionParameters parameters) {
        PsiExpression expr = (PsiExpression)PsiTreeUtil.getContextOfType((PsiElement)parameters.getPosition(), PsiExpression.class, (boolean)true);
        if (expr != null) {
            THashSet set = new THashSet();
            for (ExpectedTypeInfo expectedInfo : JavaSmartCompletionContributor.getExpectedTypes(parameters)) {
                set.add(expectedInfo.getType());
            }
            return set;
        }
        return null;
    }

    public static PsiType getQualifierType(LookupItem item) {
        return (PsiType)item.getUserData(QUALIFIER_TYPE_ATTR);
    }

    public static void completeVariableNameForRefactoring(Project project, Set<LookupElement> set, String prefix, PsiType varType, VariableKind varKind) {
        CamelHumpMatcher camelHumpMatcher = new CamelHumpMatcher(prefix);
        JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(project, set, camelHumpMatcher, varType, varKind, true, false);
    }

    public static String[] completeVariableNameForRefactoring(JavaCodeStyleManager codeStyleManager, @Nullable PsiType varType, VariableKind varKind, SuggestedNameInfo suggestedNameInfo) {
        return JavaMemberNameCompletionContributor.completeVariableNameForRefactoring(codeStyleManager, new CamelHumpMatcher(""), varType, varKind, suggestedNameInfo, true, false);
    }

    public static boolean isInExcludedPackage(@NotNull PsiMember member, boolean allowInstanceInnerClasses) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/completion/JavaCompletionUtil", "isInExcludedPackage"));
        }
        String name = PsiUtil.getMemberQualifiedName((PsiMember)member);
        if (name == null) {
            return false;
        }
        if (!member.hasModifierProperty("static")) {
            if (member instanceof PsiMethod || member instanceof PsiField) {
                return false;
            }
            if (allowInstanceInnerClasses && member instanceof PsiClass && member.getContainingClass() != null) {
                return false;
            }
        }
        CodeInsightSettings cis = CodeInsightSettings.getInstance();
        for (String excluded : cis.EXCLUDED_PACKAGES) {
            if (!name.equals(excluded) && !name.startsWith(excluded + ".")) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public static <T extends PsiType> T originalize(@NotNull T type) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/codeInsight/completion/JavaCompletionUtil", "originalize"));
        }
        if (!type.isValid()) {
            T t = type;
            if (t == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "originalize"));
            }
            return t;
        }
        T result = new PsiTypeMapper(){

            @Override
            public PsiType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                PsiSubstitutor substitutor = classResolveResult.getSubstitutor();
                if (psiClass == null) {
                    return classType;
                }
                LOG.assertTrue(psiClass.isValid());
                return new PsiImmediateClassType(CompletionUtil.getOriginalOrSelf(psiClass), JavaCompletionUtil.originalize(substitutor));
            }
        }.mapType(type);
        if (result == null) {
            throw new AssertionError((Object)("Null result for type " + type + " of class " + type.getClass()));
        }
        T t = result;
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "originalize"));
        }
        return t;
    }

    @Nullable
    private static PsiSubstitutor originalize(@Nullable PsiSubstitutor substitutor) {
        if (substitutor == null) {
            return null;
        }
        PsiSubstitutor originalSubstitutor = PsiSubstitutor.EMPTY;
        for (Map.Entry entry : substitutor.getSubstitutionMap().entrySet()) {
            PsiType value = (PsiType)entry.getValue();
            originalSubstitutor = originalSubstitutor.put((PsiTypeParameter)CompletionUtil.getOriginalOrSelf((PsiElement)entry.getKey()), value == null ? null : JavaCompletionUtil.originalize(value));
        }
        return originalSubstitutor;
    }

    public static void initOffsets(PsiFile file, OffsetMap offsetMap) {
        int offset = Math.max(offsetMap.getOffset(CompletionInitializationContext.SELECTION_END_OFFSET), offsetMap.getOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET));
        PsiElement element = file.findElementAt(offset);
        if (element instanceof PsiWhiteSpace && (!element.textContains('\n') || CodeStyleSettingsManager.getSettings((Project)file.getProject()).getCommonSettings((Language)JavaLanguage.INSTANCE).METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE)) {
            element = file.findElementAt(element.getTextRange().getEndOffset());
        }
        if (element == null) {
            return;
        }
        if (LEFT_PAREN.accepts((Object)element)) {
            offsetMap.addOffset(LPAREN_OFFSET, element.getTextRange().getStartOffset());
            PsiElement list = element.getParent();
            PsiElement last = list.getLastChild();
            if (last instanceof PsiJavaToken && ((PsiJavaToken)last).getTokenType() == JavaTokenType.RPARENTH) {
                offsetMap.addOffset(RPAREN_OFFSET, last.getTextRange().getStartOffset());
            }
            offsetMap.addOffset(ARG_LIST_END_OFFSET, list.getTextRange().getEndOffset());
        }
    }

    public static void resetParensInfo(OffsetMap offsetMap) {
        offsetMap.removeOffset(LPAREN_OFFSET);
        offsetMap.removeOffset(RPAREN_OFFSET);
        offsetMap.removeOffset(ARG_LIST_END_OFFSET);
        offsetMap.removeOffset(CompletionInitializationContext.IDENTIFIER_END_OFFSET);
    }

    @Nullable
    public static List<? extends PsiElement> getAllPsiElements(LookupElement item) {
        List allMethods = (List)item.getUserData(ALL_METHODS_ATTRIBUTE);
        if (allMethods != null) {
            return allMethods;
        }
        if (item.getObject() instanceof PsiElement) {
            return Arrays.asList((PsiElement)item.getObject());
        }
        return null;
    }

    @Nullable
    private static PsiType getPsiType(Object o) {
        if (o instanceof ResolveResult) {
            return JavaCompletionUtil.getPsiType(((ResolveResult)o).getElement());
        }
        if (o instanceof PsiVariable) {
            return ((PsiVariable)o).getType();
        }
        if (o instanceof PsiMethod) {
            return ((PsiMethod)o).getReturnType();
        }
        if (o instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)o;
            return JavaPsiFacade.getInstance((Project)psiClass.getProject()).getElementFactory().createType(psiClass);
        }
        if (o instanceof PsiExpression) {
            return ((PsiExpression)o).getType();
        }
        return null;
    }

    @Nullable
    public static PsiType getLookupElementType(LookupElement element) {
        TypedLookupItem typed = (TypedLookupItem)element.as(TypedLookupItem.CLASS_CONDITION_KEY);
        if (typed != null) {
            return typed.getType();
        }
        PsiType qualifierType = JavaCompletionUtil.getPsiType(element.getObject());
        LookupItem lookupItem = (LookupItem)element.as(LookupItem.CLASS_CONDITION_KEY);
        if (lookupItem != null) {
            Object o = lookupItem.getAttribute(LookupItem.TYPE);
            if (o instanceof PsiType) {
                return (PsiType)o;
            }
            PsiSubstitutor substitutor = (PsiSubstitutor)lookupItem.getAttribute(LookupItem.SUBSTITUTOR);
            if (substitutor != null) {
                return substitutor.substitute(qualifierType);
            }
        }
        return qualifierType;
    }

    @Nullable
    public static PsiType getQualifiedMemberReferenceType(@Nullable PsiType qualifierType, final @NotNull PsiMember member) {
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/completion/JavaCompletionUtil", "getQualifiedMemberReferenceType"));
        }
        final Ref subst = Ref.create((Object)PsiSubstitutor.EMPTY);
        class MyProcessor
        extends BaseScopeProcessor
        implements NameHint,
        ElementClassHint {
            MyProcessor() {
            }

            public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/completion/JavaCompletionUtil$1MyProcessor", "execute"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/completion/JavaCompletionUtil$1MyProcessor", "execute"));
                }
                if (element == member) {
                    subst.set(state.get(PsiSubstitutor.KEY));
                }
                return true;
            }

            @Override
            public String getName(@NotNull ResolveState state) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/completion/JavaCompletionUtil$1MyProcessor", "getName"));
                }
                return member.getName();
            }

            @Override
            public boolean shouldProcess(ElementClassHint.DeclarationKind kind) {
                return member instanceof PsiEnumConstant ? kind == ElementClassHint.DeclarationKind.ENUM_CONST : (member instanceof PsiField ? kind == ElementClassHint.DeclarationKind.FIELD : kind == ElementClassHint.DeclarationKind.METHOD);
            }

            @Override
            public <T> T getHint(@NotNull Key<T> hintKey) {
                if (hintKey == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hintKey", "com/intellij/codeInsight/completion/JavaCompletionUtil$1MyProcessor", "getHint"));
                }
                return (T)(hintKey == NameHint.KEY || hintKey == ElementClassHint.KEY ? this : null);
            }
        }
        PsiScopesUtil.processTypeDeclarations(qualifierType, (PsiElement)member, new MyProcessor());
        PsiType rawType = member instanceof PsiField ? ((PsiField)member).getType() : (member instanceof PsiMethod ? ((PsiMethod)member).getReturnType() : JavaPsiFacade.getElementFactory((Project)member.getProject()).createType((PsiClass)member));
        return ((PsiSubstitutor)subst.get()).substitute(rawType);
    }

    public static Set<LookupElement> processJavaReference(PsiElement element, PsiJavaReference javaReference, ElementFilter elementFilter, JavaCompletionProcessor.Options options, final PrefixMatcher matcher, CompletionParameters parameters) {
        PsiType plainQualifier;
        LinkedHashSet<LookupElement> set = new LinkedHashSet<LookupElement>();
        Condition<String> nameCondition = new Condition<String>(){

            public boolean value(String s) {
                return matcher.prefixMatches(s);
            }
        };
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethodCallExpression.class);
        boolean checkInitialized = parameters.getInvocationCount() <= 1 && call != null && "super".equals(call.getMethodExpression().getText());
        JavaCompletionProcessor processor = new JavaCompletionProcessor(element, elementFilter, options.withInitialized(checkInitialized), nameCondition);
        PsiType qualifierType = plainQualifier = processor.getQualifierType();
        PsiType runtimeQualifier = JavaCompletionUtil.getQualifierCastType(javaReference, parameters);
        if (runtimeQualifier != null) {
            PsiType composite = qualifierType == null ? runtimeQualifier : PsiIntersectionType.createIntersection((PsiType[])new PsiType[]{qualifierType, runtimeQualifier});
            FakePsiElement ctx = JavaCompletionUtil.createContextWithXxxVariable(element, composite);
            javaReference = (PsiReferenceExpression)JavaPsiFacade.getElementFactory((Project)element.getProject()).createExpressionFromText("xxx.xxx", (PsiElement)ctx);
            qualifierType = runtimeQualifier;
            processor.setQualifierType(qualifierType);
        }
        javaReference.processVariants((PsiScopeProcessor)processor);
        PsiTypeLookupItem castItem = runtimeQualifier == null ? null : PsiTypeLookupItem.createLookupItem(runtimeQualifier, (PsiElement)((PsiReferenceExpression)javaReference));
        boolean pkgContext = JavaCompletionUtil.inSomePackage(element);
        THashSet mentioned = new THashSet();
        for (CompletionElement completionElement : processor.getResults()) {
            for (LookupElement lookupElement : JavaCompletionUtil.createLookupElements(completionElement, javaReference)) {
                lookupElement.putUserData(QUALIFIER_TYPE_ATTR, (Object)qualifierType);
                Object o = lookupElement.getObject();
                if (o instanceof PsiClass && !JavaCompletionUtil.isSourceLevelAccessible(element, (PsiClass)o, pkgContext)) continue;
                if (o instanceof PsiMember) {
                    if (JavaCompletionUtil.isInExcludedPackage((PsiMember)o, true)) continue;
                    mentioned.add(CompletionUtil.getOriginalOrSelf((PsiMember)o));
                }
                set.add(JavaCompletionUtil.highlightIfNeeded(qualifierType, JavaCompletionUtil.castQualifier(lookupElement, castItem, plainQualifier, processor), o, element));
            }
        }
        if (javaReference instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)javaReference).isQualified()) {
            JavaStaticMemberProcessor memberProcessor = new JavaStaticMemberProcessor(parameters);
            memberProcessor.processMembersOfRegisteredClasses(matcher, new PairConsumer<PsiMember, PsiClass>((Set)mentioned, processor, set, (StaticMemberProcessor)memberProcessor){
                final /* synthetic */ Set val$mentioned;
                final /* synthetic */ JavaCompletionProcessor val$processor;
                final /* synthetic */ Set val$set;
                final /* synthetic */ StaticMemberProcessor val$memberProcessor;
                {
                    this.val$mentioned = set;
                    this.val$processor = javaCompletionProcessor;
                    this.val$set = set2;
                    this.val$memberProcessor = staticMemberProcessor;
                }

                public void consume(PsiMember member, PsiClass psiClass) {
                    if (!this.val$mentioned.contains(member) && this.val$processor.satisfies((PsiElement)member, ResolveState.initial())) {
                        this.val$set.add(this.val$memberProcessor.createLookupElement(member, psiClass, true));
                    }
                }
            });
        }
        return set;
    }

    @Nullable
    private static PsiType getQualifierCastType(PsiJavaReference javaReference, CompletionParameters parameters) {
        PsiReferenceExpression refExpr;
        PsiExpression qualifier;
        if (javaReference instanceof PsiReferenceExpression && (qualifier = (refExpr = (PsiReferenceExpression)javaReference).getQualifierExpression()) != null) {
            Project project = qualifier.getProject();
            PsiType type = null;
            PairFunction evaluator = (PairFunction)refExpr.getContainingFile().getCopyableUserData(DYNAMIC_TYPE_EVALUATOR);
            if (evaluator != null) {
                type = (PsiType)evaluator.fun((Object)qualifier, (Object)parameters);
            }
            if (type == null) {
                type = GuessManager.getInstance(project).getControlFlowExpressionType(qualifier);
            }
            return type;
        }
        return null;
    }

    @NotNull
    private static LookupElement castQualifier(@NotNull LookupElement item, final @Nullable PsiTypeLookupItem castTypeItem, @Nullable PsiType plainQualifier, JavaCompletionProcessor processor) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
        }
        if (castTypeItem == null) {
            LookupElement lookupElement = item;
            if (lookupElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
            }
            return lookupElement;
        }
        if (plainQualifier != null) {
            Object o = item.getObject();
            if (o instanceof PsiMethod) {
                PsiType castType = castTypeItem.getPsiType();
                if (plainQualifier instanceof PsiClassType && castType instanceof PsiClassType) {
                    PsiMethod method = (PsiMethod)o;
                    PsiClassType.ClassResolveResult plainResult = ((PsiClassType)plainQualifier).resolveGenerics();
                    PsiClass plainClass = plainResult.getElement();
                    if (plainClass != null && plainClass.findMethodBySignature(method, true) != null) {
                        PsiClass castClass = ((PsiClassType)castType).resolveGenerics().getElement();
                        if (castClass == null || !castClass.isInheritor(plainClass, true)) {
                            LookupElement lookupElement = item;
                            if (lookupElement == null) {
                                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
                            }
                            return lookupElement;
                        }
                        PsiSubstitutor plainSub = plainResult.getSubstitutor();
                        PsiSubstitutor castSub = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)plainClass, (PsiClassType)((PsiClassType)castType));
                        PsiType returnType = method.getReturnType();
                        if (method.getSignature(plainSub).equals(method.getSignature(castSub))) {
                            PsiType typeAfterCast = JavaCompletionUtil.toRaw(castSub.substitute(returnType));
                            PsiType typeDeclared = JavaCompletionUtil.toRaw(plainSub.substitute(returnType));
                            if (typeAfterCast != null && typeDeclared != null && typeAfterCast.isAssignableFrom(typeDeclared) && processor.isAccessible((PsiElement)plainClass.findMethodBySignature(method, true))) {
                                LookupElement lookupElement = item;
                                if (lookupElement == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
                                }
                                return lookupElement;
                            }
                        }
                    }
                }
            } else if (JavaCompletionUtil.containsMember(plainQualifier, o)) {
                LookupElement lookupElement = item;
                if (lookupElement == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
                }
                return lookupElement;
            }
        }
        LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withInsertHandler((LookupElement)item, (InsertHandler)new InsertHandlerDecorator<LookupElement>(){

            public void handleInsert(InsertionContext context, LookupElementDecorator<LookupElement> item) {
                PsiElement qualifier;
                Document document = context.getEditor().getDocument();
                context.commitDocument();
                PsiFile file = context.getFile();
                PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)context.getStartOffset(), PsiJavaCodeReferenceElement.class, (boolean)false);
                if (ref != null && (qualifier = ref.getQualifier()) != null) {
                    CommonCodeStyleSettings settings = context.getCodeStyleSettings();
                    String parenSpace = settings.SPACE_WITHIN_PARENTHESES ? " " : "";
                    document.insertString(qualifier.getTextRange().getEndOffset(), (CharSequence)(parenSpace + ")"));
                    String spaceWithin = settings.SPACE_WITHIN_CAST_PARENTHESES ? " " : "";
                    String prefix = "(" + parenSpace + "(" + spaceWithin;
                    String spaceAfter = settings.SPACE_AFTER_TYPE_CAST ? " " : "";
                    int exprStart = qualifier.getTextRange().getStartOffset();
                    document.insertString(exprStart, (CharSequence)(prefix + spaceWithin + ")" + spaceAfter));
                    CompletionUtil.emulateInsertion(context, exprStart + prefix.length(), (LookupElement)castTypeItem);
                    PsiDocumentManager.getInstance((Project)file.getProject()).doPostponedOperationsAndUnblockDocument(document);
                    context.getEditor().getCaretModel().moveToOffset(context.getTailOffset());
                }
                item.getDelegate().handleInsert(context);
            }
        });
        if (lookupElementDecorator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "castQualifier"));
        }
        return lookupElementDecorator;
    }

    @Nullable
    private static PsiType toRaw(@Nullable PsiType type) {
        return type instanceof PsiClassType ? ((PsiClassType)type).rawType() : type;
    }

    @NotNull
    public static LookupElement highlightIfNeeded(@Nullable PsiType qualifierType, @NotNull LookupElement item, @NotNull Object object, @NotNull PsiElement place) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
        }
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
        }
        if (object instanceof PsiMember && Java15APIUsageInspectionBase.isForbiddenApiUsage((PsiMember)object, PsiUtil.getLanguageLevel((PsiElement)place))) {
            LookupElementDecorator lookupElementDecorator = LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextForeground((Color)JBColor.RED);
                }
            });
            if (lookupElementDecorator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
            }
            return lookupElementDecorator;
        }
        if (JavaCompletionUtil.containsMember(qualifierType, object)) {
            LookupElementRenderer<LookupElementDecorator<LookupElement>> boldRenderer = new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

                public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                    element.getDelegate().renderElement(presentation);
                    presentation.setItemTextBold(true);
                }
            };
            LookupElement lookupElement = PrioritizedLookupElement.withExplicitProximity((LookupElement)LookupElementDecorator.withRenderer((LookupElement)item, (LookupElementRenderer)boldRenderer), (int)1);
            if (lookupElement == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
            }
            return lookupElement;
        }
        LookupElement lookupElement = item;
        if (lookupElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/completion/JavaCompletionUtil", "highlightIfNeeded"));
        }
        return lookupElement;
    }

    public static boolean containsMember(@Nullable PsiType qualifierType, @NotNull Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "object", "com/intellij/codeInsight/completion/JavaCompletionUtil", "containsMember"));
        }
        if (qualifierType instanceof PsiArrayType && object instanceof PsiMember) {
            PsiFile file = ((PsiMember)object).getContainingFile();
            if (file == null || file.getVirtualFile() == null) {
                return true;
            }
        } else if (qualifierType instanceof PsiClassType) {
            PsiClass qualifierClass = ((PsiClassType)qualifierType).resolve();
            if (qualifierClass == null) {
                return false;
            }
            if (object instanceof PsiMethod && qualifierClass.findMethodBySignature((PsiMethod)object, false) != null) {
                return true;
            }
            if (object instanceof PsiMember) {
                return qualifierClass.equals(((PsiMember)object).getContainingClass());
            }
        }
        return false;
    }

    private static LookupElement highlight(LookupElement decorator) {
        return PrioritizedLookupElement.withExplicitProximity((LookupElement)LookupElementDecorator.withRenderer((LookupElement)decorator, (LookupElementRenderer)new LookupElementRenderer<LookupElementDecorator<LookupElement>>(){

            public void renderElement(LookupElementDecorator<LookupElement> element, LookupElementPresentation presentation) {
                element.getDelegate().renderElement(presentation);
                presentation.setItemTextBold(true);
            }
        }), (int)1);
    }

    private static List<? extends LookupElement> createLookupElements(CompletionElement completionElement, PsiJavaReference reference) {
        LookupElement _ret;
        Object completion = completionElement.getElement();
        assert (!(completion instanceof LookupElement));
        if (reference instanceof PsiJavaCodeReferenceElement) {
            if (completion instanceof PsiMethod && ((PsiJavaCodeReferenceElement)reference).getParent() instanceof PsiImportStaticStatement) {
                return Arrays.asList(JavaLookupElementBuilder.forMethod((PsiMethod)completion, PsiSubstitutor.EMPTY));
            }
            if (completion instanceof PsiClass) {
                return JavaClassNameCompletionContributor.createClassLookupItems((PsiClass)completion, JavaClassNameCompletionContributor.AFTER_NEW.accepts((Object)reference), JavaClassNameInsertHandler.JAVA_CLASS_INSERT_HANDLER, (Condition<PsiClass>)Conditions.alwaysTrue());
            }
        }
        if ((_ret = LookupItemUtil.objectToLookupItem(completion)) == null || !(_ret instanceof LookupItem)) {
            return Collections.emptyList();
        }
        PsiSubstitutor substitutor = completionElement.getSubstitutor();
        if (substitutor != null) {
            ((LookupItem)_ret).setAttribute(LookupItem.SUBSTITUTOR, substitutor);
        }
        return Arrays.asList(_ret);
    }

    public static boolean hasAccessibleConstructor(PsiType type) {
        if (type instanceof PsiArrayType) {
            return true;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null || psiClass.isEnum() || psiClass.isAnnotationType()) {
            return false;
        }
        if (!(psiClass instanceof PsiCompiledElement)) {
            return true;
        }
        PsiMethod[] methods = psiClass.getConstructors();
        if (methods.length == 0) {
            return true;
        }
        for (PsiMethod method : methods) {
            if (method.hasModifierProperty("private")) continue;
            return true;
        }
        return false;
    }

    public static LookupItem qualify(LookupItem ret) {
        return ret.forceQualify();
    }

    public static Set<String> getAllLookupStrings(@NotNull PsiMember member) {
        String className;
        if (member == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "member", "com/intellij/codeInsight/completion/JavaCompletionUtil", "getAllLookupStrings"));
        }
        LinkedHashSet allLookupStrings = ContainerUtil.newLinkedHashSet();
        String name = member.getName();
        allLookupStrings.add(name);
        PsiClass containingClass = member.getContainingClass();
        while (containingClass != null && (className = containingClass.getName()) != null) {
            name = className + "." + name;
            allLookupStrings.add(name);
            PsiElement parent = containingClass.getParent();
            if (!(parent instanceof PsiClass)) break;
            containingClass = (PsiClass)parent;
        }
        return allLookupStrings;
    }

    public static LookupItem setShowFQN(LookupItem ret) {
        ret.setAttribute(JavaPsiClassReferenceElement.PACKAGE_NAME, PsiFormatUtil.getPackageDisplayName((PsiClass)((PsiClass)ret.getObject())));
        return ret;
    }

    public static boolean mayHaveSideEffects(@Nullable PsiElement element) {
        return element instanceof PsiExpression && SideEffectChecker.mayHaveSideEffects((PsiExpression)element);
    }

    public static void insertClassReference(@NotNull PsiClass psiClass, @NotNull PsiFile file, int offset) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "com/intellij/codeInsight/completion/JavaCompletionUtil", "insertClassReference"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/completion/JavaCompletionUtil", "insertClassReference"));
        }
        JavaCompletionUtil.insertClassReference(psiClass, file, offset, offset);
    }

    public static int insertClassReference(PsiClass psiClass, PsiFile file, int startOffset, int endOffset) {
        PsiElement parent;
        PsiElement resolved;
        Project project = file.getProject();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        documentManager.commitAllDocuments();
        PsiManager manager = file.getManager();
        Document document = FileDocumentManager.getInstance().getDocument(file.getViewProvider().getVirtualFile());
        PsiReference reference = file.findReferenceAt(startOffset);
        if (reference != null && (resolved = reference.resolve()) instanceof PsiClass && (((PsiClass)resolved).getQualifiedName() == null || manager.areElementsEquivalent((PsiElement)psiClass, resolved))) {
            return endOffset;
        }
        String name = psiClass.getName();
        if (name == null) {
            return endOffset;
        }
        assert (document != null);
        document.replaceString(startOffset, endOffset, (CharSequence)name);
        int newEndOffset = startOffset + name.length();
        RangeMarker toDelete = JavaCompletionUtil.insertTemporary(newEndOffset, document, " ");
        documentManager.commitAllDocuments();
        PsiElement element = file.findElementAt(startOffset);
        if (element instanceof PsiIdentifier && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && !((PsiJavaCodeReferenceElement)parent).isQualified() && !(parent.getParent() instanceof PsiPackageStatement)) {
            PsiJavaCodeReferenceElement ref = (PsiJavaCodeReferenceElement)parent;
            if (psiClass.isValid() && !psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)ref))) {
                boolean staticImport = ref instanceof PsiImportStaticReferenceElement;
                PsiElement newElement = staticImport ? ((PsiImportStaticReferenceElement)ref).bindToTargetClass(psiClass) : ref.bindToElement((PsiElement)psiClass);
                RangeMarker rangeMarker = document.createRangeMarker(newElement.getTextRange());
                documentManager.doPostponedOperationsAndUnblockDocument(document);
                documentManager.commitDocument(document);
                newElement = CodeInsightUtilCore.findElementInRange(file, rangeMarker.getStartOffset(), rangeMarker.getEndOffset(), PsiJavaCodeReferenceElement.class, (Language)JavaLanguage.INSTANCE);
                rangeMarker.dispose();
                if (newElement != null) {
                    String qName;
                    PsiReferenceParameterList parameterList;
                    newEndOffset = newElement.getTextRange().getEndOffset();
                    if (!(newElement instanceof PsiReferenceExpression) && (parameterList = ((PsiJavaCodeReferenceElement)newElement).getParameterList()) != null) {
                        newEndOffset = parameterList.getTextRange().getStartOffset();
                    }
                    if (!(staticImport || psiClass.getManager().areElementsEquivalent((PsiElement)psiClass, JavaCompletionUtil.resolveReference((PsiReference)newElement)) || PsiUtil.isInnerClass((PsiClass)psiClass) || (qName = psiClass.getQualifiedName()) == null)) {
                        document.replaceString(newElement.getTextRange().getStartOffset(), newEndOffset, (CharSequence)qName);
                        newEndOffset = newElement.getTextRange().getStartOffset() + qName.length();
                    }
                }
            }
        }
        if (toDelete.isValid()) {
            document.deleteString(toDelete.getStartOffset(), toDelete.getEndOffset());
        }
        return newEndOffset;
    }

    @Nullable
    static PsiElement resolveReference(PsiReference psiReference) {
        ResolveResult[] results;
        if (psiReference instanceof PsiPolyVariantReference && (results = ((PsiPolyVariantReference)psiReference).multiResolve(true)).length == 1) {
            return results[0].getElement();
        }
        return psiReference.resolve();
    }

    public static RangeMarker insertTemporary(int endOffset, Document document, String temporary) {
        RangeMarker toDelete;
        CharSequence chars = document.getCharsSequence();
        int length = chars.length();
        if (endOffset < length && Character.isJavaIdentifierPart(chars.charAt(endOffset))) {
            document.insertString(endOffset, (CharSequence)temporary);
            toDelete = document.createRangeMarker(endOffset, endOffset + 1);
        } else {
            toDelete = endOffset >= length ? document.createRangeMarker(length, length) : document.createRangeMarker(endOffset, endOffset);
        }
        toDelete.setGreedyToLeft(true);
        toDelete.setGreedyToRight(true);
        return toDelete;
    }

    public static void insertParentheses(InsertionContext context, LookupElement item, boolean overloadsMatter, boolean hasParams) {
        JavaCompletionUtil.insertParentheses(context, item, overloadsMatter, hasParams, false);
    }

    public static void insertParentheses(InsertionContext context, LookupElement item, boolean overloadsMatter, boolean hasParams, boolean forceClosingParenthesis) {
        boolean smart;
        Editor editor = context.getEditor();
        char completionChar = context.getCompletionChar();
        PsiFile file = context.getFile();
        TailType tailType = completionChar == '(' ? TailType.NONE : (completionChar == ':' ? TailType.COND_EXPR_COLON : LookupItem.handleCompletionChar(context.getEditor(), item, completionChar));
        boolean hasTail = tailType != TailType.NONE && tailType != TailType.UNKNOWN;
        boolean bl = smart = completionChar == '\r';
        if (completionChar == '(' || completionChar == '.' || completionChar == ',' || completionChar == ';' || completionChar == ':' || completionChar == ' ') {
            context.setAddCompletionChar(false);
        }
        if (hasTail) {
            hasParams = false;
        }
        boolean needRightParenth = forceClosingParenthesis || !smart && (CodeInsightSettings.getInstance().AUTOINSERT_PAIR_BRACKET || !hasParams && completionChar != '(');
        context.commitDocument();
        CommonCodeStyleSettings styleSettings = context.getCodeStyleSettings();
        PsiElement elementAt = file.findElementAt(context.getStartOffset());
        if (elementAt == null || !(elementAt.getParent() instanceof PsiMethodReferenceExpression)) {
            ParenthesesInsertHandler.getInstance((boolean)hasParams, (boolean)styleSettings.SPACE_BEFORE_METHOD_CALL_PARENTHESES, (styleSettings.SPACE_WITHIN_METHOD_CALL_PARENTHESES && hasParams ? 1 : 0) != 0, (boolean)needRightParenth, (boolean)styleSettings.METHOD_PARAMETERS_LPAREN_ON_NEXT_LINE).handleInsert(context, item);
        }
        if (hasParams) {
            AutoPopupController.getInstance(file.getProject()).autoPopupParameterInfo(editor, overloadsMatter ? null : (PsiElement)item.getObject());
        }
        if (smart || !needRightParenth || !JavaCompletionUtil.insertTail(context, item, tailType, hasTail)) {
            return;
        }
        if (completionChar == '.') {
            AutoPopupController.getInstance(file.getProject()).autoPopupMemberLookup(context.getEditor(), null);
        } else if (completionChar == ',') {
            AutoPopupController.getInstance(file.getProject()).autoPopupParameterInfo(context.getEditor(), null);
        }
    }

    public static boolean insertTail(InsertionContext context, LookupElement item, TailType tailType, boolean hasTail) {
        TailType toInsert = tailType;
        LookupItem lookupItem = (LookupItem)item.as(LookupItem.CLASS_CONDITION_KEY);
        if ((lookupItem == null || lookupItem.getAttribute(LookupItem.TAIL_TYPE_ATTR) != TailType.UNKNOWN) && !hasTail && item.getObject() instanceof PsiMethod && ((PsiMethod)item.getObject()).getReturnType() == PsiType.VOID) {
            PsiDocumentManager.getInstance((Project)context.getProject()).commitAllDocuments();
            if (((PsiElementPattern.Capture)PlatformPatterns.psiElement().beforeLeaf((ElementPattern)PlatformPatterns.psiElement().withText("."))).accepts((Object)context.getFile().findElementAt(context.getTailOffset() - 1))) {
                return false;
            }
            boolean insertAdditionalSemicolon = true;
            PsiReferenceExpression referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getTopmostParentOfType((PsiElement)context.getFile().findElementAt(context.getStartOffset()), PsiReferenceExpression.class);
            if (referenceExpression instanceof PsiMethodReferenceExpression && LambdaHighlightingUtil.insertSemicolon(referenceExpression.getParent())) {
                insertAdditionalSemicolon = false;
            } else if (referenceExpression != null) {
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiMethodCallExpression) {
                    parent = parent.getParent();
                }
                if (parent instanceof PsiLambdaExpression && !LambdaHighlightingUtil.insertSemicolonAfter((PsiLambdaExpression)parent)) {
                    insertAdditionalSemicolon = false;
                }
            }
            if (insertAdditionalSemicolon) {
                toInsert = TailType.SEMICOLON;
            }
        }
        toInsert.processTail(context.getEditor(), context.getTailOffset());
        return true;
    }

    public static void shortenReference(PsiFile file, int offset) throws IncorrectOperationException {
        PsiElement element;
        Project project = file.getProject();
        PsiDocumentManager manager = PsiDocumentManager.getInstance((Project)project);
        Document document = manager.getDocument(file);
        manager.commitDocument(document);
        PsiReference ref = file.findReferenceAt(offset);
        if (ref != null && (element = ref.getElement()) != null) {
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(element);
            PsiDocumentManager.getInstance((Project)project).doPostponedOperationsAndUnblockDocument(document);
        }
    }

    public static boolean inSomePackage(PsiElement context) {
        PsiFile contextFile = context.getContainingFile();
        return contextFile instanceof PsiClassOwner && StringUtil.isNotEmpty((String)((PsiClassOwner)contextFile).getPackageName());
    }

    public static boolean isSourceLevelAccessible(PsiElement context, PsiClass psiClass, boolean pkgContext) {
        String fqName;
        PsiClass topLevel;
        if (!JavaPsiFacade.getInstance((Project)psiClass.getProject()).getResolveHelper().isAccessible((PsiMember)psiClass, context, null)) {
            return false;
        }
        return !pkgContext || (topLevel = PsiUtil.getTopLevelClass((PsiElement)psiClass)) == null || (fqName = topLevel.getQualifiedName()) == null || !StringUtil.isEmpty((String)StringUtil.getPackageName((String)fqName));
    }

    public static boolean promptTypeArgs(InsertionContext context, int offset) {
        if (offset < 0) {
            return false;
        }
        OffsetKey key = context.trackOffset(offset, false);
        PostprocessReformattingAspect.getInstance(context.getProject()).doPostponedFormatting();
        offset = context.getOffset(key);
        if (offset < 0) {
            return false;
        }
        String open = JavaCompletionUtil.escapeXmlIfNeeded(context, "<");
        context.getDocument().insertString(offset, (CharSequence)open);
        context.getEditor().getCaretModel().moveToOffset(offset + open.length());
        context.getDocument().insertString(offset + open.length(), (CharSequence)JavaCompletionUtil.escapeXmlIfNeeded(context, ">"));
        context.setAddCompletionChar(false);
        return true;
    }

    public static FakePsiElement createContextWithXxxVariable(final PsiElement place, final PsiType varType) {
        return new FakePsiElement(){

            @Override
            public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place2) {
                if (processor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/codeInsight/completion/JavaCompletionUtil$9", "processDeclarations"));
                }
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/codeInsight/completion/JavaCompletionUtil$9", "processDeclarations"));
                }
                if (place2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/intellij/codeInsight/completion/JavaCompletionUtil$9", "processDeclarations"));
                }
                return processor.execute(new LightVariableBuilder("xxx", varType, place2), ResolveState.initial());
            }

            public PsiElement getParent() {
                return place;
            }
        };
    }

    public static String escapeXmlIfNeeded(InsertionContext context, String generics) {
        if (context.getFile().getViewProvider().getBaseLanguage() == StdLanguages.JSPX) {
            return StringUtil.escapeXml((String)generics);
        }
        return generics;
    }
}

