/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.quickfix;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.actions.AddImportAction;
import com.intellij.codeInsight.daemon.impl.quickfix.AddModuleDependencyFix;
import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ex.JavaSdkUtil;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.openapi.roots.ExportableOrderEntry;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.OrderEntryUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiShortNamesCache;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.Function;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OrderEntryFix
implements IntentionAction,
LocalQuickFix {
    OrderEntryFix() {
    }

    public boolean startInWriteAction() {
        return true;
    }

    @NotNull
    public String getName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "applyFix"));
        }
        this.invoke(project, null, descriptor.getPsiElement().getContainingFile());
    }

    @Nullable
    public static List<LocalQuickFix> registerFixes(@NotNull QuickFixActionRegistrar registrar, final @NotNull PsiReference reference) {
        if (registrar == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "registerFixes"));
        }
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "registerFixes"));
        }
        PsiElement psiElement = reference.getElement();
        final String referenceName = reference.getRangeInElement().substring(psiElement.getText());
        Project project = psiElement.getProject();
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile == null) {
            return null;
        }
        VirtualFile classVFile = containingFile.getVirtualFile();
        if (classVFile == null) {
            return null;
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
        final Module currentModule = fileIndex.getModuleForFile(classVFile);
        if (currentModule == null) {
            return null;
        }
        if ("TestCase".equals(referenceName) || OrderEntryFix.isAnnotation(psiElement) && OrderEntryFix.isJunitAnnotationName(referenceName, psiElement)) {
            final boolean isJunit4 = !referenceName.equals("TestCase");
            final String className = isJunit4 ? "org.junit." + referenceName : "junit.framework.TestCase";
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, currentModule.getModuleWithDependenciesAndLibrariesScope(true));
            if (found != null) {
                return null;
            }
            OrderEntryFix fix = new OrderEntryFix(){

                @NotNull
                public String getText() {
                    String string = QuickFixBundle.message("orderEntry.fix.add.junit.jar.to.classpath", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1", "getText"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1", "getFamilyName"));
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1", "isAvailable"));
                    }
                    return !project.isDisposed() && !currentModule.isDisposed();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$1", "invoke"));
                    }
                    if (isJunit4) {
                        VirtualFile location = PsiUtilCore.getVirtualFile((PsiElement)reference.getElement());
                        boolean inTests = location != null && ModuleRootManager.getInstance((Module)currentModule).getFileIndex().isInTestSourceContent(location);
                        try {
                            1.addJUnit4Library(inTests, currentModule);
                            GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
                            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
                            if (aClass == null || editor == null || DumbService.isDumb((Project)project)) return;
                            new AddImportAction(project, reference, editor, aClass).execute();
                            return;
                        }
                        catch (ClassNotFoundException e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        1.addBundledJarToRoots(project, editor, currentModule, reference, className, JavaSdkUtil.getJunit3JarPath());
                    }
                }
            };
            registrar.register((IntentionAction)fix);
            return Arrays.asList(fix);
        }
        if (OrderEntryFix.isAnnotation(psiElement) && AnnotationUtil.isJetbrainsAnnotation((String)referenceName)) {
            String className = "org.jetbrains.annotations." + referenceName;
            PsiClass found = JavaPsiFacade.getInstance((Project)project).findClass(className, currentModule.getModuleWithDependenciesAndLibrariesScope(true));
            if (found != null) {
                return null;
            }
            OrderEntryFix fix = new OrderEntryFix(){

                @NotNull
                public String getText() {
                    String string = QuickFixBundle.message("orderEntry.fix.add.annotations.jar.to.classpath", new Object[0]);
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2", "getText"));
                    }
                    return string;
                }

                @NotNull
                public String getFamilyName() {
                    String string = this.getText();
                    if (string == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2", "getFamilyName"));
                    }
                    return string;
                }

                public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2", "isAvailable"));
                    }
                    return !project.isDisposed() && !currentModule.isDisposed();
                }

                public void invoke(final @NotNull Project project, final Editor editor, PsiFile file) {
                    if (project == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$2", "invoke"));
                    }
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            final LocateLibraryDialog dialog = new LocateLibraryDialog(currentModule, PathManager.getLibPath(), "annotations.jar", QuickFixBundle.message("add.library.annotations.description", new Object[0]));
                            if (dialog.showAndGet()) {
                                new WriteCommandAction(project, new PsiFile[0]){

                                    protected void run(Result result) throws Throwable {
                                        OrderEntryFix.addBundledJarToRoots(project, editor, currentModule, reference, "org.jetbrains.annotations." + referenceName, dialog.getResultingLibraryPath());
                                    }
                                }.execute();
                            }
                        }
                    });
                }
            };
            registrar.register((IntentionAction)fix);
            return Arrays.asList(fix);
        }
        ArrayList<LocalQuickFix> result = new ArrayList<LocalQuickFix>();
        THashSet librariesToAdd = new THashSet();
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)psiElement.getProject());
        PsiClass[] classes = PsiShortNamesCache.getInstance((Project)project).getClassesByName(referenceName, GlobalSearchScope.allScope((Project)project));
        List<PsiClass> allowedDependencies = OrderEntryFix.filterAllowedDependencies(psiElement, classes);
        if (allowedDependencies.isEmpty()) {
            return result;
        }
        classes = allowedDependencies.toArray(new PsiClass[allowedDependencies.size()]);
        AddModuleDependencyFix moduleDependencyFix = new AddModuleDependencyFix(currentModule, classVFile, classes, reference);
        registrar.register((IntentionAction)moduleDependencyFix);
        result.add(moduleDependencyFix);
        for (final PsiClass aClass : classes) {
            VirtualFile virtualFile;
            PsiFile psiFile;
            if (!facade.getResolveHelper().isAccessible((PsiMember)aClass, psiElement, aClass) || (psiFile = aClass.getContainingFile()) == null || (virtualFile = psiFile.getVirtualFile()) == null) continue;
            ModuleFileIndex moduleFileIndex = ModuleRootManager.getInstance((Module)currentModule).getFileIndex();
            for (OrderEntry orderEntry : fileIndex.getOrderEntriesForFile(virtualFile)) {
                OrderEntry entryForFile;
                VirtualFile jar;
                VirtualFile[] files;
                LibraryOrderEntry libraryEntry;
                Library library;
                if (!(orderEntry instanceof LibraryOrderEntry) || (library = (libraryEntry = (LibraryOrderEntry)orderEntry).getLibrary()) == null || (files = library.getFiles(OrderRootType.CLASSES)).length == 0 || (jar = files[0]) == null || libraryEntry.isModuleLevel() && !librariesToAdd.add(jar) || !librariesToAdd.add(library) || (entryForFile = moduleFileIndex.getOrderEntryForFile(virtualFile)) != null && (!(entryForFile instanceof ExportableOrderEntry) || ((ExportableOrderEntry)entryForFile).getScope() != DependencyScope.TEST || ModuleRootManager.getInstance((Module)currentModule).getFileIndex().isInTestSourceContent(classVFile))) continue;
                OrderEntryFix fix = new OrderEntryFix(){

                    @NotNull
                    public String getText() {
                        String string = QuickFixBundle.message("orderEntry.fix.add.library.to.classpath", libraryEntry.getPresentableName());
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3", "getText"));
                        }
                        return string;
                    }

                    @NotNull
                    public String getFamilyName() {
                        String string = QuickFixBundle.message("orderEntry.fix.family.add.library.to.classpath", new Object[0]);
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3", "getFamilyName"));
                        }
                        return string;
                    }

                    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3", "isAvailable"));
                        }
                        return !project.isDisposed() && !currentModule.isDisposed() && libraryEntry.isValid();
                    }

                    public void invoke(@NotNull Project project, @Nullable Editor editor, PsiFile file) {
                        if (project == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix$3", "invoke"));
                        }
                        OrderEntryUtil.addLibraryToRoots(libraryEntry, currentModule);
                        if (editor != null && !DumbService.isDumb((Project)project)) {
                            new AddImportAction(project, reference, editor, aClass).execute();
                        }
                    }
                };
                registrar.register((IntentionAction)fix);
                result.add(fix);
            }
        }
        return result;
    }

    public static void addJUnit4Library(boolean inTests, Module currentModule) throws ClassNotFoundException {
        Object[] junit4Paths = new String[]{JavaSdkUtil.getJunit4JarPath(), PathUtil.getJarPathForClass(Class.forName("org.hamcrest.Matcher")), PathUtil.getJarPathForClass(Class.forName("org.hamcrest.Matchers"))};
        ModuleRootModificationUtil.addModuleLibrary((Module)currentModule, (String)"JUnit4", (List)ContainerUtil.map((Object[])junit4Paths, (Function)new Function<String, String>(){

            public String fun(String libPath) {
                return OrderEntryFix.convertToLibraryRoot(libPath).getUrl();
            }
        }), Collections.emptyList(), (DependencyScope)(inTests ? DependencyScope.TEST : DependencyScope.COMPILE));
    }

    private static List<PsiClass> filterAllowedDependencies(PsiElement element, PsiClass[] classes) {
        DependencyValidationManager dependencyValidationManager = DependencyValidationManager.getInstance((Project)element.getProject());
        PsiFile fromFile = element.getContainingFile();
        ArrayList<PsiClass> result = new ArrayList<PsiClass>();
        for (PsiClass psiClass : classes) {
            if (dependencyValidationManager.getViolatorDependencyRule(fromFile, psiClass.getContainingFile()) != null) continue;
            result.add(psiClass);
        }
        return result;
    }

    private static boolean isAnnotation(PsiElement psiElement) {
        return PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class) != null && PsiUtil.isLanguageLevel5OrHigher((PsiElement)psiElement);
    }

    private static boolean isJunitAnnotationName(@NonNls String referenceName, @NotNull PsiElement psiElement) {
        PsiReference reference;
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "isJunitAnnotationName"));
        }
        if ("Test".equals(referenceName) || "Ignore".equals(referenceName) || "RunWith".equals(referenceName) || "Before".equals(referenceName) || "BeforeClass".equals(referenceName) || "After".equals(referenceName) || "AfterClass".equals(referenceName)) {
            return true;
        }
        PsiElement parent = psiElement.getParent();
        if (parent != null && !(parent instanceof PsiAnnotation) && (reference = parent.getReference()) != null) {
            String referenceText = parent.getText();
            if (OrderEntryFix.isJunitAnnotationName(reference.getRangeInElement().substring(referenceText), parent)) {
                int lastDot = referenceText.lastIndexOf(46);
                return lastDot > -1 && referenceText.substring(0, lastDot).equals("org.junit");
            }
        }
        return false;
    }

    public static void addBundledJarToRoots(Project project, @Nullable Editor editor, Module currentModule, @Nullable PsiReference reference, @NonNls String className, @NonNls String libVirtFile) {
        OrderEntryFix.addJarToRoots(libVirtFile, currentModule, reference != null ? reference.getElement() : null);
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        GlobalSearchScope scope = GlobalSearchScope.moduleWithLibrariesScope((Module)currentModule);
        PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(className, scope);
        if (aClass != null && editor != null && reference != null) {
            new AddImportAction(project, reference, editor, aClass).execute();
        }
    }

    public static void addJarToRoots(String libPath, Module module, @Nullable PsiElement location) {
        VirtualFile vFile;
        VirtualFile libVirtFile = OrderEntryFix.convertToLibraryRoot(libPath);
        boolean inTests = false;
        if (location != null && (vFile = location.getContainingFile().getVirtualFile()) != null && ModuleRootManager.getInstance((Module)module).getFileIndex().isInTestSourceContent(vFile)) {
            inTests = true;
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module, null, Collections.singletonList(libVirtFile.getUrl()), Collections.emptyList(), (DependencyScope)(inTests ? DependencyScope.TEST : DependencyScope.COMPILE));
    }

    @NotNull
    private static VirtualFile convertToLibraryRoot(String libPath) {
        File libraryRoot = new File(libPath);
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(libraryRoot);
        String url = VfsUtil.getUrlForLibraryRoot((File)libraryRoot);
        VirtualFile libVirtFile = VirtualFileManager.getInstance().findFileByUrl(url);
        assert (libVirtFile != null) : libPath;
        VirtualFile virtualFile = libVirtFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/daemon/impl/quickfix/OrderEntryFix", "convertToLibraryRoot"));
        }
        return virtualFile;
    }

    public static boolean ensureAnnotationsJarInPath(final Module module) {
        if (OrderEntryFix.isAnnotationsJarInPath(module)) {
            return true;
        }
        if (module == null) {
            return false;
        }
        final LocateLibraryDialog dialog = new LocateLibraryDialog(module, PathManager.getLibPath(), "annotations.jar", QuickFixBundle.message("add.library.annotations.description", new Object[0]));
        if (dialog.showAndGet()) {
            new WriteCommandAction(module.getProject(), new PsiFile[0]){

                protected void run(Result result) throws Throwable {
                    OrderEntryFix.addJarToRoots(dialog.getResultingLibraryPath(), module, null);
                }
            }.execute();
            return true;
        }
        return false;
    }

    public static boolean isAnnotationsJarInPath(Module module) {
        if (module == null) {
            return false;
        }
        return JavaPsiFacade.getInstance((Project)module.getProject()).findClass("org.intellij.lang.annotations.Language", GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) != null;
    }
}

