/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions;

import com.intellij.codeInsight.documentation.DocCommentFixer;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.lang.LanguageDocumentation;
import com.intellij.lang.documentation.CodeDocumentationProvider;
import com.intellij.lang.documentation.CompositeDocumentationProvider;
import com.intellij.lang.documentation.DocumentationProvider;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorAction;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.util.text.CharArrayUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FixDocCommentAction
extends EditorAction {
    @NotNull
    @NonNls
    public static final String ACTION_ID = "FixDocComment";

    public FixDocCommentAction() {
        super((EditorActionHandler)new MyHandler());
    }

    private static void process(@NotNull PsiFile file, @NotNull Editor editor, @NotNull Project project, int offset) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "process"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "process"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "process"));
        }
        PsiElement elementAtOffset = file.findElementAt(offset);
        if (elementAtOffset == null) {
            return;
        }
        FixDocCommentAction.generateOrFixComment(elementAtOffset, project, editor);
    }

    public static void generateOrFixComment(@NotNull PsiElement element, final @NotNull Project project, final @NotNull Editor editor) {
        Runnable task;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateOrFixComment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateOrFixComment"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateOrFixComment"));
        }
        Language language = element.getLanguage();
        DocumentationProvider langDocumentationProvider = LanguageDocumentation.INSTANCE.forLanguage(language);
        Object docProvider = langDocumentationProvider instanceof CompositeDocumentationProvider ? ((CompositeDocumentationProvider)langDocumentationProvider).getFirstCodeDocumentationProvider() : (langDocumentationProvider instanceof CodeDocumentationProvider ? (CodeDocumentationProvider)langDocumentationProvider : null);
        if (docProvider == null) {
            return;
        }
        final Pair pair = docProvider.parseContext(element);
        if (pair == null) {
            return;
        }
        Commenter c = (Commenter)LanguageCommenters.INSTANCE.forLanguage(language);
        if (!(c instanceof CodeDocumentationAwareCommenter)) {
            return;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)c;
        if (pair.second == null || ((PsiComment)pair.second).getTextRange().isEmpty()) {
            task = new Runnable((CodeDocumentationProvider)docProvider, commenter, project){
                final /* synthetic */ CodeDocumentationProvider val$docProvider;
                final /* synthetic */ CodeDocumentationAwareCommenter val$commenter;
                final /* synthetic */ Project val$project;
                {
                    this.val$docProvider = codeDocumentationProvider;
                    this.val$commenter = codeDocumentationAwareCommenter;
                    this.val$project = project;
                }

                @Override
                public void run() {
                    FixDocCommentAction.generateComment((PsiElement)pair.first, editor, this.val$docProvider, this.val$commenter, this.val$project);
                }
            };
        } else {
            final DocCommentFixer fixer = (DocCommentFixer)DocCommentFixer.EXTENSION.forLanguage(language);
            if (fixer == null) {
                return;
            }
            task = new Runnable(){

                @Override
                public void run() {
                    fixer.fixComment(project, editor, (PsiComment)pair.second);
                }
            };
        }
        Runnable command = new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().runWriteAction(task);
            }
        };
        CommandProcessor.getInstance().executeCommand(project, command, "Fix documentation", null);
    }

    private static void generateComment(@NotNull PsiElement anchor, @NotNull Editor editor, @NotNull CodeDocumentationProvider documentationProvider, @NotNull CodeDocumentationAwareCommenter commenter, @NotNull Project project) {
        char c;
        String linePrefix;
        int commentStartOffset;
        if (anchor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateComment"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateComment"));
        }
        if (documentationProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentationProvider", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateComment"));
        }
        if (commenter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commenter", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateComment"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "generateComment"));
        }
        Document document = editor.getDocument();
        int lineStartOffset = document.getLineStartOffset(document.getLineNumber(commentStartOffset = anchor.getTextRange().getStartOffset()));
        if (lineStartOffset > 0 && lineStartOffset < commentStartOffset) {
            int nonWhiteSpaceOffset = CharArrayUtil.shiftBackward((CharSequence)document.getCharsSequence(), (int)(commentStartOffset - 1), (String)" \t");
            commentStartOffset = Math.max(nonWhiteSpaceOffset, lineStartOffset);
        }
        int commentBodyRelativeOffset = 0;
        int caretOffsetToSet = -1;
        StringBuilder buffer = new StringBuilder();
        String commentPrefix = commenter.getDocumentationCommentPrefix();
        if (commentPrefix != null) {
            buffer.append(commentPrefix).append("\n");
            commentBodyRelativeOffset += commentPrefix.length() + 1;
        }
        if ((linePrefix = commenter.getDocumentationCommentLinePrefix()) != null) {
            buffer.append(linePrefix);
            caretOffsetToSet = commentStartOffset + (commentBodyRelativeOffset += linePrefix.length());
        }
        buffer.append("\n");
        ++commentBodyRelativeOffset;
        String commentSuffix = commenter.getDocumentationCommentSuffix();
        if (commentSuffix != null) {
            buffer.append(commentSuffix).append("\n");
        }
        if (buffer.length() <= 0) {
            return;
        }
        document.insertString(commentStartOffset, (CharSequence)buffer);
        PsiDocumentManager docManager = PsiDocumentManager.getInstance((Project)project);
        docManager.commitDocument(document);
        Pair pair = documentationProvider.parseContext(anchor);
        if (pair == null || pair.second == null) {
            return;
        }
        String stub = documentationProvider.generateDocumentationContentStub((PsiComment)pair.second);
        CaretModel caretModel = editor.getCaretModel();
        if (stub != null) {
            int insertionOffset = commentStartOffset + commentBodyRelativeOffset;
            document.insertString(insertionOffset, (CharSequence)stub);
            docManager.commitDocument(document);
            pair = documentationProvider.parseContext(anchor);
        }
        if (caretOffsetToSet >= 0) {
            caretModel.moveToOffset(caretOffsetToSet);
        }
        if (pair == null || pair.second == null) {
            return;
        }
        int start = Math.min(FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.first), FixDocCommentAction.calcStartReformatOffset((PsiElement)pair.second));
        int end = ((PsiComment)pair.second).getTextRange().getEndOffset();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        codeStyleManager.reformatText(anchor.getContainingFile(), start, end);
        int caretOffset = caretModel.getOffset();
        if (caretOffset > 0 && caretOffset <= document.getTextLength() && !StringUtil.isWhiteSpace((char)(c = document.getCharsSequence().charAt(caretOffset - 1)))) {
            document.insertString(caretOffset, (CharSequence)" ");
            caretModel.moveToOffset(caretOffset + 1);
        }
    }

    private static int calcStartReformatOffset(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/editorActions/FixDocCommentAction", "calcStartReformatOffset"));
        }
        int result = element.getTextRange().getStartOffset();
        for (PsiElement e = element.getPrevSibling(); e != null && e instanceof PsiWhiteSpace; e = e.getPrevSibling()) {
            result = e.getTextRange().getStartOffset();
        }
        return result;
    }

    private static final class MyHandler
    extends EditorActionHandler {
        private MyHandler() {
        }

        public void execute(Editor editor, DataContext dataContext) {
            Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
            if (project == null) {
                return;
            }
            PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
            if (psiFile == null) {
                return;
            }
            FixDocCommentAction.process(psiFile, editor, project, editor.getCaretModel().getOffset());
        }
    }
}

