/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.intention.impl;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.impl.BaseColorIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiExpressionPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.patterns.PsiMethodPattern;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.ui.ColorChooser;
import com.intellij.ui.JBColor;
import com.intellij.util.IncorrectOperationException;
import java.awt.Color;
import java.awt.Component;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ColorChooserIntentionAction
extends BaseColorIntentionAction {
    private static final PsiMethodPattern DECODE_METHOD = (PsiMethodPattern)PsiJavaPatterns.psiMethod().definedInClass("java.awt.Color").withName("decode");
    private static final PsiExpressionPattern.Capture<PsiExpression> DECODE_METHOD_CALL_PARAMETER = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)DECODE_METHOD);
    private static final PsiMethodPattern GET_COLOR_METHOD = (PsiMethodPattern)PsiJavaPatterns.psiMethod().definedInClass("java.awt.Color").withName("getColor");
    private static final PsiExpressionPattern.Capture<PsiExpression> GET_METHOD_CALL_PARAMETER = (PsiExpressionPattern.Capture)PsiJavaPatterns.psiExpression().methodCallParameter(0, (ElementPattern)GET_COLOR_METHOD);

    public ColorChooserIntentionAction() {
        this.setText(CodeInsightBundle.message((String)"intention.color.chooser.dialog", (Object[])new Object[0]));
    }

    @Override
    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction", "isAvailable"));
        }
        return super.isAvailable(project, editor, element) || ColorChooserIntentionAction.isInsideDecodeOrGetColorMethod(element);
    }

    public static boolean isInsideDecodeOrGetColorMethod(PsiElement element) {
        if (element instanceof PsiJavaToken && ((PsiJavaToken)element).getTokenType() == JavaTokenType.STRING_LITERAL) {
            element = element.getParent();
        }
        return DECODE_METHOD_CALL_PARAMETER.accepts((Object)element) || GET_METHOD_CALL_PARAMETER.accepts((Object)element);
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction", "getFamilyName"));
        }
        return string;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/codeInsight/intention/impl/ColorChooserIntentionAction", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementForWrite(element)) {
            return;
        }
        JComponent editorComponent = editor.getComponent();
        if (ColorChooserIntentionAction.isInsideDecodeOrGetColorMethod(element)) {
            this.invokeForMethodParam(editorComponent, element);
        } else {
            this.invokeForConstructor(editorComponent, element);
        }
    }

    private void invokeForMethodParam(JComponent editorComponent, PsiElement element) {
        Color oldColor;
        int radix;
        PsiLiteralExpression literal = (PsiLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiLiteralExpression.class);
        if (literal == null) {
            return;
        }
        String text = StringUtil.unquoteString((String)literal.getText());
        int n = text.startsWith("0x") || text.startsWith("0X") || text.startsWith("#") ? 16 : (radix = text.startsWith("0") ? 8 : 10);
        String hexPrefix = radix == 16 ? (text.startsWith("#") ? "#" : text.substring(0, 2)) : null;
        try {
            oldColor = Color.decode(text);
        }
        catch (NumberFormatException e) {
            oldColor = JBColor.GRAY;
        }
        Color color = ColorChooser.chooseColor((Component)editorComponent, (String)this.getText(), (Color)oldColor, (boolean)true);
        if (color == null) {
            return;
        }
        int rgb = color.getRGB() - -16777216;
        if (color != null && rgb != oldColor.getRGB()) {
            String newText = radix == 16 ? hexPrefix + String.format("%6s", Integer.toHexString(rgb)).replace(' ', '0') : (radix == 8 ? "0" + Integer.toOctalString(rgb) : Integer.toString(rgb));
            PsiManager manager = literal.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiExpression newLiteral = factory.createExpressionFromText("\"" + newText + "\"", (PsiElement)literal);
            literal.replace((PsiElement)newLiteral);
        }
    }

    private void invokeForConstructor(JComponent editorComponent, PsiElement element) {
        PsiNewExpression expression = (PsiNewExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiNewExpression.class);
        if (expression == null) {
            return;
        }
        Object c = null;
        PsiExpressionList argumentList = expression.getArgumentList();
        if (argumentList != null) {
            PsiExpression[] expressions = argumentList.getExpressions();
            int[] values = new int[expressions.length];
            float[] values2 = new float[expressions.length];
            int i = 0;
            int j = 0;
            for (PsiExpression each : expressions) {
                if (!(each instanceof PsiLiteralExpression)) continue;
                Object o = ((PsiLiteralExpression)each).getValue();
                if (o instanceof Integer) {
                    values[i] = (Integer)o;
                    ++i;
                    continue;
                }
                if (!(o instanceof Float)) continue;
                values2[j] = ((Float)o).floatValue();
                ++j;
            }
            try {
                if (i == expressions.length) {
                    switch (values.length) {
                        case 1: {
                            c = new Color(values[0]);
                            break;
                        }
                        case 3: {
                            c = new Color(values[0], values[1], values[2]);
                            break;
                        }
                        case 4: {
                            c = new Color(values[0], values[1], values[2], values[3]);
                            break;
                        }
                    }
                } else if (j == expressions.length) {
                    switch (values2.length) {
                        case 3: {
                            c = new Color(values2[0], values2[1], values2[2]);
                            break;
                        }
                        case 4: {
                            c = new Color(values2[0], values2[1], values2[2], values2[3]);
                            break;
                        }
                    }
                }
            }
            catch (Exception e) {
                c = JBColor.GRAY;
            }
        }
        c = c == null ? JBColor.GRAY : c;
        this.replaceColor(editorComponent, expression, (Color)c);
    }

    private void replaceColor(JComponent editorComponent, PsiNewExpression expression, Color oldColor) {
        Color color = ColorChooser.chooseColor((Component)editorComponent, (String)this.getText(), (Color)oldColor, (boolean)true);
        if (color != null) {
            PsiManager manager = expression.getManager();
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
            PsiExpression newCall = factory.createExpressionFromText("new " + ColorChooserIntentionAction.getFqn(expression.getClassOrAnonymousClassReference()) + "(" + color.getRed() + ", " + color.getGreen() + ", " + color.getBlue() + (color.getAlpha() < 255 ? ", " + color.getAlpha() : "") + ")", (PsiElement)expression);
            PsiElement insertedElement = expression.replace((PsiElement)newCall);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)manager.getProject());
            codeStyleManager.reformat(insertedElement);
        }
    }
}

