/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project, @NotNull Document document, @NotNull VirtualFile file) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        super(document, file.getFileType(), file, FileDocumentContentImpl.getSeparator(file), file.getCharset());
        this.myProject = project;
        this.myFile = file;
    }

    @Override
    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        if (this.myProject == null) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile, offset);
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "getSeparator"));
        }
        String s = LoadTextUtil.detectLineSeparator(file, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileDocumentContentImpl", "getFile"));
        }
        return virtualFile;
    }
}

