/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.binary;

import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.impl.FocusOppositePaneAction;
import com.intellij.diff.contents.BinaryFileContent;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.binary.BinaryContentPanel;
import com.intellij.diff.tools.binary.BinaryDiffPanel;
import com.intellij.diff.tools.util.base.ListenerDiffViewerBase;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorProviderManager;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileTypes.UIBasedFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.AnimatedIcon;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryDiffViewer
extends ListenerDiffViewerBase {
    public static final Logger LOG = Logger.getInstance(BinaryDiffViewer.class);
    @NotNull
    private final BinaryDiffPanel myPanel;
    @NotNull
    private final BinaryContentPanel myContentPanel;
    @NotNull
    private final MyStatusPanel myStatusPanel;
    @Nullable
    private final FileEditor myEditor1;
    @Nullable
    private final FileEditor myEditor2;
    @Nullable
    private final FileEditorProvider myEditorProvider1;
    @Nullable
    private final FileEditorProvider myEditorProvider2;
    @Nullable
    private final MyEditorFocusListener myEditorFocusListener1;
    @Nullable
    private final MyEditorFocusListener myEditorFocusListener2;
    @NotNull
    private Side myCurrentSide;

    public BinaryDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/BinaryDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myCurrentSide = Side.LEFT;
        List<JComponent> titlePanel = DiffUtil.createSimpleTitles(this.myRequest);
        Couple<Pair<FileEditor, FileEditorProvider>> editors = this.createEditors();
        this.myEditor1 = (FileEditor)((Pair)editors.first).first;
        this.myEditorProvider1 = (FileEditorProvider)((Pair)editors.first).second;
        this.myEditor2 = (FileEditor)((Pair)editors.second).first;
        this.myEditorProvider2 = (FileEditorProvider)((Pair)editors.second).second;
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myEditorFocusListener1 = new MyEditorFocusListener(Side.LEFT);
            this.myEditorFocusListener2 = new MyEditorFocusListener(Side.RIGHT);
        } else {
            this.myEditorFocusListener1 = null;
            this.myEditorFocusListener2 = null;
        }
        this.myContentPanel = new BinaryContentPanel(titlePanel, this.myEditor1, this.myEditor2);
        this.myPanel = new BinaryDiffPanel(this, this.myContentPanel, this, context);
        if (this.myEditor1 == null && this.myEditor2 == null) {
            this.myPanel.setErrorContent();
        }
        this.myStatusPanel = new MyStatusPanel();
        new MyFocusOppositePaneAction().setupAction(this.myPanel, (Disposable)this);
        this.installEditorListeners();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.processContextHints();
    }

    @Override
    public void onDispose() {
        this.updateContextHints();
        this.destroyEditorListeners();
        this.destroyEditors();
        super.onDispose();
    }

    private void processContextHints() {
        if (this.myEditor1 == null) {
            this.myCurrentSide = Side.RIGHT;
        } else if (this.myEditor2 == null) {
            this.myCurrentSide = Side.LEFT;
        } else {
            Side side = (Side)this.myContext.getUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE);
            if (side != null) {
                this.myCurrentSide = side;
            }
        }
    }

    private void updateContextHints() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myContext.putUserData(DiffUserDataKeys.PREFERRED_FOCUS_SIDE, (Object)this.myCurrentSide);
        }
    }

    @NotNull
    protected Couple<Pair<FileEditor, FileEditorProvider>> createEditors() {
        Couple couple;
        List contents = this.myRequest.getContents();
        try {
            Pair<FileEditor, FileEditorProvider> pair1 = this.createEditor((DiffContent)contents.get(0));
            Pair<FileEditor, FileEditorProvider> pair2 = this.createEditor((DiffContent)contents.get(1));
            couple = Couple.of(pair1, pair2);
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
            Pair empty = Pair.empty();
            Couple couple2 = Couple.of((Object)empty, (Object)empty);
            if (couple2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditors"));
            }
            return couple2;
        }
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditors"));
        }
        return couple;
    }

    @NotNull
    private Pair<FileEditor, FileEditorProvider> createEditor(@NotNull DiffContent content) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
        }
        if (content instanceof EmptyContent) {
            Pair pair = Pair.empty();
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        if (content instanceof BinaryFileContent) {
            Project project = this.myProject != null ? this.myProject : ProjectManager.getInstance().getDefaultProject();
            VirtualFile file = ((BinaryFileContent)content).getFile();
            FileEditorProvider[] providers = FileEditorProviderManager.getInstance().getProviders(project, file);
            if (providers.length == 0) {
                throw new IOException("Can't find FileEditorProvider");
            }
            FileEditorProvider provider = providers[0];
            FileEditor editor = provider.createEditor(project, file);
            UIUtil.removeScrollBorder((Component)editor.getComponent());
            Pair pair = Pair.create((Object)editor, (Object)provider);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        if (content instanceof DocumentContent) {
            Document document = ((DocumentContent)content).getDocument();
            final EditorEx editor = DiffUtil.createEditor(document, this.myProject, true);
            TextEditorProvider provider = TextEditorProvider.getInstance();
            TextEditor fileEditor = provider.getTextEditor(editor);
            Disposer.register((Disposable)fileEditor, (Disposable)new Disposable(){

                public void dispose() {
                    EditorFactory.getInstance().releaseEditor(editor);
                }
            });
            Pair pair = Pair.create((Object)fileEditor, (Object)provider);
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "createEditor"));
            }
            return pair;
        }
        throw new IllegalArgumentException(content.getClass() + " - " + content.toString());
    }

    private void destroyEditors() {
        if (this.myEditor1 != null) {
            assert (this.myEditorProvider1 != null);
            this.myEditorProvider1.disposeEditor(this.myEditor1);
        }
        if (this.myEditor2 != null) {
            assert (this.myEditorProvider2 != null);
            this.myEditorProvider2.disposeEditor(this.myEditor2);
        }
    }

    private void installEditorListeners() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myEditor1.getComponent().addFocusListener(this.myEditorFocusListener1);
            this.myEditor2.getComponent().addFocusListener(this.myEditorFocusListener2);
        }
    }

    private void destroyEditorListeners() {
        if (this.myEditor1 != null && this.myEditor2 != null) {
            this.myEditor1.getComponent().removeFocusListener(this.myEditorFocusListener1);
            this.myEditor2.getComponent().removeFocusListener(this.myEditorFocusListener2);
        }
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        block15: {
            List contents;
            block13: {
                Runnable runnable2;
                block14: {
                    block11: {
                        Runnable runnable3;
                        block12: {
                            block9: {
                                Runnable runnable4;
                                block10: {
                                    if (indicator == null) {
                                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                                    }
                                    indicator.checkCanceled();
                                    contents = this.myRequest.getContents();
                                    if (!(contents.get(0) instanceof EmptyContent)) break block9;
                                    runnable4 = new Runnable(){

                                        @Override
                                        public void run() {
                                            BinaryDiffViewer.this.clearDiffPresentation();
                                            BinaryDiffViewer.this.myPanel.addInsertedContentNotification();
                                        }
                                    };
                                    if (runnable4 != null) break block10;
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                                }
                                return runnable4;
                            }
                            if (!(contents.get(1) instanceof EmptyContent)) break block11;
                            runnable3 = new Runnable(){

                                @Override
                                public void run() {
                                    BinaryDiffViewer.this.clearDiffPresentation();
                                    BinaryDiffViewer.this.myPanel.addRemovedContentNotification();
                                }
                            };
                            if (runnable3 != null) break block12;
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                        }
                        return runnable3;
                    }
                    if (contents.get(0) instanceof BinaryFileContent && contents.get(1) instanceof BinaryFileContent) break block13;
                    runnable2 = new Runnable(){

                        @Override
                        public void run() {
                            BinaryDiffViewer.this.clearDiffPresentation();
                        }
                    };
                    if (runnable2 != null) break block14;
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            try {
                BinaryFileContent content1 = (BinaryFileContent)contents.get(0);
                BinaryFileContent content2 = (BinaryFileContent)contents.get(1);
                byte[] bytes1 = content1.getBytes();
                byte[] bytes2 = content2.getBytes();
                final boolean equal = Arrays.equals(bytes1, bytes2);
                runnable = new Runnable(){

                    @Override
                    public void run() {
                        BinaryDiffViewer.this.clearDiffPresentation();
                        if (equal) {
                            BinaryDiffViewer.this.myPanel.addContentsEqualNotification();
                        }
                    }
                };
                if (runnable != null) break block15;
            }
            catch (ProcessCanceledException ignore) {
                Runnable runnable5 = new Runnable(){

                    @Override
                    public void run() {
                        BinaryDiffViewer.this.clearDiffPresentation();
                        BinaryDiffViewer.this.myPanel.addOperationCanceledNotification();
                    }
                };
                if (runnable5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                }
                return runnable5;
            }
            catch (Throwable e) {
                LOG.error(e);
                Runnable runnable6 = new Runnable(){

                    @Override
                    public void run() {
                        BinaryDiffViewer.this.clearDiffPresentation();
                        BinaryDiffViewer.this.myPanel.addDiffErrorNotification();
                    }
                };
                if (runnable6 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
                }
                return runnable6;
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "performRediff"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
    }

    @NotNull
    public JComponent getComponent() {
        BinaryDiffPanel binaryDiffPanel = this.myPanel;
        if (binaryDiffPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getComponent"));
        }
        return binaryDiffPanel;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myPanel.getPreferredFocusedComponent();
    }

    @NotNull
    Side getCurrentSide() {
        Side side = this.myCurrentSide;
        if (side == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getCurrentSide"));
        }
        return side;
    }

    @Nullable
    FileEditor getEditor2() {
        return this.myEditor2;
    }

    @Nullable
    FileEditor getEditor1() {
        return this.myEditor1;
    }

    @Nullable
    FileEditor getCurrentEditor() {
        return (FileEditor)this.getCurrentSide().select((Object)this.myEditor1, (Object)this.myEditor2);
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        MyStatusPanel myStatusPanel = this.myStatusPanel;
        if (myStatusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/binary/BinaryDiffViewer", "getStatusPanel"));
        }
        return myStatusPanel;
    }

    @Override
    protected boolean tryRediffSynchronously() {
        return this.myPanel.isWindowFocused();
    }

    @Override
    @Nullable
    protected OpenFileDescriptor getOpenFileDescriptor() {
        ContentDiffRequest request = this.getRequest();
        FileEditor editor = this.getCurrentEditor();
        if (editor == null) {
            return null;
        }
        DiffContent content = (DiffContent)this.getCurrentSide().selectNotNull(request.getContents());
        return content.getOpenFileDescriptor();
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowRequest"));
        }
        if (!(request instanceof ContentDiffRequest)) {
            return false;
        }
        List contents = ((ContentDiffRequest)request).getContents();
        if (contents.size() != 2) {
            return false;
        }
        if (!BinaryDiffViewer.canShowContent((DiffContent)contents.get(0), context)) {
            return false;
        }
        if (!BinaryDiffViewer.canShowContent((DiffContent)contents.get(1), context)) {
            return false;
        }
        return BinaryDiffViewer.wantShowContent((DiffContent)contents.get(0), context) || BinaryDiffViewer.wantShowContent((DiffContent)contents.get(1), context);
    }

    public static boolean canShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowContent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "canShowContent"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof BinaryFileContent) {
            Project project = context.getProject();
            if (project == null) {
                project = ProjectManager.getInstance().getDefaultProject();
            }
            VirtualFile file = ((BinaryFileContent)content).getFile();
            return FileEditorProviderManager.getInstance().getProviders(project, file).length != 0;
        }
        return false;
    }

    public static boolean wantShowContent(@NotNull DiffContent content, @NotNull DiffContext context) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/binary/BinaryDiffViewer", "wantShowContent"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/binary/BinaryDiffViewer", "wantShowContent"));
        }
        if (content instanceof EmptyContent) {
            return false;
        }
        if (content instanceof DocumentContent) {
            return false;
        }
        if (content instanceof BinaryFileContent) {
            if (content.getContentType() == null) {
                return false;
            }
            if (content.getContentType().isBinary()) {
                return true;
            }
            return content.getContentType() instanceof UIBasedFileType;
        }
        return false;
    }

    private class MyEditorFocusListener
    extends FocusAdapter {
        @NotNull
        private final Side mySide;

        private MyEditorFocusListener(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/binary/BinaryDiffViewer$MyEditorFocusListener", "<init>"));
            }
            this.mySide = side;
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (BinaryDiffViewer.this.myEditor1 == null || BinaryDiffViewer.this.myEditor2 == null) {
                return;
            }
            BinaryDiffViewer.this.myCurrentSide = this.mySide;
        }
    }

    private static class MyStatusPanel
    extends JPanel {
        private final AnimatedIcon myBusySpinner = new AsyncProcessIcon("StatusPanelSpinner");

        public MyStatusPanel() {
            super(new BorderLayout());
            this.myBusySpinner.setVisible(false);
            this.add((Component)this.myBusySpinner, "West");
        }

        public void setBusy(boolean busy) {
            if (busy) {
                this.myBusySpinner.setVisible(true);
                this.myBusySpinner.resume();
            } else {
                this.myBusySpinner.setVisible(false);
                this.myBusySpinner.suspend();
            }
        }
    }

    private class MyFocusOppositePaneAction
    extends FocusOppositePaneAction {
        private MyFocusOppositePaneAction() {
        }

        @Override
        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/BinaryDiffViewer$MyFocusOppositePaneAction", "actionPerformed"));
            }
            assert (BinaryDiffViewer.this.myEditor1 != null && BinaryDiffViewer.this.myEditor2 != null);
            BinaryDiffViewer.this.myCurrentSide = BinaryDiffViewer.this.myCurrentSide.other();
            BinaryDiffViewer.this.myPanel.requestFocus();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/binary/BinaryDiffViewer$MyFocusOppositePaneAction", "update"));
            }
            e.getPresentation().setEnabled(BinaryDiffViewer.this.myEditor1 != null && BinaryDiffViewer.this.myEditor2 != null);
        }
    }
}

