/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.external;

import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DirectoryContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.EmptyContent;
import com.intellij.diff.contents.FileContent;
import com.intellij.diff.tools.external.ExternalDiffSettings;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineTokenizer;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalDiffToolUtil {
    public static boolean canCreateFile(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "canCreateFile"));
        }
        if (content instanceof EmptyContent) {
            return true;
        }
        if (content instanceof DocumentContent) {
            return true;
        }
        if (content instanceof FileContent) {
            return true;
        }
        if (content instanceof DirectoryContent) {
            return ((DirectoryContent)content).getFile().isInLocalFileSystem();
        }
        return false;
    }

    @NotNull
    public static String createFile(@NotNull DiffContent content, @NotNull String title, @Nullable String windowTitle) throws IOException {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (content instanceof EmptyContent) {
            String string = ExternalDiffToolUtil.createFile(new byte[0], "empty").getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof FileContent) {
            VirtualFile file = ((FileContent)content).getFile();
            if (file.isInLocalFileSystem()) {
                String string = file.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return string;
            }
            byte[] bytes = file.contentsToByteArray();
            String string = ExternalDiffToolUtil.createFile(bytes, ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType())).getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof DocumentContent) {
            Charset charset;
            final DocumentContent documentContent = (DocumentContent)content;
            FileDocumentManager.getInstance().saveDocument(documentContent.getDocument());
            LineSeparator separator = documentContent.getLineSeparator();
            if (separator == null) {
                separator = LineSeparator.getSystemLineSeparator();
            }
            if ((charset = documentContent.getCharset()) == null) {
                charset = Charset.defaultCharset();
            }
            String contentData = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return documentContent.getDocument().getText();
                }
            });
            if (separator != LineSeparator.LF) {
                contentData = StringUtil.convertLineSeparators((String)contentData, (String)separator.getSeparatorString());
            }
            byte[] bytes = contentData.getBytes(charset);
            String string = ExternalDiffToolUtil.createFile(bytes, ExternalDiffToolUtil.getFileName(title, windowTitle, content.getContentType())).getPath();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
            }
            return string;
        }
        if (content instanceof DirectoryContent) {
            VirtualFile file = ((DirectoryContent)content).getFile();
            if (file.isInLocalFileSystem()) {
                String string = file.getPath();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
                }
                return string;
            }
            throw new IllegalArgumentException(content.toString());
        }
        throw new IllegalArgumentException(content.toString());
    }

    @NotNull
    public static String getFileName(@NotNull String title, @Nullable String windowTitle, @Nullable FileType fileType) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "getFileName"));
        }
        String ext = fileType != null ? fileType.getDefaultExtension() : ".tmp";
        String string = title + "." + ext;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "getFileName"));
        }
        return string;
    }

    @NotNull
    public static File createFile(@NotNull byte[] bytes, @NotNull String name) throws IOException {
        if (bytes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bytes", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        File tempFile = FileUtil.createTempFile((String)"tmp_", (String)("_" + name), (boolean)true);
        FileUtil.writeToFile((File)tempFile, (byte[])bytes);
        File file = tempFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "createFile"));
        }
        return file;
    }

    public static void execute(@NotNull ExternalDiffSettings settings, @NotNull List<DiffContent> contents, @NotNull List<String> titles, @Nullable String windowTitle) throws IOException, ExecutionException {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        if (titles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "titles", "com/intellij/diff/tools/external/ExternalDiffToolUtil", "execute"));
        }
        assert (contents.size() == 2 || contents.size() == 3);
        assert (titles.size() == contents.size());
        ArrayList<String> files = new ArrayList<String>();
        for (int i = 0; i < contents.size(); ++i) {
            files.add(ExternalDiffToolUtil.createFile(contents.get(i), titles.get(i), windowTitle));
        }
        CommandLineTokenizer parameterTokenizer = new CommandLineTokenizer(settings.getDiffParameters(), true);
        ArrayList args = new ArrayList();
        while (parameterTokenizer.hasMoreTokens()) {
            String arg = parameterTokenizer.nextToken();
            if ("%1".equals(arg)) {
                args.add(files.get(0));
                continue;
            }
            if ("%2".equals(arg)) {
                if (files.size() == 3) {
                    args.add(files.get(2));
                    continue;
                }
                args.add(files.get(1));
                continue;
            }
            if ("%3".equals(arg)) {
                if (files.size() != 3) continue;
                args.add(files.get(1));
                continue;
            }
            args.add(arg);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setExePath(settings.getDiffExePath());
        commandLine.addParameters(args);
        commandLine.createProcess();
    }
}

