/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.fragments.DiffFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.diff.util.TextDiffType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.markup.SeparatorPlacement;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnesideDiffChange {
    @NotNull
    private final EditorEx myEditor;
    private final int myStartOffset1;
    private final int myEndOffset1;
    private final int myStartOffset2;
    private final int myEndOffset2;
    private final int myLine1;
    private final int myLine2;
    @Nullable
    private final List<DiffFragment> myInnerFragments;
    @NotNull
    private final List<RangeHighlighter> myHighlighters;

    public OnesideDiffChange(@NotNull EditorEx editor, @NotNull ChangedBlock block) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "<init>"));
        }
        if (block == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "<init>"));
        }
        this.myHighlighters = new ArrayList<RangeHighlighter>();
        this.myEditor = editor;
        this.myStartOffset1 = block.getStartOffset1();
        this.myEndOffset1 = block.getEndOffset1();
        this.myStartOffset2 = block.getStartOffset2();
        this.myEndOffset2 = block.getEndOffset2();
        this.myLine1 = block.getLine1();
        this.myLine2 = block.getLine2();
        this.myInnerFragments = block.getInnerFragments();
        this.installHighlighter();
    }

    public void destroyHighlighter() {
        for (RangeHighlighter highlighter : this.myHighlighters) {
            highlighter.dispose();
        }
        this.myHighlighters.clear();
    }

    public void installHighlighter() {
        assert (this.myHighlighters.isEmpty());
        if (this.myInnerFragments != null) {
            this.doInstallHighlighterWithInner();
        } else {
            this.doInstallHighlighterSimple();
        }
    }

    private void doInstallHighlighterSimple() {
        this.createLineHighlighters(false);
    }

    private void doInstallHighlighterWithInner() {
        assert (this.myInnerFragments != null);
        this.createLineHighlighters(true);
        for (DiffFragment fragment : this.myInnerFragments) {
            this.createInlineHighlighter(TextDiffType.DELETED, this.getStartOffset1() + fragment.getStartOffset1(), this.getStartOffset1() + fragment.getEndOffset1());
            this.createInlineHighlighter(TextDiffType.INSERTED, this.getStartOffset2() + fragment.getStartOffset2(), this.getStartOffset2() + fragment.getEndOffset2());
        }
    }

    private void createLineHighlighters(boolean ignored) {
        boolean insertion = this.hasInsertion();
        boolean deletion = this.hasDeletion();
        if (insertion && deletion) {
            this.createLineMarker(TextDiffType.DELETED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.DELETED, this.getStartOffset1(), this.getEndOffset1(), ignored);
            this.createHighlighter(TextDiffType.INSERTED, this.getStartOffset2(), this.getEndOffset2(), ignored);
            this.createLineMarker(TextDiffType.INSERTED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        } else if (insertion) {
            this.createLineMarker(TextDiffType.INSERTED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.INSERTED, this.getStartOffset2(), this.getEndOffset2(), ignored);
            this.createLineMarker(TextDiffType.INSERTED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        } else if (deletion) {
            this.createLineMarker(TextDiffType.DELETED, this.getLine1(), SeparatorPlacement.TOP);
            this.createHighlighter(TextDiffType.DELETED, this.getStartOffset1(), this.getEndOffset1(), ignored);
            this.createLineMarker(TextDiffType.DELETED, this.getLine2() - 1, SeparatorPlacement.BOTTOM);
        }
    }

    private void createHighlighter(@NotNull TextDiffType type, int start, int end, boolean ignored) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "createHighlighter"));
        }
        this.myHighlighters.add(DiffDrawUtil.createHighlighter(this.myEditor, start, end, type, ignored));
    }

    private void createInlineHighlighter(@NotNull TextDiffType type, int start, int end) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "createInlineHighlighter"));
        }
        this.myHighlighters.add(DiffDrawUtil.createInlineHighlighter(this.myEditor, start, end, type));
    }

    private void createLineMarker(@NotNull TextDiffType type, int line, @NotNull SeparatorPlacement placement) {
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "createLineMarker"));
        }
        if (placement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "placement", "com/intellij/diff/tools/fragmented/OnesideDiffChange", "createLineMarker"));
        }
        this.myHighlighters.add(DiffDrawUtil.createLineMarker(this.myEditor, line, type, placement));
    }

    public int getStartOffset1() {
        return this.myStartOffset1;
    }

    public int getEndOffset1() {
        return this.myEndOffset1;
    }

    public int getStartOffset2() {
        return this.myStartOffset2;
    }

    public int getEndOffset2() {
        return this.myEndOffset2;
    }

    public int getLine1() {
        return this.myLine1;
    }

    public int getLine2() {
        return this.myLine2;
    }

    private boolean hasInsertion() {
        return this.myStartOffset2 != this.myEndOffset2;
    }

    private boolean hasDeletion() {
        return this.myStartOffset1 != this.myEndOffset1;
    }
}

