/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.fragmented;

import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.tools.fragmented.ChangedBlock;
import com.intellij.diff.tools.fragmented.HighlightRange;
import com.intellij.diff.tools.fragmented.LineNumberConvertor;
import com.intellij.diff.util.Side;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.TextRange;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OnesideFragmentBuilder {
    @NotNull
    private final List<LineFragment> myFragments;
    @NotNull
    private final Document myDocument1;
    @NotNull
    private final Document myDocument2;
    private final boolean myInlineFragments;
    @NotNull
    private final Side myMasterSide;
    @NotNull
    private final StringBuilder myBuilder;
    @NotNull
    private final List<ChangedBlock> myBlocks;
    @NotNull
    private final List<HighlightRange> myRanges;
    @NotNull
    private final LineNumberConvertor.Builder myConvertor;
    @NotNull
    private final List<DiffIterableUtil.IntPair> myChangedLines;
    private boolean myEqual;
    private int lastProcessedLine1;
    private int lastProcessedLine2;
    private int totalLines;

    public OnesideFragmentBuilder(@NotNull List<LineFragment> fragments, @NotNull Document document1, @NotNull Document document2, boolean inlineFragments, @NotNull Side masterSide) {
        if (fragments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragments", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "<init>"));
        }
        if (document1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document1", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "<init>"));
        }
        if (document2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document2", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "<init>"));
        }
        if (masterSide == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "masterSide", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "<init>"));
        }
        this.myBuilder = new StringBuilder();
        this.myBlocks = new ArrayList<ChangedBlock>();
        this.myRanges = new ArrayList<HighlightRange>();
        this.myConvertor = new LineNumberConvertor.Builder();
        this.myChangedLines = new ArrayList<DiffIterableUtil.IntPair>();
        this.myEqual = false;
        this.lastProcessedLine1 = -1;
        this.lastProcessedLine2 = -1;
        this.totalLines = 0;
        this.myFragments = fragments;
        this.myDocument1 = document1;
        this.myDocument2 = document2;
        this.myInlineFragments = inlineFragments;
        this.myMasterSide = masterSide;
    }

    public void exec() {
        if (this.myFragments.isEmpty()) {
            this.myEqual = true;
            this.appendTextMaster(0, 0, OnesideFragmentBuilder.getLineCount(this.myDocument1) - 1, OnesideFragmentBuilder.getLineCount(this.myDocument2) - 1);
            return;
        }
        for (LineFragment fragment : this.myFragments) {
            this.processEquals(fragment.getStartLine1() - 1, fragment.getStartLine2() - 1);
            this.processChanged(fragment);
        }
        this.processEquals(OnesideFragmentBuilder.getLineCount(this.myDocument1) - 1, OnesideFragmentBuilder.getLineCount(this.myDocument1) - 2);
    }

    private void processEquals(int endLine1, int endLine2) {
        int startLine1 = this.lastProcessedLine1 + 1;
        int startLine2 = this.lastProcessedLine2 + 1;
        this.appendTextMaster(startLine1, startLine2, endLine1, endLine2);
    }

    private void processChanged(@NotNull LineFragment fragment) {
        int endOffset;
        int startOffset;
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "processChanged"));
        }
        int startLine1 = fragment.getStartLine1();
        int endLine1 = fragment.getEndLine1() - 1;
        int lines1 = endLine1 - startLine1;
        int startLine2 = fragment.getStartLine2();
        int endLine2 = fragment.getEndLine2() - 1;
        int lines2 = endLine2 - startLine2;
        int linesBefore = this.totalLines;
        int blockStartOffset1 = this.myBuilder.length();
        if (lines1 >= 0) {
            startOffset = this.myDocument1.getLineStartOffset(startLine1);
            endOffset = this.myDocument1.getLineEndOffset(endLine1);
            this.appendTextSide(Side.LEFT, startOffset, endOffset, lines1, startLine1, -1);
        }
        int blockEndOffset1 = this.myBuilder.length();
        int blockStartOffset2 = this.myBuilder.length();
        if (lines2 >= 0) {
            startOffset = this.myDocument2.getLineStartOffset(startLine2);
            endOffset = this.myDocument2.getLineEndOffset(endLine2);
            this.appendTextSide(Side.RIGHT, startOffset, endOffset, lines2, -1, startLine2);
        }
        int blockEndOffset2 = this.myBuilder.length();
        int linesAfter = this.totalLines;
        List innerFragments = this.myInlineFragments ? fragment.getInnerFragments() : null;
        this.myBlocks.add(new ChangedBlock(blockStartOffset1, blockEndOffset1, blockStartOffset2, blockEndOffset2, linesBefore, linesAfter, innerFragments));
        this.lastProcessedLine1 = endLine1;
        this.lastProcessedLine2 = endLine2;
    }

    private void appendTextMaster(int startLine1, int startLine2, int endLine1, int endLine2) {
        int lines;
        int n = lines = this.myMasterSide.isLeft() ? endLine1 - startLine1 : endLine2 - startLine2;
        if (lines >= 0) {
            int startOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineStartOffset(startLine1) : this.myDocument2.getLineStartOffset(startLine2);
            int endOffset = this.myMasterSide.isLeft() ? this.myDocument1.getLineEndOffset(endLine1) : this.myDocument2.getLineEndOffset(endLine2);
            this.appendText(this.myMasterSide, startOffset, endOffset, lines, startLine1, startLine2);
        }
    }

    private void appendTextSide(@NotNull Side side, int offset1, int offset2, int lines, int startLine1, int startLine2) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "appendTextSide"));
        }
        int linesBefore = this.totalLines;
        this.appendText(side, offset1, offset2, lines, startLine1, startLine2);
        int linesAfter = this.totalLines;
        this.myChangedLines.add(new DiffIterableUtil.IntPair(linesBefore, linesAfter));
    }

    private void appendText(@NotNull Side side, int offset1, int offset2, int lines, int startLine1, int startLine2) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "appendText"));
        }
        Document document = (Document)side.selectNotNull((Object)this.myDocument1, (Object)this.myDocument2);
        int newline = document.getTextLength() > offset2 + 1 ? 1 : 0;
        TextRange base = new TextRange(this.myBuilder.length(), this.myBuilder.length() + offset2 - offset1 + newline);
        TextRange changed = new TextRange(offset1, offset2 + newline);
        this.myRanges.add(new HighlightRange(side, base, changed));
        this.myBuilder.append(document.getCharsSequence().subSequence(offset1, offset2));
        this.myBuilder.append('\n');
        if (startLine1 != -1) {
            this.myConvertor.put1(this.totalLines, startLine1, lines + 1);
        }
        if (startLine2 != -1) {
            this.myConvertor.put2(this.totalLines, startLine2, lines + 1);
        }
        this.totalLines += lines + 1;
    }

    private static int getLineCount(@NotNull Document document) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getLineCount"));
        }
        return Math.max(document.getLineCount(), 1);
    }

    public boolean isEqual() {
        return this.myEqual;
    }

    @NotNull
    public CharSequence getText() {
        StringBuilder stringBuilder = this.myBuilder;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getText"));
        }
        return stringBuilder;
    }

    @NotNull
    public List<ChangedBlock> getBlocks() {
        List<ChangedBlock> list = this.myBlocks;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getBlocks"));
        }
        return list;
    }

    @NotNull
    public List<HighlightRange> getRanges() {
        List<HighlightRange> list = this.myRanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getRanges"));
        }
        return list;
    }

    @NotNull
    public LineNumberConvertor getConvertor() {
        LineNumberConvertor lineNumberConvertor = this.myConvertor.build();
        if (lineNumberConvertor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getConvertor"));
        }
        return lineNumberConvertor;
    }

    @NotNull
    public List<DiffIterableUtil.IntPair> getChangedLines() {
        List<DiffIterableUtil.IntPair> list = this.myChangedLines;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/fragmented/OnesideFragmentBuilder", "getChangedLines"));
        }
        return list;
    }
}

