/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.simple;

import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.diff.DiffContext;
import com.intellij.diff.actions.BufferedLineIterator;
import com.intellij.diff.actions.NavigationContextChecker;
import com.intellij.diff.comparison.DiffTooBigException;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.fragments.LineFragment;
import com.intellij.diff.fragments.LineFragmentImpl;
import com.intellij.diff.requests.ContentDiffRequest;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.tools.simple.SimpleDiffChange;
import com.intellij.diff.tools.util.BaseSyncScrollable;
import com.intellij.diff.tools.util.DiffDataKeys;
import com.intellij.diff.tools.util.DiffSplitter;
import com.intellij.diff.tools.util.FoldingModelSupport;
import com.intellij.diff.tools.util.PrevNextDifferenceIterable;
import com.intellij.diff.tools.util.StatusPanel;
import com.intellij.diff.tools.util.SyncScrollSupport;
import com.intellij.diff.tools.util.base.HighlightPolicy;
import com.intellij.diff.tools.util.base.TextDiffViewerBase;
import com.intellij.diff.tools.util.twoside.TwosideTextDiffViewer;
import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.DiffUtil;
import com.intellij.diff.util.Side;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.DiffNavigationContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.LightweightHint;
import com.intellij.util.Function;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleDiffViewer
extends TwosideTextDiffViewer {
    public static final Logger LOG = Logger.getInstance(SimpleDiffViewer.class);
    @NotNull
    private final SyncScrollSupport.SyncScrollable mySyncScrollable;
    @NotNull
    private final PrevNextDifferenceIterable myPrevNextDifferenceIterable;
    @NotNull
    private final StatusPanel myStatusPanel;
    @NotNull
    private final List<SimpleDiffChange> myDiffChanges;
    @NotNull
    private final List<SimpleDiffChange> myInvalidDiffChanges;
    @Nullable
    private final MyFoldingModel myFoldingModel;
    @NotNull
    private final ModifierProvider myModifierProvider;

    public SimpleDiffViewer(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "<init>"));
        }
        super(context, (ContentDiffRequest)request);
        this.myDiffChanges = new ArrayList<SimpleDiffChange>();
        this.myInvalidDiffChanges = new ArrayList<SimpleDiffChange>();
        this.mySyncScrollable = new MySyncScrollable();
        this.myPrevNextDifferenceIterable = new MyPrevNextDifferenceIterable();
        this.myStatusPanel = new MyStatusPanel();
        this.myFoldingModel = this.createFoldingModel(this.myEditor1, this.myEditor2);
        this.myModifierProvider = new ModifierProvider();
    }

    @Override
    protected void onInit() {
        super.onInit();
        this.myContentPanel.setPainter(new MyDividerPainter());
    }

    @Override
    protected void onDisposeAwt() {
        this.destroyChangedBlocks();
        super.onDisposeAwt();
    }

    @Override
    @NotNull
    protected List<AnAction> createToolbarActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)new TextDiffViewerBase.IgnorePolicySettingAction(this));
        group.add((AnAction)new TextDiffViewerBase.HighlightPolicySettingAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)this.myEditorSettingsAction);
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createToolbarActions"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    protected List<AnAction> createPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.IgnorePolicySettingAction(this).getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.HighlightPolicySettingAction(this).getPopupGroup());
        group.add((AnAction)Separator.getInstance());
        group.add((AnAction)new TextDiffViewerBase.ToggleAutoScrollAction(this));
        group.add((AnAction)new MyToggleExpandByDefaultAction());
        return group;
    }

    @Override
    @NotNull
    protected List<AnAction> createEditorPopupActions() {
        ArrayList<AnAction> group = new ArrayList<AnAction>();
        group.add(new ReplaceSelectedChangesAction());
        group.add(new AppendSelectedChangesAction());
        group.add(new RevertSelectedChangesAction());
        group.add((AnAction)Separator.getInstance());
        group.addAll(super.createEditorPopupActions());
        ArrayList<AnAction> arrayList = group;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "createEditorPopupActions"));
        }
        return arrayList;
    }

    @Nullable
    private MyFoldingModel createFoldingModel(@Nullable EditorEx editor1, @Nullable EditorEx editor2) {
        if (editor1 == null || editor2 == null) {
            return null;
        }
        return new MyFoldingModel(editor1, editor2, (Disposable)this);
    }

    @Override
    protected void updateContextHints() {
        super.updateContextHints();
        if (this.myFoldingModel != null) {
            this.myFoldingModel.updateContext((UserDataHolder)this.myRequest, this.getTextSettings().isExpandByDefault());
        }
    }

    @Override
    protected void onSlowRediff() {
        super.onSlowRediff();
        this.myStatusPanel.setBusy(true);
    }

    @Override
    @NotNull
    protected Runnable performRediff(@NotNull ProgressIndicator indicator) {
        Runnable runnable;
        block16: {
            block15: {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
                }
                indicator.checkCanceled();
                assert (this.myActualContent1 != null || this.myActualContent2 != null);
                if (this.myActualContent1 != null) break block15;
                DocumentContent content = this.myActualContent2;
                final Document document = content.getDocument();
                CompareData data = (CompareData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompareData>(){

                    public CompareData compute() {
                        List<LineFragmentImpl> fragments = Collections.singletonList(new LineFragmentImpl(0, 0, 0, SimpleDiffViewer.getLineCount(document), 0, 0, 0, document.getTextLength()));
                        return new CompareData(fragments, false, 0L, document.getModificationStamp());
                    }
                });
                Runnable runnable2 = this.apply(data);
                if (runnable2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
                }
                return runnable2;
            }
            if (this.myActualContent2 != null) break block16;
            DocumentContent content = this.myActualContent1;
            final Document document = content.getDocument();
            CompareData data = (CompareData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<CompareData>(){

                public CompareData compute() {
                    List<LineFragmentImpl> fragments = Collections.singletonList(new LineFragmentImpl(0, SimpleDiffViewer.getLineCount(document), 0, 0, 0, document.getTextLength(), 0, 0));
                    return new CompareData(fragments, false, document.getModificationStamp(), 0L);
                }
            });
            Runnable runnable3 = this.apply(data);
            if (runnable3 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable3;
        }
        try {
            DocumentContent content1 = this.myActualContent1;
            DocumentContent content2 = this.myActualContent2;
            final Document document1 = content1.getDocument();
            final Document document2 = content2.getDocument();
            DiffUtil.DocumentData data = (DiffUtil.DocumentData)ApplicationManager.getApplication().runReadAction((Computable)new Computable<DiffUtil.DocumentData>(){

                public DiffUtil.DocumentData compute() {
                    return new DiffUtil.DocumentData(document1.getImmutableCharSequence(), document2.getImmutableCharSequence(), document1.getModificationStamp(), document2.getModificationStamp());
                }
            });
            List<LineFragment> lineFragments = null;
            if (this.getHighlightPolicy().isShouldCompare()) {
                lineFragments = DiffUtil.compareWithCache((DiffRequest)this.myRequest, data, this.getDiffConfig(), indicator);
            }
            boolean isEqualContents = (lineFragments == null || lineFragments.isEmpty()) && StringUtil.equals((CharSequence)document1.getCharsSequence(), (CharSequence)document2.getCharsSequence());
            runnable = this.apply(new CompareData(lineFragments, isEqualContents, data.getStamp1(), data.getStamp2()));
        }
        catch (DiffTooBigException ignore) {
            Runnable runnable4 = new Runnable(){

                @Override
                public void run() {
                    SimpleDiffViewer.this.clearDiffPresentation();
                    SimpleDiffViewer.this.myPanel.addTooBigContentNotification();
                }
            };
            if (runnable4 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable4;
        }
        catch (ProcessCanceledException ignore) {
            Runnable runnable5 = new Runnable(){

                @Override
                public void run() {
                    SimpleDiffViewer.this.clearDiffPresentation();
                    SimpleDiffViewer.this.myPanel.addOperationCanceledNotification();
                }
            };
            if (runnable5 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable5;
        }
        catch (Throwable e) {
            LOG.error(e);
            Runnable runnable6 = new Runnable(){

                @Override
                public void run() {
                    SimpleDiffViewer.this.clearDiffPresentation();
                    SimpleDiffViewer.this.myPanel.addDiffErrorNotification();
                }
            };
            if (runnable6 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
            }
            return runnable6;
        }
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "performRediff"));
        }
        return runnable;
    }

    @NotNull
    private Runnable apply(final @NotNull CompareData data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (SimpleDiffViewer.this.myEditor1 != null && SimpleDiffViewer.this.myEditor1.getDocument().getModificationStamp() != data.getStamp1()) {
                    return;
                }
                if (SimpleDiffViewer.this.myEditor2 != null && SimpleDiffViewer.this.myEditor2.getDocument().getModificationStamp() != data.getStamp2()) {
                    return;
                }
                if (SimpleDiffViewer.this.myFoldingModel != null) {
                    SimpleDiffViewer.this.myFoldingModel.updateContext((UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getTextSettings().isExpandByDefault());
                }
                SimpleDiffViewer.this.clearDiffPresentation();
                if (data.isEqualContent()) {
                    SimpleDiffViewer.this.myPanel.addContentsEqualNotification();
                }
                if (data.getFragments() != null) {
                    for (LineFragment fragment : data.getFragments()) {
                        SimpleDiffViewer.this.myDiffChanges.add(new SimpleDiffChange(SimpleDiffViewer.this, fragment, SimpleDiffViewer.this.myEditor1, SimpleDiffViewer.this.myEditor2, SimpleDiffViewer.this.getHighlightPolicy().isFineFragments()));
                    }
                }
                if (SimpleDiffViewer.this.myFoldingModel != null) {
                    SimpleDiffViewer.this.myFoldingModel.install(data.getFragments(), (UserDataHolder)SimpleDiffViewer.this.myRequest, SimpleDiffViewer.this.getTextSettings().isExpandByDefault(), SimpleDiffViewer.this.getTextSettings().getContextRange());
                }
                SimpleDiffViewer.this.scrollOnRediff();
                SimpleDiffViewer.this.myContentPanel.repaintDivider();
                SimpleDiffViewer.this.myStatusPanel.update();
            }
        };
        if (runnable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "apply"));
        }
        return runnable;
    }

    private void clearDiffPresentation() {
        this.myStatusPanel.setBusy(false);
        this.myPanel.resetNotifications();
        this.destroyChangedBlocks();
    }

    @NotNull
    private DiffUtil.DiffConfig getDiffConfig() {
        DiffUtil.DiffConfig diffConfig = new DiffUtil.DiffConfig(this.getTextSettings().getIgnorePolicy(), this.getHighlightPolicy());
        if (diffConfig == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffConfig"));
        }
        return diffConfig;
    }

    @NotNull
    private HighlightPolicy getHighlightPolicy() {
        HighlightPolicy highlightPolicy = this.getTextSettings().getHighlightPolicy();
        if (highlightPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getHighlightPolicy"));
        }
        return highlightPolicy;
    }

    private void destroyChangedBlocks() {
        for (SimpleDiffChange change : this.myDiffChanges) {
            change.destroyHighlighter();
        }
        this.myDiffChanges.clear();
        for (SimpleDiffChange change : this.myInvalidDiffChanges) {
            change.destroyHighlighter();
        }
        this.myInvalidDiffChanges.clear();
        if (this.myFoldingModel != null) {
            this.myFoldingModel.destroy();
        }
        this.myContentPanel.repaintDivider();
        this.myStatusPanel.update();
    }

    @Override
    protected void onBeforeDocumentChange(@NotNull DocumentEvent e) {
        Side side;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onBeforeDocumentChange"));
        }
        super.onBeforeDocumentChange(e);
        if (this.myDiffChanges.isEmpty()) {
            return;
        }
        if (this.myEditor1 == null || this.myEditor2 == null) {
            return;
        }
        if (e.getDocument() == this.myEditor1.getDocument()) {
            side = Side.LEFT;
        } else if (e.getDocument() == this.myEditor2.getDocument()) {
            side = Side.RIGHT;
        } else {
            LOG.warn("Unknown document changed");
            return;
        }
        int offset1 = e.getOffset();
        int offset2 = e.getOffset() + e.getOldLength();
        if (StringUtil.endsWithChar((CharSequence)e.getOldFragment(), (char)'\n') && StringUtil.endsWithChar((CharSequence)e.getNewFragment(), (char)'\n')) {
            --offset2;
        }
        int line1 = e.getDocument().getLineNumber(offset1);
        int line2 = e.getDocument().getLineNumber(offset2) + 1;
        int shift = StringUtil.countNewLines((CharSequence)e.getNewFragment()) - StringUtil.countNewLines((CharSequence)e.getOldFragment());
        ArrayList<SimpleDiffChange> invalid = new ArrayList<SimpleDiffChange>();
        for (SimpleDiffChange change : this.myDiffChanges) {
            if (!change.processChange(line1, line2, shift, side)) continue;
            invalid.add(change);
        }
        if (!invalid.isEmpty()) {
            this.myDiffChanges.removeAll(invalid);
            this.myInvalidDiffChanges.addAll(invalid);
        }
    }

    @Override
    protected void onDocumentChange(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer", "onDocumentChange"));
        }
        super.onDocumentChange(e);
        if (this.myFoldingModel != null) {
            this.myFoldingModel.onDocumentChanged(e);
        }
    }

    @Override
    protected boolean doScrollToChange(@NotNull DiffUserDataKeysEx.ScrollToPolicy scrollToPolicy) {
        SimpleDiffChange targetChange;
        if (scrollToPolicy == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scrollToPolicy", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToChange"));
        }
        if (this.myDiffChanges.isEmpty()) {
            return false;
        }
        switch (scrollToPolicy) {
            case FIRST_CHANGE: {
                targetChange = this.myDiffChanges.get(0);
                break;
            }
            case LAST_CHANGE: {
                targetChange = this.myDiffChanges.get(this.myDiffChanges.size() - 1);
                break;
            }
            default: {
                throw new IllegalArgumentException(scrollToPolicy.name());
            }
        }
        EditorEx editor = this.getCurrentEditor();
        int line = targetChange.getStartLine(this.getCurrentSide());
        DiffUtil.scrollEditor((Editor)editor, line);
        return true;
    }

    @Override
    protected boolean doScrollToContext(@NotNull DiffNavigationContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "doScrollToContext"));
        }
        if (this.myEditor2 == null) {
            return false;
        }
        ChangedLinesIterator changedLinesIterator = new ChangedLinesIterator(Side.RIGHT);
        NavigationContextChecker checker = new NavigationContextChecker(changedLinesIterator, context);
        int line = checker.contextMatchCheck();
        if (line == -1) {
            AllLinesIterator allLinesIterator = new AllLinesIterator(Side.RIGHT);
            NavigationContextChecker checker2 = new NavigationContextChecker(allLinesIterator, context);
            line = checker2.contextMatchCheck();
        }
        if (line == -1) {
            return false;
        }
        this.scrollToLine(Side.RIGHT, line);
        return true;
    }

    @NotNull
    protected List<SimpleDiffChange> getDiffChanges() {
        List<SimpleDiffChange> list = this.myDiffChanges;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getDiffChanges"));
        }
        return list;
    }

    @Override
    @NotNull
    protected SyncScrollSupport.SyncScrollable getSyncScrollable() {
        SyncScrollSupport.SyncScrollable syncScrollable = this.mySyncScrollable;
        if (syncScrollable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSyncScrollable"));
        }
        return syncScrollable;
    }

    @Override
    @NotNull
    protected JComponent getStatusPanel() {
        StatusPanel statusPanel = this.myStatusPanel;
        if (statusPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getStatusPanel"));
        }
        return statusPanel;
    }

    @NotNull
    public ModifierProvider getModifierProvider() {
        ModifierProvider modifierProvider = this.myModifierProvider;
        if (modifierProvider == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getModifierProvider"));
        }
        return modifierProvider;
    }

    public static boolean canShowRequest(@NotNull DiffContext context, @NotNull DiffRequest request) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/diff/tools/simple/SimpleDiffViewer", "canShowRequest"));
        }
        return TwosideTextDiffViewer.canShowRequest(context, request);
    }

    @NotNull
    private List<SimpleDiffChange> getSelectedChanges(@NotNull Side side) {
        if (side == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        EditorEx editor = (EditorEx)side.select((Object)this.myEditor1, (Object)this.myEditor2);
        if (editor == null) {
            List<SimpleDiffChange> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
            }
            return list;
        }
        BitSet lines = DiffUtil.getSelectedLines(editor);
        ArrayList<SimpleDiffChange> affectedChanges = new ArrayList<SimpleDiffChange>();
        for (int i = this.myDiffChanges.size() - 1; i >= 0; --i) {
            int line2;
            SimpleDiffChange change = this.myDiffChanges.get(i);
            int line1 = change.getStartLine(side);
            if (!DiffUtil.isSelectedByLine(lines, line1, line2 = change.getEndLine(side))) continue;
            affectedChanges.add(change);
        }
        ArrayList<SimpleDiffChange> arrayList = affectedChanges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer", "getSelectedChanges"));
        }
        return arrayList;
    }

    @Override
    @Nullable
    public Object getData(@NonNls String dataId) {
        if (DiffDataKeys.PREV_NEXT_DIFFERENCE_ITERABLE.is(dataId)) {
            return this.myPrevNextDifferenceIterable;
        }
        return super.getData(dataId);
    }

    private static class MyFoldingModel
    extends FoldingModelSupport {
        private final FoldingModelSupport.MyPaintable myPaintable;

        public MyFoldingModel(@NotNull EditorEx editor1, @NotNull EditorEx editor2, @NotNull Disposable disposable) {
            if (editor1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor1", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            if (editor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor2", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            if (disposable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "<init>"));
            }
            super(new EditorEx[]{editor1, editor2}, disposable);
            this.myPaintable = new FoldingModelSupport.MyPaintable(this, 0, 1);
        }

        public void install(@Nullable List<LineFragment> fragments, @NotNull UserDataHolder context, boolean defaultExpanded, int range) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "install"));
            }
            Iterator<int[]> it = MyFoldingModel.map(fragments, new Function<LineFragment, int[]>(){

                public int[] fun(LineFragment fragment) {
                    return new int[]{fragment.getStartLine1(), fragment.getEndLine1(), fragment.getStartLine2(), fragment.getEndLine2()};
                }
            });
            this.install(it, context, defaultExpanded, range);
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyFoldingModel", "paintOnDivider"));
            }
            this.myPaintable.paintOnDivider(gg, divider);
        }
    }

    public class ModifierProvider {
        private boolean myShiftPressed;
        private boolean myCtrlPressed;
        private boolean myAltPressed;

        public ModifierProvider() {
            IdeEventQueue.getInstance().addPostprocessor(new IdeEventQueue.EventDispatcher(){

                @Override
                public boolean dispatch(AWTEvent e) {
                    if (e instanceof KeyEvent) {
                        int keyCode = ((KeyEvent)e).getKeyCode();
                        if (keyCode == 16) {
                            ModifierProvider.this.myShiftPressed = e.getID() == 401;
                            ModifierProvider.this.updateActions();
                        }
                        if (keyCode == 17) {
                            ModifierProvider.this.myCtrlPressed = e.getID() == 401;
                            ModifierProvider.this.updateActions();
                        }
                        if (keyCode == 18) {
                            ModifierProvider.this.myAltPressed = e.getID() == 401;
                            ModifierProvider.this.updateActions();
                        }
                    }
                    return false;
                }
            }, (Disposable)SimpleDiffViewer.this);
        }

        public boolean isShiftPressed() {
            return this.myShiftPressed;
        }

        public boolean isCtrlPressed() {
            return this.myCtrlPressed;
        }

        public boolean isAltPressed() {
            return this.myAltPressed;
        }

        public void updateActions() {
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                change.update();
            }
        }
    }

    private static class CompareData {
        @Nullable
        private final List<LineFragment> myFragments;
        private final boolean myEqualContent;
        private final long myStamp1;
        private final long myStamp2;

        public CompareData(@Nullable List<LineFragment> fragments, boolean equalContent, long stamp1, long stamp2) {
            this.myFragments = fragments;
            this.myEqualContent = equalContent;
            this.myStamp1 = stamp1;
            this.myStamp2 = stamp2;
        }

        @Nullable
        public List<LineFragment> getFragments() {
            return this.myFragments;
        }

        public boolean isEqualContent() {
            return this.myEqualContent;
        }

        public long getStamp1() {
            return this.myStamp1;
        }

        public long getStamp2() {
            return this.myStamp2;
        }
    }

    private class MyStatusPanel
    extends StatusPanel {
        private MyStatusPanel() {
        }

        @Override
        protected int getChangesCount() {
            return SimpleDiffViewer.this.myDiffChanges.size() + SimpleDiffViewer.this.myInvalidDiffChanges.size();
        }
    }

    private class MyDividerPainter
    implements DiffSplitter.Painter,
    DiffDividerDrawUtil.DividerPaintable {
        private MyDividerPainter() {
        }

        @Override
        public void paint(@NotNull Graphics g, @NotNull Component divider) {
            if (g == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "paint"));
            }
            if (SimpleDiffViewer.this.myEditor1 == null || SimpleDiffViewer.this.myEditor2 == null) {
                return;
            }
            Graphics2D gg = SimpleDiffViewer.this.getDividerGraphics(g, divider);
            DiffDividerDrawUtil.paintPolygons(gg, divider.getWidth(), SimpleDiffViewer.this.myEditor1, SimpleDiffViewer.this.myEditor2, this);
            if (SimpleDiffViewer.this.myFoldingModel != null) {
                SimpleDiffViewer.this.myFoldingModel.paintOnDivider(gg, divider);
            }
            gg.dispose();
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyDividerPainter", "process"));
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (handler.process(diffChange.getStartLine(Side.LEFT), diffChange.getEndLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT), diffChange.getEndLine(Side.RIGHT), diffChange.getDiffType().getColor(SimpleDiffViewer.this.myEditor1))) continue;
                return;
            }
        }
    }

    private class MySyncScrollable
    extends BaseSyncScrollable {
        private MySyncScrollable() {
        }

        @Override
        public boolean isSyncScrollEnabled() {
            return SimpleDiffViewer.this.getTextSettings().isEnableSyncScroll();
        }

        @Override
        public int transfer(@NotNull Side side, int line) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "transfer"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return line;
            }
            return super.transfer(side, line);
        }

        @Override
        protected void processHelper(@NotNull BaseSyncScrollable.ScrollHelper helper) {
            if (helper == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "helper", "com/intellij/diff/tools/simple/SimpleDiffViewer$MySyncScrollable", "processHelper"));
            }
            assert (SimpleDiffViewer.this.myEditor1 != null && SimpleDiffViewer.this.myEditor2 != null);
            if (!helper.process(0, 0)) {
                return;
            }
            for (SimpleDiffChange diffChange : SimpleDiffViewer.this.myDiffChanges) {
                if (!helper.process(diffChange.getStartLine(Side.LEFT), diffChange.getStartLine(Side.RIGHT))) {
                    return;
                }
                if (helper.process(diffChange.getEndLine(Side.LEFT), diffChange.getEndLine(Side.RIGHT))) continue;
                return;
            }
            helper.process(SimpleDiffViewer.this.myEditor1.getDocument().getLineCount(), SimpleDiffViewer.this.myEditor2.getDocument().getLineCount());
        }
    }

    private class ChangedLinesIterator
    extends BufferedLineIterator {
        @NotNull
        private final Side mySide;
        private int myIndex;

        private ChangedLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ChangedLinesIterator", "<init>"));
            }
            this.myIndex = 0;
            this.mySide = side;
            this.init();
        }

        @Override
        public boolean hasNextBlock() {
            return this.myIndex < SimpleDiffViewer.this.myDiffChanges.size();
        }

        @Override
        public void loadNextBlock() {
            SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(this.myIndex);
            ++this.myIndex;
            int line1 = change.getStartLine(this.mySide);
            int line2 = change.getEndLine(this.mySide);
            Editor editor = (Editor)this.mySide.select((Object)SimpleDiffViewer.this.myEditor1, (Object)SimpleDiffViewer.this.myEditor2);
            assert (editor != null);
            Document document = editor.getDocument();
            for (int i = line1; i < line2; ++i) {
                int offset1 = document.getLineStartOffset(i);
                int offset2 = document.getLineEndOffset(i);
                CharSequence text = document.getImmutableCharSequence().subSequence(offset1, offset2);
                this.addLine(i, text);
            }
        }
    }

    private class AllLinesIterator
    implements Iterator<Pair<Integer, CharSequence>> {
        @NotNull
        private final Side mySide;
        @NotNull
        private final Document myDocument;
        private int myLine;

        private AllLinesIterator(Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AllLinesIterator", "<init>"));
            }
            this.myLine = 0;
            this.mySide = side;
            Editor editor = (Editor)this.mySide.select((Object)SimpleDiffViewer.this.myEditor1, (Object)SimpleDiffViewer.this.myEditor2);
            assert (editor != null);
            this.myDocument = editor.getDocument();
        }

        @Override
        public boolean hasNext() {
            return this.myLine < SimpleDiffViewer.getLineCount(this.myDocument);
        }

        @Override
        public Pair<Integer, CharSequence> next() {
            int offset1 = this.myDocument.getLineStartOffset(this.myLine);
            int offset2 = this.myDocument.getLineEndOffset(this.myLine);
            CharSequence text = this.myDocument.getImmutableCharSequence().subSequence(offset1, offset2);
            Pair pair = new Pair((Object)this.myLine, (Object)text);
            ++this.myLine;
            return pair;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MyToggleExpandByDefaultAction
    extends TextDiffViewerBase.ToggleExpandByDefaultAction {
        private MyToggleExpandByDefaultAction() {
            super(SimpleDiffViewer.this);
        }

        public boolean isEnabled() {
            return SimpleDiffViewer.this.myFoldingModel != null;
        }

        @Override
        protected void expandAll(boolean expand) {
            assert (SimpleDiffViewer.this.myFoldingModel != null);
            SimpleDiffViewer.this.myFoldingModel.expandAll(expand);
        }
    }

    private class RevertSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public RevertSelectedChangesAction() {
            super("Revert", null, AllIcons.Diff.Remove, false);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "getIcon"));
            }
            Icon icon = AllIcons.Diff.Remove;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$RevertSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                change.replaceChange(side.other());
            }
        }
    }

    private class AppendSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public AppendSelectedChangesAction() {
            super("Insert", null, AllIcons.Diff.ArrowLeftDown, true);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "getIcon"));
            }
            Icon icon = side.isLeft() ? AllIcons.Diff.ArrowRightDown : AllIcons.Diff.ArrowLeftDown;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$AppendSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                change.appendChange(side);
            }
        }
    }

    private class ReplaceSelectedChangesAction
    extends ApplySelectedChangesActionBase {
        public ReplaceSelectedChangesAction() {
            super("Replace", null, AllIcons.Diff.Arrow, true);
        }

        @Override
        @NotNull
        protected Icon getIcon(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "getIcon"));
            }
            Icon icon = side.isLeft() ? AllIcons.Diff.ArrowRight : AllIcons.Diff.Arrow;
            if (icon == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "getIcon"));
            }
            return icon;
        }

        @Override
        protected void apply(@NotNull Side side, @NotNull List<SimpleDiffChange> changes) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            if (changes == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "com/intellij/diff/tools/simple/SimpleDiffViewer$ReplaceSelectedChangesAction", "apply"));
            }
            for (SimpleDiffChange change : changes) {
                change.replaceChange(side);
            }
        }
    }

    private abstract class ApplySelectedChangesActionBase
    extends AnAction
    implements DumbAware {
        private final boolean myModifyOpposite;

        public ApplySelectedChangesActionBase(@Nullable String text, @Nullable String description, Icon icon, boolean modifyOpposite) {
            super(text, description, icon);
            this.myModifyOpposite = modifyOpposite;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "update"));
            }
            Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
            Side side = Side.fromLeft((editor == SimpleDiffViewer.this.myEditor1 ? 1 : 0) != 0);
            if (SimpleDiffViewer.this.myEditor1 == null || SimpleDiffViewer.this.myEditor2 == null) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            if (editor != SimpleDiffViewer.this.myEditor1 && editor != SimpleDiffViewer.this.myEditor2) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            Editor modifiedEditor = (Editor)side.other(this.myModifyOpposite).selectNotNull((Object)SimpleDiffViewer.this.myEditor1, (Object)SimpleDiffViewer.this.myEditor2);
            if (!DiffUtil.isEditable(modifiedEditor)) {
                e.getPresentation().setEnabledAndVisible(false);
                return;
            }
            e.getPresentation().setIcon(this.getIcon(side));
            e.getPresentation().setEnabled(this.isSomeChangeSelected(side));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "actionPerformed"));
            }
            assert (SimpleDiffViewer.this.myEditor1 != null && SimpleDiffViewer.this.myEditor2 != null);
            Editor editor = (Editor)e.getRequiredData(CommonDataKeys.EDITOR);
            final Side side = Side.fromLeft((editor == SimpleDiffViewer.this.myEditor1 ? 1 : 0) != 0);
            final List selectedChanges = SimpleDiffViewer.this.getSelectedChanges(side);
            Editor modifiedEditor = (Editor)side.other(this.myModifyOpposite).selectNotNull((Object)SimpleDiffViewer.this.myEditor1, (Object)SimpleDiffViewer.this.myEditor2);
            String title = e.getPresentation().getText() + " selected changes";
            DiffUtil.executeWriteCommand(modifiedEditor.getDocument(), e.getProject(), title, new Runnable(){

                @Override
                public void run() {
                    ApplySelectedChangesActionBase.this.apply(side, selectedChanges);
                }
            });
        }

        protected boolean isSomeChangeSelected(@NotNull Side side) {
            if (side == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "side", "com/intellij/diff/tools/simple/SimpleDiffViewer$ApplySelectedChangesActionBase", "isSomeChangeSelected"));
            }
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            Editor editor = (Editor)side.select((Object)SimpleDiffViewer.this.myEditor1, (Object)SimpleDiffViewer.this.myEditor2);
            if (editor == null) {
                return false;
            }
            List carets = editor.getCaretModel().getAllCarets();
            if (carets.size() != 1) {
                return true;
            }
            Caret caret = (Caret)carets.get(0);
            if (caret.hasSelection()) {
                return true;
            }
            int line = caret.getLogicalPosition().line;
            for (SimpleDiffChange change : SimpleDiffViewer.this.myDiffChanges) {
                if (!change.isSelectedByLine(line, side)) continue;
                return true;
            }
            return false;
        }

        @NotNull
        protected abstract Icon getIcon(@NotNull Side var1);

        protected abstract void apply(@NotNull Side var1, @NotNull List<SimpleDiffChange> var2);
    }

    private class MyPrevNextDifferenceIterable
    implements PrevNextDifferenceIterable {
        private MyPrevNextDifferenceIterable() {
        }

        @Override
        public void notify(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/diff/tools/simple/SimpleDiffViewer$MyPrevNextDifferenceIterable", "notify"));
            }
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(message));
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, (Editor)SimpleDiffViewer.this.getCurrentEditor(), (short)2, 42, 0, false);
        }

        @Override
        public boolean canGoNext() {
            EditorEx editor;
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            int line = editor.getCaretModel().getLogicalPosition().line;
            editor = SimpleDiffViewer.this.getCurrentEditor();
            if (line == editor.getDocument().getLineCount() - 1) {
                return false;
            }
            SimpleDiffChange lastChange = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(SimpleDiffViewer.this.myDiffChanges.size() - 1);
            return lastChange.getStartLine(SimpleDiffViewer.this.getCurrentSide()) > line;
        }

        @Override
        public void goNext() {
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleDiffChange next = null;
            for (int i = 0; i < SimpleDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i);
                if (change.getStartLine(SimpleDiffViewer.this.getCurrentSide()) <= line) continue;
                next = change;
                break;
            }
            assert (next != null);
            DiffUtil.scrollToLineAnimated(editor, next.getStartLine(SimpleDiffViewer.this.getCurrentSide()));
        }

        @Override
        public boolean canGoPrev() {
            if (SimpleDiffViewer.this.myDiffChanges.isEmpty()) {
                return false;
            }
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            if (line == 0) {
                return false;
            }
            SimpleDiffChange firstChange = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(0);
            if (firstChange.getEndLine(SimpleDiffViewer.this.getCurrentSide()) > line) {
                return false;
            }
            return firstChange.getStartLine(SimpleDiffViewer.this.getCurrentSide()) < line;
        }

        @Override
        public void goPrev() {
            EditorEx editor = SimpleDiffViewer.this.getCurrentEditor();
            int line = editor.getCaretModel().getLogicalPosition().line;
            SimpleDiffChange prev = null;
            for (int i = 0; i < SimpleDiffViewer.this.myDiffChanges.size(); ++i) {
                SimpleDiffChange next;
                SimpleDiffChange change = (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i);
                SimpleDiffChange simpleDiffChange = next = i < SimpleDiffViewer.this.myDiffChanges.size() - 1 ? (SimpleDiffChange)SimpleDiffViewer.this.myDiffChanges.get(i + 1) : null;
                if (next != null && next.getEndLine(SimpleDiffViewer.this.getCurrentSide()) <= line && next.getStartLine(SimpleDiffViewer.this.getCurrentSide()) < line) continue;
                prev = change;
                break;
            }
            assert (prev != null);
            DiffUtil.scrollToLineAnimated(editor, prev.getStartLine(SimpleDiffViewer.this.getCurrentSide()));
        }
    }
}

