/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.tools.util;

import com.intellij.diff.util.DiffDividerDrawUtil;
import com.intellij.diff.util.DiffDrawUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.FoldingListener;
import com.intellij.openapi.editor.ex.FoldingModelEx;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.HashSet;
import gnu.trove.TIntFunction;
import java.awt.Component;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FoldingModelSupport {
    public static final String PLACEHOLDER = "     ";
    private static final Key<FoldingCache> CACHE_KEY = Key.create((String)"Diff.FoldingUtil.Cache");
    protected final int myCount;
    @NotNull
    protected final EditorEx[] myEditors;
    @NotNull
    protected final List<FoldedBlock> myFoldings;
    private boolean myDuringSynchronize;
    private boolean myShouldUpdateLineNumbers;

    public FoldingModelSupport(@NotNull EditorEx[] editors, @NotNull Disposable disposable) {
        if (editors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editors", "com/intellij/diff/tools/util/FoldingModelSupport", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/diff/tools/util/FoldingModelSupport", "<init>"));
        }
        this.myFoldings = new ArrayList<FoldedBlock>();
        this.myEditors = editors;
        this.myCount = this.myEditors.length;
        if (this.myCount > 1) {
            for (int i = 0; i < this.myCount; ++i) {
                this.myEditors[i].getFoldingModel().addListener(new MyFoldingListener(i), disposable);
                this.myEditors[i].getGutterComponentEx().setLineNumberConvertor(this.getLineConvertor(i));
            }
        }
    }

    protected void install(final @Nullable Iterator<int[]> changedLines, final @NotNull UserDataHolder context, final boolean defaultExpanded, final int range) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport", "install"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        if (changedLines == null) {
            return;
        }
        if (range == -1) {
            return;
        }
        this.runBatchOperation(new Runnable(){

            @Override
            public void run() {
                int i;
                ExpandSuggester expandSuggester = new ExpandSuggester((FoldingCache)context.getUserData(CACHE_KEY), defaultExpanded);
                int[] lineCount = new int[FoldingModelSupport.this.myCount];
                for (int i2 = 0; i2 < FoldingModelSupport.this.myCount; ++i2) {
                    lineCount[i2] = FoldingModelSupport.this.myEditors[i2].getDocument().getLineCount();
                }
                int[] starts = new int[FoldingModelSupport.this.myCount];
                int[] ends = new int[FoldingModelSupport.this.myCount];
                int[] last = new int[FoldingModelSupport.this.myCount];
                for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    last[i] = Integer.MIN_VALUE;
                }
                while (changedLines.hasNext()) {
                    int i3;
                    int[] offsets = (int[])changedLines.next();
                    for (i3 = 0; i3 < FoldingModelSupport.this.myCount; ++i3) {
                        starts[i3] = FoldingModelSupport.bound(last[i3] + range, 0, lineCount[i3]);
                        ends[i3] = FoldingModelSupport.bound(offsets[i3 * 2] - range, 0, lineCount[i3]);
                    }
                    FoldingModelSupport.this.addRange(starts, ends, expandSuggester.isExpanded(starts, ends));
                    for (i3 = 0; i3 < FoldingModelSupport.this.myCount; ++i3) {
                        last[i3] = offsets[i3 * 2 + 1];
                    }
                }
                for (i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    starts[i] = FoldingModelSupport.bound(last[i] + range, 0, lineCount[i]);
                    ends[i] = FoldingModelSupport.bound(Integer.MAX_VALUE - range, 0, lineCount[i]);
                }
                FoldingModelSupport.this.addRange(starts, ends, expandSuggester.isExpanded(starts, ends));
            }
        });
        this.updateLineNumbers(true);
    }

    private void addRange(int[] starts, int[] ends, boolean expanded) {
        boolean hasFolding = false;
        FoldRegion[] regions = new FoldRegion[this.myCount];
        for (int i = 0; i < this.myCount; ++i) {
            if (ends[i] - starts[i] < 2) continue;
            regions[i] = FoldingModelSupport.addFolding(this.myEditors[i], starts[i], ends[i], expanded);
            hasFolding |= regions[i] != null;
        }
        if (hasFolding) {
            this.myFoldings.add(new FoldedBlock(regions));
        }
    }

    @Nullable
    private static FoldRegion addFolding(@NotNull EditorEx editor, int start, int end, boolean expanded) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport", "addFolding"));
        }
        DocumentEx document = editor.getDocument();
        int startOffset = document.getLineStartOffset(start);
        int endOffset = document.getLineEndOffset(end - 1);
        FoldRegion value = editor.getFoldingModel().addFoldRegion(startOffset, endOffset, PLACEHOLDER);
        if (value != null) {
            value.setExpanded(expanded);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runBatchOperation(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/diff/tools/util/FoldingModelSupport", "runBatchOperation"));
        }
        Runnable lastRunnable = runnable;
        for (int i = 0; i < this.myCount; ++i) {
            final EditorEx editor = this.myEditors[i];
            final Runnable finalRunnable = lastRunnable;
            lastRunnable = new Runnable(){

                @Override
                public void run() {
                    editor.getFoldingModel().runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            finalRunnable.run();
                        }
                    });
                }
            };
        }
        this.myDuringSynchronize = true;
        try {
            lastRunnable.run();
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void destroy() {
        for (int i = 0; i < this.myCount; ++i) {
            this.destroyFoldings(i);
        }
        for (FoldedBlock folding : this.myFoldings) {
            folding.destroyHighlighter();
        }
        this.myFoldings.clear();
    }

    private void destroyFoldings(final int index) {
        final FoldingModelEx model = this.myEditors[index].getFoldingModel();
        model.runBatchFoldingOperation(new Runnable(){

            @Override
            public void run() {
                for (FoldedBlock folding : FoldingModelSupport.this.myFoldings) {
                    FoldRegion region = folding.getRegion(index);
                    if (region == null) continue;
                    model.removeFoldRegion(region);
                }
            }
        });
    }

    public void onDocumentChanged(@NotNull DocumentEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/diff/tools/util/FoldingModelSupport", "onDocumentChanged"));
        }
        if (StringUtil.indexOf((CharSequence)e.getOldFragment(), (char)'\n') != -1 || StringUtil.indexOf((CharSequence)e.getNewFragment(), (char)'\n') != -1) {
            this.myShouldUpdateLineNumbers = true;
        }
    }

    @NotNull
    protected TIntFunction getLineConvertor(final int index) {
        TIntFunction tIntFunction = new TIntFunction(){

            public int execute(int value) {
                FoldingModelSupport.this.updateLineNumbers(false);
                for (FoldedBlock folding : FoldingModelSupport.this.myFoldings) {
                    int line = folding.getLine(index);
                    if (line == -1) continue;
                    if (line > value) break;
                    FoldRegion region = folding.getRegion(index);
                    if (line != value || region == null || region.isExpanded()) continue;
                    return -1;
                }
                return value;
            }
        };
        if (tIntFunction == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getLineConvertor"));
        }
        return tIntFunction;
    }

    private void updateLineNumbers(boolean force) {
        if (!this.myShouldUpdateLineNumbers && !force) {
            return;
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        for (FoldedBlock folding : this.myFoldings) {
            folding.updateLineNumbers();
        }
        this.myShouldUpdateLineNumbers = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandAll(final boolean expanded) {
        if (this.myDuringSynchronize) {
            return;
        }
        this.myDuringSynchronize = true;
        try {
            int i = 0;
            while (i < this.myCount) {
                final int index = i++;
                FoldingModelEx model = this.myEditors[index].getFoldingModel();
                model.runBatchFoldingOperation(new Runnable(){

                    @Override
                    public void run() {
                        for (FoldedBlock folding : FoldingModelSupport.this.myFoldings) {
                            FoldRegion region = folding.getRegion(index);
                            if (region == null) continue;
                            region.setExpanded(expanded);
                        }
                    }
                });
            }
        }
        finally {
            this.myDuringSynchronize = false;
        }
    }

    public void updateContext(@NotNull UserDataHolder context, boolean defaultState) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/diff/tools/util/FoldingModelSupport", "updateContext"));
        }
        if (this.myFoldings.isEmpty()) {
            return;
        }
        context.putUserData(CACHE_KEY, (Object)this.getFoldingCache(defaultState));
    }

    @NotNull
    private FoldingCache getFoldingCache(final boolean defaultState) {
        FoldingCache foldingCache = (FoldingCache)ApplicationManager.getApplication().runReadAction((Computable)new Computable<FoldingCache>(){

            public FoldingCache compute() {
                List[] result = new List[FoldingModelSupport.this.myCount];
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    result[i] = FoldingModelSupport.this.getFoldedRanges(i);
                }
                return new FoldingCache(result, defaultState);
            }
        });
        if (foldingCache == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldingCache"));
        }
        return foldingCache;
    }

    @NotNull
    private List<FoldedRangeState> getFoldedRanges(int index) {
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ArrayList<FoldedRangeState> ranges = new ArrayList<FoldedRangeState>();
        for (FoldedBlock folding : this.myFoldings) {
            FoldRegion region = folding.getRegion(index);
            if (region == null || !region.isValid()) continue;
            DocumentEx document = this.myEditors[index].getDocument();
            int line1 = document.getLineNumber(region.getStartOffset());
            int line2 = document.getLineNumber(region.getEndOffset()) + 1;
            ranges.add(new FoldedRangeState(line1, line2, region.isExpanded()));
        }
        ArrayList<FoldedRangeState> arrayList = ranges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "getFoldedRanges"));
        }
        return arrayList;
    }

    private static int bound(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    protected static <T, V> Iterator<V> map(@Nullable List<T> list, final @NotNull Function<T, V> mapping) {
        if (mapping == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "com/intellij/diff/tools/util/FoldingModelSupport", "map"));
        }
        if (list == null) {
            return null;
        }
        final Iterator<T> it = list.iterator();
        return new Iterator<V>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public V next() {
                return mapping.fun(it.next());
            }

            @Override
            public void remove() {
            }
        };
    }

    @NotNull
    private static RangeHighlighter createFoldingHighlighter(@NotNull Editor editor, final @NotNull FoldRegion region) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        if (region == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        RangeHighlighter rangeHighlighter = DiffDrawUtil.createLineSeparatorHighlighter(editor, region.getStartOffset(), region.getEndOffset(), new BooleanGetter(){

            public boolean get() {
                return region.isValid() && !region.isExpanded();
            }
        });
        if (rangeHighlighter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/tools/util/FoldingModelSupport", "createFoldingHighlighter"));
        }
        return rangeHighlighter;
    }

    protected class FoldedBlock {
        @NotNull
        private final FoldRegion[] myRegions;
        @NotNull
        private final int[] myLines;
        @NotNull
        private final List<RangeHighlighter> myHighlighters;

        public FoldedBlock(FoldRegion[] regions) {
            if (regions == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "regions", "com/intellij/diff/tools/util/FoldingModelSupport$FoldedBlock", "<init>"));
            }
            this.myHighlighters = new ArrayList<RangeHighlighter>(FoldingModelSupport.this.myCount);
            assert (regions.length == FoldingModelSupport.this.myCount);
            this.myRegions = regions;
            this.myLines = new int[FoldingModelSupport.this.myCount];
            this.installHighlighter();
        }

        public void installHighlighter() {
            assert (this.myHighlighters.isEmpty());
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                if (region == null || !region.isValid()) continue;
                this.myHighlighters.add(FoldingModelSupport.createFoldingHighlighter(FoldingModelSupport.this.myEditors[i], region));
            }
        }

        public void destroyHighlighter() {
            for (RangeHighlighter highlighter : this.myHighlighters) {
                highlighter.dispose();
            }
            this.myHighlighters.clear();
        }

        public void updateLineNumbers() {
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                FoldRegion region = this.myRegions[i];
                this.myLines[i] = region == null || !region.isValid() ? -1 : FoldingModelSupport.this.myEditors[i].getDocument().getLineNumber(region.getStartOffset());
            }
        }

        @Nullable
        public FoldRegion getRegion(int index) {
            return this.myRegions[index];
        }

        public int getLine(int index) {
            return this.myLines[index];
        }
    }

    private static class FoldedRangeState {
        public final int myStartLine;
        public final int myEndLine;
        public final boolean myExpanded;

        public FoldedRangeState(int startLine, int endLine, boolean expanded) {
            this.myStartLine = startLine;
            this.myEndLine = endLine;
            this.myExpanded = expanded;
        }
    }

    private static class FoldingCache {
        public final boolean myExpandByDefault;
        @NotNull
        public final List<FoldedRangeState>[] myRanges;

        public FoldingCache(@NotNull List<FoldedRangeState>[] ranges, boolean expandByDefault) {
            if (ranges == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ranges", "com/intellij/diff/tools/util/FoldingModelSupport$FoldingCache", "<init>"));
            }
            this.myRanges = ranges;
            this.myExpandByDefault = expandByDefault;
        }
    }

    private class ExpandSuggester {
        @Nullable
        private final FoldingCache myCache;
        private final int[] myIndex;
        protected final boolean myDefault;

        public ExpandSuggester(FoldingCache cache, boolean defaultValue) {
            this.myIndex = new int[FoldingModelSupport.this.myCount];
            this.myCache = cache;
            this.myDefault = defaultValue;
        }

        public boolean isExpanded(int[] starts, int[] ends) {
            if (this.myCache == null || this.myCache.myRanges.length != FoldingModelSupport.this.myCount) {
                return this.myDefault;
            }
            if (this.myDefault != this.myCache.myExpandByDefault) {
                return this.myDefault;
            }
            Boolean state = null;
            for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                Boolean sideState = this.getCachedExpanded(starts[i], ends[i], i);
                if (sideState == null) continue;
                if (state == null) {
                    state = sideState;
                    continue;
                }
                if (state == sideState) continue;
                return this.myDefault;
            }
            return state == null ? this.myDefault : state;
        }

        @Nullable
        private Boolean getCachedExpanded(int start, int end, int index) {
            if (start == end) {
                return null;
            }
            List<FoldedRangeState> ranges = this.myCache.myRanges[index];
            while (this.myIndex[index] < ranges.size()) {
                FoldedRangeState range = ranges.get(this.myIndex[index]);
                if (range.myEndLine > start) {
                    if (range.myStartLine >= end) {
                        return null;
                    }
                    if (range.myStartLine <= start && range.myEndLine >= end) {
                        return range.myExpanded;
                    }
                }
                int n = index;
                this.myIndex[n] = this.myIndex[n] + 1;
            }
            return null;
        }
    }

    protected class MyPaintable
    implements DiffDividerDrawUtil.DividerSeparatorPaintable {
        private final int myLeft;
        private final int myRight;

        public MyPaintable(int left, int right) {
            this.myLeft = left;
            this.myRight = right;
        }

        @Override
        public void process(@NotNull DiffDividerDrawUtil.DividerSeparatorPaintable.Handler handler) {
            if (handler == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "process"));
            }
            for (FoldedBlock folding : FoldingModelSupport.this.myFoldings) {
                int line2;
                int line1;
                if (folding.myRegions[this.myLeft] == null || folding.myRegions[this.myRight] == null || folding.myRegions[this.myLeft].isExpanded() || folding.myRegions[this.myRight].isExpanded() || handler.process(line1 = FoldingModelSupport.this.myEditors[this.myLeft].getDocument().getLineNumber(folding.myRegions[this.myLeft].getStartOffset()), line2 = FoldingModelSupport.this.myEditors[this.myRight].getDocument().getLineNumber(folding.myRegions[this.myRight].getStartOffset()))) continue;
                return;
            }
        }

        public void paintOnDivider(@NotNull Graphics2D gg, @NotNull Component divider) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnDivider"));
            }
            if (divider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "divider", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnDivider"));
            }
            DiffDividerDrawUtil.paintSeparators(gg, divider.getWidth(), FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }

        public void paintOnScrollbar(@NotNull Graphics2D gg, int width) {
            if (gg == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gg", "com/intellij/diff/tools/util/FoldingModelSupport$MyPaintable", "paintOnScrollbar"));
            }
            DiffDividerDrawUtil.paintSeparatorsOnScrollbar(gg, width, FoldingModelSupport.this.myEditors[this.myLeft], FoldingModelSupport.this.myEditors[this.myRight], this);
        }
    }

    private class MyFoldingListener
    implements FoldingListener {
        private final int myIndex;
        @NotNull
        Set<FoldRegion> myModifiedRegions = new HashSet();

        public MyFoldingListener(int index) {
            this.myIndex = index;
        }

        @Override
        public void onFoldRegionStateChange(@NotNull FoldRegion region) {
            if (region == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "region", "com/intellij/diff/tools/util/FoldingModelSupport$MyFoldingListener", "onFoldRegionStateChange"));
            }
            if (FoldingModelSupport.this.myDuringSynchronize) {
                return;
            }
            this.myModifiedRegions.add(region);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFoldProcessingEnd() {
            if (this.myModifiedRegions.isEmpty()) {
                return;
            }
            FoldingModelSupport.this.myDuringSynchronize = true;
            try {
                for (int i = 0; i < FoldingModelSupport.this.myCount; ++i) {
                    if (i == this.myIndex) continue;
                    final int pairedIndex = i;
                    FoldingModelSupport.this.myEditors[pairedIndex].getFoldingModel().runBatchFoldingOperation(new Runnable(){

                        @Override
                        public void run() {
                            for (FoldedBlock folding : FoldingModelSupport.this.myFoldings) {
                                FoldRegion pairedRegion;
                                FoldRegion region = folding.getRegion(MyFoldingListener.this.myIndex);
                                if (region == null || !region.isValid() || !MyFoldingListener.this.myModifiedRegions.contains(region) || (pairedRegion = folding.getRegion(pairedIndex)) == null || !pairedRegion.isValid()) continue;
                                pairedRegion.setExpanded(region.isExpanded());
                            }
                        }
                    });
                }
                this.myModifiedRegions.clear();
            }
            finally {
                FoldingModelSupport.this.myDuringSynchronize = false;
            }
        }
    }
}

