/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.util;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.LineMarkerRenderer;
import com.intellij.openapi.editor.markup.LineSeparatorRenderer;
import com.intellij.openapi.ui.GraphicsConfig;
import com.intellij.openapi.util.BooleanGetter;
import com.intellij.util.ui.GraphicsUtil;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffLineSeparatorRenderer
implements LineMarkerRenderer,
LineSeparatorRenderer {
    @NotNull
    private final Editor myEditor;
    @NotNull
    private final BooleanGetter myCondition;
    private static final int X_STEP = 4;
    private static final int Y_STEP = 4;
    private static final int Y_STEP_2 = 2;

    public DiffLineSeparatorRenderer(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        this(editor, BooleanGetter.TRUE);
    }

    public DiffLineSeparatorRenderer(@NotNull Editor editor, @NotNull BooleanGetter condition) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        if (condition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "condition", "com/intellij/diff/util/DiffLineSeparatorRenderer", "<init>"));
        }
        this.myEditor = editor;
        this.myCondition = condition;
    }

    public static void drawConnectorLine(@NotNull Graphics2D g, int x1, int x2, int start1, int end1, int start2, int end2) {
        int[] yPoints2;
        int[] xPoints2;
        int[] yPoints1;
        int[] xPoints1;
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "drawConnectorLine"));
        }
        int y1 = (start1 + end1) / 2;
        int y2 = (start2 + end2) / 2;
        if (Math.abs(x2 - x1) < Math.abs(y2 - y1)) {
            int dx = 4;
            int dy = 2;
            if (y2 < y1) {
                xPoints1 = new int[]{x1, x2 - dx, x2};
                yPoints1 = new int[]{y1 - 4, y2 - 4 + dy, y2 - 4};
                xPoints2 = new int[]{x1, x1 + dx, x2};
                yPoints2 = new int[]{y1 + 4, y1 + 4 - dy, y2 + 4};
            } else {
                xPoints1 = new int[]{x1, x1 + dx, x2};
                yPoints1 = new int[]{y1 - 4, y1 - 4 + dy, y2 - 4};
                xPoints2 = new int[]{x1, x2 - dx, x2};
                yPoints2 = new int[]{y1 + 4, y2 + 4 - dy, y2 + 4};
            }
        } else {
            xPoints1 = new int[]{x1, x2};
            yPoints1 = new int[]{y1 - 4, y2 - 4};
            xPoints2 = new int[]{x1, x2};
            yPoints2 = new int[]{y1 + 4, y2 + 4};
        }
        DiffLineSeparatorRenderer.paintLine(g, xPoints1, yPoints1, xPoints2, yPoints2);
    }

    public void paint(Editor editor, Graphics g, Rectangle r) {
        if (!this.myCondition.get()) {
            return;
        }
        int y = r.y;
        int gutterWidth = ((EditorEx)editor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        DiffLineSeparatorRenderer.draw(g, 0, gutterWidth, 0, y, lineHeight);
    }

    public void drawLine(Graphics g, int x1, int x2, int y) {
        if (!this.myCondition.get()) {
            return;
        }
        Rectangle clip = g.getClipBounds();
        x2 = clip.x + clip.width;
        int gutterWidth = ((EditorEx)this.myEditor).getGutterComponentEx().getWidth();
        int lineHeight = this.myEditor.getLineHeight();
        DiffLineSeparatorRenderer.draw(g, x1, x2, -gutterWidth, ++y, lineHeight);
    }

    private static void draw(@NotNull Graphics g, int x1, int x2, int shiftX, int shiftY, int lineHeight) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "draw"));
        }
        int halfHeight = lineHeight / 2;
        int count = (x2 - x1) / 4 + 3;
        int[] xPoints1 = new int[count];
        int[] yPoints1 = new int[count];
        int[] xPoints2 = new int[count];
        int[] yPoints2 = new int[count];
        int shift = Math.max(x1 - shiftX / 4, 0);
        for (int index = 0; index < count; ++index) {
            int yPos2;
            int yPos1;
            int absIndex = index + shift;
            int xPos = absIndex * 4 + shiftX;
            if (absIndex == 0) {
                yPos1 = halfHeight + shiftY - 4;
                yPos2 = halfHeight + shiftY + 4;
            } else if (absIndex % 2 == 0) {
                yPos1 = halfHeight + shiftY - 2;
                yPos2 = halfHeight + shiftY + 4 + 2;
            } else {
                yPos1 = halfHeight + shiftY - 4 - 2;
                yPos2 = halfHeight + shiftY + 2;
            }
            xPoints1[index] = xPos;
            yPoints1[index] = yPos1;
            xPoints2[index] = xPos;
            yPoints2[index] = yPos2;
        }
        DiffLineSeparatorRenderer.paintLine(g, xPoints1, yPoints1, xPoints2, yPoints2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void paintLine(@NotNull Graphics g, @NotNull int[] xPoints1, @NotNull int[] yPoints1, @NotNull int[] xPoints2, @NotNull int[] yPoints2) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (xPoints1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xPoints1", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (yPoints1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPoints1", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (xPoints2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xPoints2", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        if (yPoints2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "yPoints2", "com/intellij/diff/util/DiffLineSeparatorRenderer", "paintLine"));
        }
        GraphicsConfig config = GraphicsUtil.disableAAPainting((Graphics)g);
        try {
            Color innerColor = DiffLineSeparatorRenderer.getInnerColor();
            Color outerColor = DiffLineSeparatorRenderer.getOuterColor();
            if (innerColor != null) {
                g.setColor(innerColor);
                int[] xPoints = DiffLineSeparatorRenderer.mergeReverse(xPoints1, xPoints2);
                int[] yPoints = DiffLineSeparatorRenderer.mergeReverse(yPoints1, yPoints2);
                g.fillPolygon(xPoints, yPoints, xPoints.length);
            }
            if (outerColor != null) {
                g.setColor(outerColor);
                g.drawPolyline(xPoints1, yPoints1, xPoints1.length);
                g.drawPolyline(xPoints2, yPoints2, xPoints2.length);
            }
        }
        finally {
            config.restore();
        }
    }

    @NotNull
    private static int[] mergeReverse(@NotNull int[] a1, @NotNull int[] a2) {
        if (a1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a1", "com/intellij/diff/util/DiffLineSeparatorRenderer", "mergeReverse"));
        }
        if (a2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "a2", "com/intellij/diff/util/DiffLineSeparatorRenderer", "mergeReverse"));
        }
        int[] result = new int[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        for (int i = 0; i < a2.length; ++i) {
            result[result.length - i - 1] = a2[i];
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/util/DiffLineSeparatorRenderer", "mergeReverse"));
        }
        return result;
    }

    @Nullable
    public static Color getOuterColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.TEARLINE_COLOR);
    }

    @Nullable
    public static Color getInnerColor() {
        return EditorColorsManager.getInstance().getGlobalScheme().getColor(EditorColors.GUTTER_BACKGROUND);
    }
}

