/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide;

import com.intellij.ide.FrameStateListener;
import com.intellij.ide.FrameStateManager;
import com.intellij.ide.GeneralSettings;
import com.intellij.ide.IdeEventQueue;
import com.intellij.ide.SaveAndSyncHandler;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.LaterInvocator;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.vfs.newvfs.RefreshSession;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SaveAndSyncHandlerImpl
implements ApplicationComponent,
SaveAndSyncHandler {
    private static final Logger LOG = Logger.getInstance(SaveAndSyncHandler.class);
    private final Runnable myIdleListener;
    private final PropertyChangeListener myGeneralSettingsListener;
    private final ProgressManager myProgressManager;
    private final AtomicInteger myBlockSaveOnFrameDeactivationCount;
    private final AtomicInteger myBlockSyncOnFrameActivationCount;
    private final SingleAlarm myRefreshDelayAlarm;
    private long myRefreshSessionId;

    public static SaveAndSyncHandlerImpl getInstance() {
        return (SaveAndSyncHandlerImpl)ApplicationManager.getApplication().getComponent(SaveAndSyncHandler.class);
    }

    public SaveAndSyncHandlerImpl(@NotNull FrameStateManager frameStateManager, final @NotNull FileDocumentManager fileDocumentManager, final @NotNull GeneralSettings generalSettings, @NotNull ProgressManager progressManager) {
        if (frameStateManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameStateManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (fileDocumentManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDocumentManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (generalSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "generalSettings", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        if (progressManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progressManager", "com/intellij/ide/SaveAndSyncHandlerImpl", "<init>"));
        }
        this.myBlockSaveOnFrameDeactivationCount = new AtomicInteger();
        this.myBlockSyncOnFrameActivationCount = new AtomicInteger();
        this.myRefreshDelayAlarm = new SingleAlarm(new Runnable(){

            @Override
            public void run() {
                if (SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    SaveAndSyncHandlerImpl.refreshOpenFiles();
                }
                SaveAndSyncHandlerImpl.this.maybeRefresh(ModalityState.NON_MODAL);
            }
        }, 300);
        this.myRefreshSessionId = 0L;
        this.myProgressManager = progressManager;
        this.myIdleListener = new Runnable(){

            @Override
            public void run() {
                if (generalSettings.isAutoSaveIfInactive() && SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    ((FileDocumentManagerImpl)fileDocumentManager).saveAllDocuments(false);
                }
            }
        };
        IdeEventQueue.getInstance().addIdleListener(this.myIdleListener, generalSettings.getInactiveTimeout() * 1000);
        this.myGeneralSettingsListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(@NotNull PropertyChangeEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/SaveAndSyncHandlerImpl$3", "propertyChange"));
                }
                if ("inactiveTimeout".equals(e.getPropertyName())) {
                    IdeEventQueue eventQueue = IdeEventQueue.getInstance();
                    eventQueue.removeIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener);
                    Integer timeout = (Integer)e.getNewValue();
                    eventQueue.addIdleListener(SaveAndSyncHandlerImpl.this.myIdleListener, timeout * 1000);
                }
            }
        };
        generalSettings.addPropertyChangeListener(this.myGeneralSettingsListener);
        frameStateManager.addListener(new FrameStateListener(){

            public void onFrameDeactivated() {
                if (SaveAndSyncHandlerImpl.this.canSyncOrSave()) {
                    SaveAndSyncHandlerImpl.this.saveProjectsAndDocuments();
                }
            }

            public void onFrameActivated() {
                if (ApplicationManager.getApplication().isDisposed() || !generalSettings.isSyncOnFrameActivation()) {
                    return;
                }
                LOG.debug("enter: refreshFiles()");
                SaveAndSyncHandlerImpl.this.myRefreshDelayAlarm.cancelAndRequest();
                LOG.debug("exit: refreshFiles()");
            }
        });
    }

    @NotNull
    public String getComponentName() {
        if ("SaveAndSyncHandler" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/SaveAndSyncHandlerImpl", "getComponentName"));
        }
        return "SaveAndSyncHandler";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
        GeneralSettings.getInstance().removePropertyChangeListener(this.myGeneralSettingsListener);
        IdeEventQueue.getInstance().removeIdleListener(this.myIdleListener);
    }

    private boolean canSyncOrSave() {
        return !LaterInvocator.isInModalContext() && !this.myProgressManager.hasModalProgressIndicator();
    }

    public void saveProjectsAndDocuments() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("enter: save()");
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        if (this.myBlockSaveOnFrameDeactivationCount.get() == 0 && GeneralSettings.getInstance().isSaveOnFrameDeactivation()) {
            Project[] openProjects;
            FileDocumentManager.getInstance().saveAllDocuments();
            for (Project project : openProjects = ProjectManagerEx.getInstanceEx().getOpenProjects()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("save project: " + project);
                }
                project.save();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("save application settings");
            }
            ApplicationManagerEx.getApplicationEx().saveSettings();
            if (LOG.isDebugEnabled()) {
                LOG.debug("exit: save()");
            }
        }
    }

    public void maybeRefresh(@NotNull ModalityState modalityState) {
        if (modalityState == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modalityState", "com/intellij/ide/SaveAndSyncHandlerImpl", "maybeRefresh"));
        }
        if (this.myBlockSyncOnFrameActivationCount.get() == 0 && GeneralSettings.getInstance().isSyncOnFrameActivation()) {
            LOG.debug("VFS refresh started");
            RefreshQueue queue = RefreshQueue.getInstance();
            queue.cancelSession(this.myRefreshSessionId);
            RefreshSession session = queue.createSession(true, true, null, modalityState);
            session.addAllFiles(ManagingFS.getInstance().getLocalRoots());
            this.myRefreshSessionId = session.getId();
            session.launch();
            LOG.debug("VFS refresh finished");
        }
    }

    public static void refreshOpenFiles() {
        ArrayList files = ContainerUtil.newArrayList();
        for (Project project : ProjectManager.getInstance().getOpenProjects()) {
            VirtualFile[] projectFiles;
            for (VirtualFile file : projectFiles = FileEditorManager.getInstance((Project)project).getSelectedFiles()) {
                if (!(file instanceof NewVirtualFile)) continue;
                files.add(file);
            }
        }
        if (!files.isEmpty()) {
            RefreshQueue.getInstance().refresh(false, false, null, (Collection)files);
        }
    }

    @Override
    public void blockSaveOnFrameDeactivation() {
        this.myBlockSaveOnFrameDeactivationCount.incrementAndGet();
    }

    @Override
    public void unblockSaveOnFrameDeactivation() {
        this.myBlockSaveOnFrameDeactivationCount.decrementAndGet();
    }

    @Override
    public void blockSyncOnFrameActivation() {
        this.myBlockSyncOnFrameActivationCount.incrementAndGet();
    }

    @Override
    public void unblockSyncOnFrameActivation() {
        this.myBlockSyncOnFrameActivationCount.decrementAndGet();
    }
}

