/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Key;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class FileTemplateManager {
    public static final Key<Properties> DEFAULT_TEMPLATE_PROPERTIES = Key.create((String)"DEFAULT_TEMPLATE_PROPERTIES");
    public static final int RECENT_TEMPLATES_SIZE = 25;
    @NonNls
    public static final String INTERNAL_HTML_TEMPLATE_NAME = "Html";
    @NonNls
    public static final String INTERNAL_HTML5_TEMPLATE_NAME = "Html5";
    @NonNls
    public static final String INTERNAL_XHTML_TEMPLATE_NAME = "Xhtml";
    @NonNls
    public static final String FILE_HEADER_TEMPLATE_NAME = "File Header";
    public static final String DEFAULT_TEMPLATES_CATEGORY = "Default";
    public static final String INTERNAL_TEMPLATES_CATEGORY = "Internal";
    public static final String INCLUDES_TEMPLATES_CATEGORY = "Includes";
    public static final String CODE_TEMPLATES_CATEGORY = "Code";
    public static final String J2EE_TEMPLATES_CATEGORY = "J2EE";
    public static final String PROJECT_NAME_VARIABLE = "PROJECT_NAME";

    public static FileTemplateManager getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/FileTemplateManager", "getInstance"));
        }
        return ((FileTemplateManager)ServiceManager.getService((Project)project, FileTemplateManager.class)).checkInitialized();
    }

    protected FileTemplateManager checkInitialized() {
        return this;
    }

    @Deprecated
    public static FileTemplateManager getInstance() {
        return FileTemplateManager.getDefaultInstance();
    }

    public static FileTemplateManager getDefaultInstance() {
        return FileTemplateManager.getInstance(ProjectManager.getInstance().getDefaultProject());
    }

    @NotNull
    public abstract FileTemplatesScheme getCurrentScheme();

    public abstract void setCurrentScheme(@NotNull FileTemplatesScheme var1);

    public abstract FileTemplatesScheme getProjectScheme();

    public abstract FileTemplate[] getTemplates(String var1);

    @NotNull
    public abstract FileTemplate[] getAllTemplates();

    public abstract FileTemplate getTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract Properties getDefaultProperties();

    @Deprecated
    @NotNull
    public Properties getDefaultProperties(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/fileTemplates/FileTemplateManager", "getDefaultProperties"));
        }
        Properties properties = this.getDefaultProperties();
        properties.setProperty(PROJECT_NAME_VARIABLE, project.getName());
        Properties properties2 = properties;
        if (properties2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/FileTemplateManager", "getDefaultProperties"));
        }
        return properties2;
    }

    @NotNull
    public abstract FileTemplate addTemplate(@NotNull @NonNls String var1, @NotNull @NonNls String var2);

    public abstract void removeTemplate(@NotNull FileTemplate var1);

    @NotNull
    public abstract Collection<String> getRecentNames();

    public abstract void addRecentName(@NotNull @NonNls String var1);

    public abstract FileTemplate getInternalTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate[] getInternalTemplates();

    public abstract FileTemplate getJ2eeTemplate(@NotNull @NonNls String var1);

    public abstract FileTemplate getCodeTemplate(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate[] getAllPatterns();

    @NotNull
    public abstract FileTemplate[] getAllCodeTemplates();

    @NotNull
    public abstract FileTemplate[] getAllJ2eeTemplates();

    @NotNull
    public abstract String internalTemplateToSubject(@NotNull @NonNls String var1);

    @Deprecated
    @NotNull
    public abstract String localizeInternalTemplateName(@NotNull FileTemplate var1);

    public abstract FileTemplate getPattern(@NotNull @NonNls String var1);

    @NotNull
    public abstract FileTemplate getDefaultTemplate(@NotNull @NonNls String var1);

    public abstract void setTemplates(@NotNull String var1, @NotNull Collection<FileTemplate> var2);
}

