/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.actions;

import com.intellij.ide.IdeView;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.actions.AttributesDefaults;
import com.intellij.ide.fileTemplates.ui.CreateFromTemplateDialog;
import com.intellij.ide.util.DirectoryChooserUtil;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class CreateFromTemplateActionBase
extends AnAction {
    public CreateFromTemplateActionBase(String title, String description, Icon icon) {
        super(title, description, icon);
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null) {
            return;
        }
        PsiDirectory dir = this.getTargetDirectory(dataContext, view);
        if (dir == null) {
            return;
        }
        Project project = dir.getProject();
        FileTemplate selectedTemplate = this.getTemplate(project, dir);
        if (selectedTemplate != null) {
            AnAction action = this.getReplacedAction(selectedTemplate);
            if (action != null) {
                action.actionPerformed(e);
            } else {
                FileTemplateManager.getInstance(project).addRecentName(selectedTemplate.getName());
                AttributesDefaults defaults = this.getAttributesDefaults(dataContext);
                CreateFromTemplateDialog dialog = new CreateFromTemplateDialog(project, dir, selectedTemplate, defaults, defaults != null ? defaults.getDefaultProperties() : null);
                PsiElement createdElement = dialog.create();
                if (createdElement != null) {
                    this.elementCreated(dialog, createdElement);
                    view.selectElement(createdElement);
                }
            }
        }
    }

    @Nullable
    protected PsiDirectory getTargetDirectory(DataContext dataContext, IdeView view) {
        return DirectoryChooserUtil.getOrChooseDirectory(view);
    }

    @Nullable
    protected abstract AnAction getReplacedAction(FileTemplate var1);

    protected abstract FileTemplate getTemplate(Project var1, PsiDirectory var2);

    @Nullable
    public AttributesDefaults getAttributesDefaults(DataContext dataContext) {
        return null;
    }

    protected void elementCreated(CreateFromTemplateDialog dialog, PsiElement createdElement) {
    }
}

