/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionButtonComponent;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionHolder;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.ex.ActionButtonLook;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionManagerImpl;
import com.intellij.openapi.actionSystem.impl.ActionMenu;
import com.intellij.openapi.actionSystem.impl.ActionPopupMenuImpl;
import com.intellij.openapi.actionSystem.impl.MenuItemPresentationFactory;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.IconLoader;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionButton
extends JComponent
implements ActionButtonComponent,
AnActionHolder {
    private static final Insets ICON_INSETS = new JBInsets(2, 2, 2, 2);
    private static final Icon ourEmptyIcon = EmptyIcon.ICON_18;
    private JBDimension myMinimumButtonSize;
    private PropertyChangeListener myActionButtonSynchronizer;
    private Icon myDisabledIcon;
    private Icon myIcon;
    protected final Presentation myPresentation;
    protected final AnAction myAction;
    private final String myPlace;
    private ActionButtonLook myLook;
    private boolean myMouseDown;
    private boolean myRollover;
    private static boolean ourGlobalMouseDown = false;
    private boolean myNoIconsInPopup;
    private Insets myInsets;

    public ActionButton(AnAction action, Presentation presentation, String place, @NotNull Dimension minimumSize) {
        if (minimumSize == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimumSize", "com/intellij/openapi/actionSystem/impl/ActionButton", "<init>"));
        }
        this.myLook = ActionButtonLook.IDEA_LOOK;
        this.myNoIconsInPopup = false;
        this.setMinimumButtonSize(minimumSize);
        this.setIconInsets(null);
        this.myRollover = false;
        this.myMouseDown = false;
        this.myAction = action;
        this.myPresentation = presentation;
        this.myPlace = place;
        this.setFocusable(false);
        this.enableEvents(16L);
        this.myMinimumButtonSize = JBDimension.create((Dimension)minimumSize);
        this.putClientProperty("ToCenterTooltip", Boolean.TRUE);
    }

    public void setNoIconsInPopup(boolean noIconsInPopup) {
        this.myNoIconsInPopup = noIconsInPopup;
    }

    public void setMinimumButtonSize(@NotNull Dimension size) {
        if (size == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "size", "com/intellij/openapi/actionSystem/impl/ActionButton", "setMinimumButtonSize"));
        }
        this.myMinimumButtonSize = JBDimension.create((Dimension)size);
    }

    @Override
    public void paintChildren(Graphics g) {
    }

    public int getPopState() {
        if (this.myAction instanceof Toggleable) {
            Boolean selected = (Boolean)this.myPresentation.getClientProperty("selected");
            boolean flag1 = selected != null && selected != false;
            return this.getPopState(flag1);
        }
        return this.getPopState(false);
    }

    protected boolean isButtonEnabled() {
        return this.isEnabled() && this.myPresentation.isEnabled();
    }

    private void onMousePresenceChanged(boolean setInfo) {
        ActionMenu.showDescriptionInStatusBar(setInfo, this, this.myPresentation.getDescription());
    }

    public void click() {
        this.performAction(new MouseEvent(this, 500, System.currentTimeMillis(), 0, 0, 0, 1, false));
    }

    private void performAction(MouseEvent e) {
        AnActionEvent event = new AnActionEvent((InputEvent)e, this.getDataContext(), this.myPlace, this.myPresentation, ActionManager.getInstance(), e.getModifiers());
        if (!ActionUtil.lastUpdateAndCheckDumb((AnAction)this.myAction, (AnActionEvent)event, (boolean)false)) {
            return;
        }
        if (this.isButtonEnabled()) {
            ActionManagerEx manager = ActionManagerEx.getInstanceEx();
            DataContext dataContext = event.getDataContext();
            manager.fireBeforeActionPerformed(this.myAction, dataContext, event);
            Component component = (Component)PlatformDataKeys.CONTEXT_COMPONENT.getData(dataContext);
            if (component != null && !component.isShowing()) {
                return;
            }
            this.actionPerformed(event);
            manager.queueActionPerformedEvent(this.myAction, dataContext, event);
        }
    }

    protected DataContext getDataContext() {
        ActionToolbar actionToolbar = (ActionToolbar)UIUtil.getParentOfType(ActionToolbar.class, (Component)this);
        return actionToolbar != null ? actionToolbar.getToolbarDataContext() : DataManager.getInstance().getDataContext();
    }

    private void actionPerformed(AnActionEvent event) {
        if (this.myAction instanceof ActionGroup && !(this.myAction instanceof CustomComponentAction) && ((ActionGroup)this.myAction).isPopup()) {
            ActionManagerImpl am = (ActionManagerImpl)ActionManager.getInstance();
            ActionPopupMenuImpl popupMenu = (ActionPopupMenuImpl)am.createActionPopupMenu(event.getPlace(), (ActionGroup)this.myAction, new MenuItemPresentationFactory(){

                @Override
                protected void processPresentation(Presentation presentation) {
                    if (ActionButton.this.myNoIconsInPopup) {
                        presentation.setIcon(null);
                        presentation.setHoveredIcon(null);
                    }
                }
            });
            popupMenu.setDataContextProvider(new Getter<DataContext>(){

                public DataContext get() {
                    return ActionButton.this.getDataContext();
                }
            });
            if (ActionPlaces.isToolbarPlace((String)event.getPlace())) {
                popupMenu.getComponent().show(this, 0, this.getHeight());
            } else {
                popupMenu.getComponent().show(this, this.getWidth(), 0);
            }
        } else {
            ActionUtil.performActionDumbAware((AnAction)this.myAction, (AnActionEvent)event);
        }
    }

    @Override
    public void removeNotify() {
        if (this.myActionButtonSynchronizer != null) {
            this.myPresentation.removePropertyChangeListener(this.myActionButtonSynchronizer);
            this.myActionButtonSynchronizer = null;
        }
        super.removeNotify();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        if (this.myActionButtonSynchronizer == null) {
            this.myActionButtonSynchronizer = new ActionButtonSynchronizer();
            this.myPresentation.addPropertyChangeListener(this.myActionButtonSynchronizer);
        }
        AnActionEvent e = new AnActionEvent(null, this.getDataContext(), this.myPlace, this.myPresentation, ActionManager.getInstance(), 0);
        ActionUtil.performDumbAwareUpdate((AnAction)this.myAction, (AnActionEvent)e, (boolean)false);
        this.updateToolTipText();
        this.updateIcon();
    }

    @Override
    public void setToolTipText(String s) {
        String tooltipText = KeymapUtil.createTooltipText((String)s, (AnAction)this.myAction);
        super.setToolTipText(tooltipText.length() > 0 ? tooltipText : null);
    }

    @Override
    public Dimension getPreferredSize() {
        Icon icon = this.getIcon();
        if (icon.getIconWidth() < this.myMinimumButtonSize.width && icon.getIconHeight() < this.myMinimumButtonSize.height) {
            return this.myMinimumButtonSize;
        }
        return new Dimension(icon.getIconWidth() + this.myInsets.left + this.myInsets.right, icon.getIconHeight() + this.myInsets.top + this.myInsets.bottom);
    }

    public void setIconInsets(@Nullable Insets insets) {
        this.myInsets = insets != null ? JBUI.insets((Insets)insets) : new Insets(0, 0, 0, 0);
    }

    @Override
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    protected Icon getIcon() {
        Icon icon;
        Icon icon2 = icon = this.isButtonEnabled() ? this.myIcon : this.myDisabledIcon;
        if (icon == null) {
            icon = ourEmptyIcon;
        }
        return icon;
    }

    public void updateIcon() {
        this.myIcon = this.myPresentation.getIcon();
        this.myDisabledIcon = this.myPresentation.getDisabledIcon() != null ? this.myPresentation.getDisabledIcon() : IconLoader.getDisabledIcon((Icon)this.myIcon);
    }

    private void setDisabledIcon(Icon icon) {
        this.myDisabledIcon = icon;
    }

    void updateToolTipText() {
        String text = this.myPresentation.getText();
        this.setToolTipText(text == null ? this.myPresentation.getDescription() : text);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintButtonLook(g);
        if (this.myAction instanceof ActionGroup && ((ActionGroup)this.myAction).isPopup()) {
            int x = 5;
            int y = 4;
            if (this.getPopState() == -1) {
                ++x;
                ++y;
            }
            AllIcons.General.Dropdown.paintIcon(this, g, x, y);
        }
    }

    protected void paintButtonLook(Graphics g) {
        ActionButtonLook look = this.getButtonLook();
        look.paintBackground(g, this);
        look.paintIcon(g, this, this.getIcon());
        look.paintBorder(g, this);
    }

    protected ActionButtonLook getButtonLook() {
        return this.myLook;
    }

    public void setLook(ActionButtonLook look) {
        this.myLook = look != null ? look : ActionButtonLook.IDEA_LOOK;
        this.repaint();
    }

    @Override
    protected void processMouseEvent(MouseEvent e) {
        super.processMouseEvent(e);
        if (e.isConsumed()) {
            return;
        }
        boolean skipPress = e.isMetaDown() || e.getButton() != 1;
        switch (e.getID()) {
            case 501: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = true;
                ourGlobalMouseDown = true;
                this.repaint();
                break;
            }
            case 502: {
                if (skipPress || !this.isButtonEnabled()) {
                    return;
                }
                this.myMouseDown = false;
                ourGlobalMouseDown = false;
                if (this.myRollover) {
                    this.performAction(e);
                }
                this.repaint();
                break;
            }
            case 504: {
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.myRollover = true;
                this.repaint();
                this.onMousePresenceChanged(true);
                break;
            }
            case 505: {
                this.myRollover = false;
                if (!this.myMouseDown && ourGlobalMouseDown) break;
                this.repaint();
                this.onMousePresenceChanged(false);
            }
        }
    }

    private int getPopState(boolean isPushed) {
        if (isPushed || this.myRollover && this.myMouseDown && this.isButtonEnabled()) {
            return -1;
        }
        return !this.myRollover || !this.isButtonEnabled() ? 0 : 1;
    }

    public AnAction getAction() {
        return this.myAction;
    }

    private class ActionButtonSynchronizer
    implements PropertyChangeListener {
        @NonNls
        protected static final String SELECTED_PROPERTY_NAME = "selected";

        private ActionButtonSynchronizer() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String propertyName = e.getPropertyName();
            if ("text".equals(propertyName)) {
                ActionButton.this.updateToolTipText();
            } else if ("enabled".equals(propertyName)) {
                ActionButton.this.updateIcon();
                ActionButton.this.repaint();
            } else if ("icon".equals(propertyName)) {
                ActionButton.this.updateIcon();
                ActionButton.this.repaint();
            } else if ("disabledIcon".equals(propertyName)) {
                ActionButton.this.setDisabledIcon(ActionButton.this.myPresentation.getDisabledIcon());
                ActionButton.this.repaint();
            } else if (!"visible".equals(propertyName) && SELECTED_PROPERTY_NAME.equals(propertyName)) {
                ActionButton.this.repaint();
            }
        }
    }
}

