/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem.impl;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Presentation;
import java.util.WeakHashMap;
import org.jetbrains.annotations.NotNull;

public class PresentationFactory {
    private final WeakHashMap<AnAction, Presentation> myAction2Presentation = new WeakHashMap();

    public final Presentation getPresentation(@NotNull AnAction action) {
        if (action == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "action", "com/intellij/openapi/actionSystem/impl/PresentationFactory", "getPresentation"));
        }
        Presentation presentation = this.myAction2Presentation.get(action);
        if (presentation == null || !action.isDefaultIcon()) {
            Presentation templatePresentation = action.getTemplatePresentation();
            if (presentation == null) {
                presentation = templatePresentation.clone();
                this.myAction2Presentation.put(action, presentation);
            }
            if (!action.isDefaultIcon()) {
                presentation.setIcon(templatePresentation.getIcon());
                presentation.setDisabledIcon(templatePresentation.getDisabledIcon());
            }
            this.processPresentation(presentation);
        }
        return presentation;
    }

    protected void processPresentation(Presentation presentation) {
    }

    public void reset() {
        this.myAction2Presentation.clear();
    }
}

