/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.impl.stores;

import com.intellij.application.options.PathMacrosCollector;
import com.intellij.openapi.components.PathMacroSubstitutor;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.XmlConfigurationMerger;
import com.intellij.openapi.components.impl.stores.StateMap;
import com.intellij.openapi.components.impl.stores.StorageDataBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.util.containers.StringInterner;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StorageData
extends StorageDataBase {
    private static final Logger LOG = Logger.getInstance(StorageData.class);
    @NonNls
    public static final String COMPONENT = "component";
    @NonNls
    public static final String NAME = "name";
    private final StateMap myStates;
    protected final String myRootElementName;

    public StorageData(@NotNull String rootElementName) {
        if (rootElementName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElementName", "com/intellij/openapi/components/impl/stores/StorageData", "<init>"));
        }
        this.myStates = new StateMap();
        this.myRootElementName = rootElementName;
    }

    StorageData(@NotNull StorageData storageData) {
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/StorageData", "<init>"));
        }
        this.myRootElementName = storageData.myRootElementName;
        this.myStates = new StateMap(storageData.myStates);
    }

    @Override
    @NotNull
    public Set<String> getComponentNames() {
        Set<String> set = this.myStates.keys();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "getComponentNames"));
        }
        return set;
    }

    public void load(@NotNull Element rootElement, @Nullable PathMacroSubstitutor pathMacroSubstitutor, boolean intern) {
        if (rootElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootElement", "com/intellij/openapi/components/impl/stores/StorageData", "load"));
        }
        if (pathMacroSubstitutor != null) {
            pathMacroSubstitutor.expandPaths(rootElement);
        }
        StringInterner interner = intern ? new StringInterner() : null;
        Iterator iterator = rootElement.getChildren(COMPONENT).iterator();
        while (iterator.hasNext()) {
            Object serverElement;
            Element element = (Element)iterator.next();
            String name = StorageData.getComponentNameIfValid(element);
            if (name == null || element.getAttributes().size() <= 1 && element.getChildren().isEmpty()) continue;
            iterator.remove();
            if (interner != null) {
                JDOMUtil.internElement((Element)element, (StringInterner)interner);
            }
            if ((serverElement = this.myStates.get(name)) != null) {
                element = StorageData.mergeElements(name, element, (Element)serverElement);
            }
            this.myStates.put(name, element);
            if (pathMacroSubstitutor instanceof TrackingPathMacroSubstitutor) {
                ((TrackingPathMacroSubstitutor)pathMacroSubstitutor).addUnknownMacros(name, PathMacrosCollector.getMacroNames(element));
            }
            element.removeAttribute(NAME);
        }
    }

    @Nullable
    static String getComponentNameIfValid(@NotNull Element element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/components/impl/stores/StorageData", "getComponentNameIfValid"));
        }
        String name = element.getAttributeValue(NAME);
        if (StringUtil.isEmpty((String)name)) {
            LOG.warn("No name attribute for component in " + JDOMUtil.writeElement((Element)element));
            return null;
        }
        return name;
    }

    @NotNull
    private static Element mergeElements(@NotNull String name, @NotNull Element localElement, @NotNull Element serverElement) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        if (localElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "localElement", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        if (serverElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "serverElement", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        ExtensionPoint point = Extensions.getRootArea().getExtensionPoint("com.intellij.componentConfigurationMerger");
        for (XmlConfigurationMerger merger : (XmlConfigurationMerger[])point.getExtensions()) {
            if (!merger.getComponentName().equals(name)) continue;
            Element element = merger.merge(serverElement, localElement);
            if (element == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
            }
            return element;
        }
        Element element = serverElement;
        if (element == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/impl/stores/StorageData", "mergeElements"));
        }
        return element;
    }

    @Nullable
    protected Element save(@NotNull Map<String, Element> newLiveStates) {
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "save"));
        }
        if (this.myStates.isEmpty()) {
            return null;
        }
        Element rootElement = new Element(this.myRootElementName);
        Object[] componentNames = ArrayUtil.toStringArray(this.myStates.keys());
        Arrays.sort(componentNames);
        for (Object componentName : componentNames) {
            assert (componentName != null);
            Element element = this.myStates.getElement((String)componentName, newLiveStates);
            List elementAttributes = element.getAttributes();
            if (elementAttributes.isEmpty()) {
                element.setAttribute(NAME, (String)componentName);
            } else {
                Attribute nameAttribute = element.getAttribute(NAME);
                if (nameAttribute == null) {
                    nameAttribute = new Attribute(NAME, (String)componentName);
                    elementAttributes.add(0, nameAttribute);
                } else {
                    nameAttribute.setValue((String)componentName);
                    if (elementAttributes.get(0) != nameAttribute) {
                        elementAttributes.remove(nameAttribute);
                        elementAttributes.add(0, nameAttribute);
                    }
                }
            }
            rootElement.addContent(element);
        }
        return rootElement;
    }

    @Nullable
    public Element getState(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "getState"));
        }
        return this.myStates.getState(name);
    }

    @Nullable
    public Element getStateAndArchive(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", NAME, "com/intellij/openapi/components/impl/stores/StorageData", "getStateAndArchive"));
        }
        return this.myStates.getStateAndArchive(name);
    }

    @Nullable
    static StorageData setStateAndCloneIfNeed(@NotNull String componentName, @Nullable Element newState, @NotNull StorageData storageData, @NotNull Map<String, Element> newLiveStates) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        if (storageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "storageData", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "setStateAndCloneIfNeed"));
        }
        Object oldState = storageData.myStates.get(componentName);
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            if (oldState == null) {
                return null;
            }
            StorageData newStorageData = storageData.clone();
            newStorageData.myStates.remove(componentName);
            return newStorageData;
        }
        StorageData.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        byte[] newBytes = null;
        if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState) : oldState != null && (newBytes = StateMap.getNewByteIfDiffers(componentName, newState, (byte[])oldState)) == null) {
            return null;
        }
        StorageData newStorageData = storageData.clone();
        newStorageData.myStates.put(componentName, newBytes == null ? newState : (Element)newBytes);
        return newStorageData;
    }

    @Nullable
    final Object setState(@NotNull String componentName, @Nullable Element newState, @NotNull Map<String, Element> newLiveStates) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "setState"));
        }
        if (newLiveStates == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newLiveStates", "com/intellij/openapi/components/impl/stores/StorageData", "setState"));
        }
        if (newState == null || JDOMUtil.isEmpty((Element)newState)) {
            return this.myStates.remove(componentName);
        }
        StorageData.prepareElement(newState);
        newLiveStates.put(componentName, newState);
        Object oldState = this.myStates.get(componentName);
        byte[] newBytes = null;
        if (oldState instanceof Element ? JDOMUtil.areElementsEqual((Element)((Element)oldState), (Element)newState) : oldState != null && (newBytes = StateMap.getNewByteIfDiffers(componentName, newState, (byte[])oldState)) == null) {
            return null;
        }
        this.myStates.put(componentName, newBytes == null ? newState : newBytes);
        return newState;
    }

    private static void prepareElement(@NotNull Element state) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/components/impl/stores/StorageData", "prepareElement"));
        }
        if (state.getParent() != null) {
            LOG.warn("State element must not have parent " + JDOMUtil.writeElement((Element)state));
            state.detach();
        }
        state.setName(COMPONENT);
    }

    public StorageData clone() {
        return new StorageData(this);
    }

    public Set<String> getChangedComponentNames(@NotNull StorageData newStorageData, @Nullable PathMacroSubstitutor substitutor) {
        if (newStorageData == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newStorageData", "com/intellij/openapi/components/impl/stores/StorageData", "getChangedComponentNames"));
        }
        SmartHashSet bothStates = new SmartHashSet(this.myStates.keys());
        bothStates.retainAll(newStorageData.myStates.keys());
        SmartHashSet diffs = new SmartHashSet();
        diffs.addAll(newStorageData.myStates.keys());
        diffs.addAll(this.myStates.keys());
        diffs.removeAll((Collection<?>)bothStates);
        for (String componentName : bothStates) {
            this.myStates.compare(componentName, newStorageData.myStates, (Set<String>)diffs);
        }
        return diffs;
    }

    @Override
    public boolean hasState(@NotNull String componentName) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/impl/stores/StorageData", "hasState"));
        }
        return this.myStates.hasState(componentName);
    }
}

