/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.components.store;

import com.intellij.openapi.components.StateStorage;
import com.intellij.openapi.components.StateStorageException;
import com.intellij.openapi.components.TrackingPathMacroSubstitutor;
import com.intellij.openapi.components.impl.stores.DefaultStateSerializer;
import com.intellij.openapi.components.impl.stores.StorageDataBase;
import com.intellij.openapi.diagnostic.Logger;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class StateStorageBase<T extends StorageDataBase>
implements StateStorage {
    protected static final Logger LOG = Logger.getInstance(StateStorageBase.class);
    private boolean mySavingDisabled = false;
    protected final TrackingPathMacroSubstitutor myPathMacroSubstitutor;

    protected StateStorageBase(@Nullable TrackingPathMacroSubstitutor trackingPathMacroSubstitutor) {
        this.myPathMacroSubstitutor = trackingPathMacroSubstitutor;
    }

    @Nullable
    public final <S> S getState(Object component, @NotNull String componentName, @NotNull Class<S> stateClass, @Nullable S mergeInto) throws StateStorageException {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/store/StateStorageBase", "getState"));
        }
        if (stateClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateClass", "com/intellij/openapi/components/store/StateStorageBase", "getState"));
        }
        return DefaultStateSerializer.deserializeState(this.getStateAndArchive(this.getStorageData(), componentName), stateClass, mergeInto);
    }

    @Nullable
    protected abstract Element getStateAndArchive(@NotNull T var1, @NotNull String var2);

    public final boolean hasState(@Nullable Object component, @NotNull String componentName, Class<?> aClass, boolean reloadData) {
        if (componentName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentName", "com/intellij/openapi/components/store/StateStorageBase", "hasState"));
        }
        return ((StorageDataBase)this.getStorageData(reloadData)).hasState(componentName);
    }

    @NotNull
    public final T getStorageData() {
        T t = this.getStorageData(false);
        if (t == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/components/store/StateStorageBase", "getStorageData"));
        }
        return t;
    }

    protected abstract T getStorageData(boolean var1);

    public final void disableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Disabled saving for " + this.toString());
        }
        this.mySavingDisabled = true;
    }

    public final void enableSaving() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Enabled saving " + this.toString());
        }
        this.mySavingDisabled = false;
    }

    protected final boolean checkIsSavingDisabled() {
        if (this.mySavingDisabled && LOG.isDebugEnabled()) {
            LOG.debug("Saving disabled for " + this.toString());
        }
        return this.mySavingDisabled;
    }
}

