/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl;

import com.intellij.codeStyle.CodeStyleFacade;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.diff.DiffContent;
import com.intellij.openapi.diff.DiffContentUtil;
import com.intellij.openapi.diff.DiffViewer;
import com.intellij.openapi.diff.impl.external.DiffManagerImpl;
import com.intellij.openapi.diff.impl.fragments.Fragment;
import com.intellij.openapi.diff.impl.fragments.LineFragment;
import com.intellij.openapi.diff.impl.string.DiffString;
import com.intellij.openapi.diff.impl.util.FocusDiffSide;
import com.intellij.openapi.diff.impl.util.TextDiffType;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.impl.softwrap.SoftWrapAppliancePlaces;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FrameWrapper;
import com.intellij.util.ImageLoader;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffUtil {
    private DiffUtil() {
    }

    public static void initDiffFrame(Project project, @NotNull FrameWrapper frameWrapper, @NotNull DiffViewer diffPanel, JComponent mainComponent) {
        if (frameWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "frameWrapper", "com/intellij/openapi/diff/impl/DiffUtil", "initDiffFrame"));
        }
        if (diffPanel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffPanel", "com/intellij/openapi/diff/impl/DiffUtil", "initDiffFrame"));
        }
        frameWrapper.setComponent(mainComponent);
        frameWrapper.setProject(project);
        frameWrapper.setImage(ImageLoader.loadFromResource((String)"/diff/Diff.png"));
        frameWrapper.setPreferredFocusedComponent(diffPanel.getPreferredFocusedComponent());
        frameWrapper.closeOnEsc();
    }

    @Nullable
    public static FocusDiffSide getFocusDiffSide(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/openapi/diff/impl/DiffUtil", "getFocusDiffSide"));
        }
        return (FocusDiffSide)FocusDiffSide.DATA_KEY.getData(dataContext);
    }

    @NotNull
    public static DiffString[] convertToLines(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/diff/impl/DiffUtil", "convertToLines"));
        }
        DiffString[] diffStringArray = DiffString.create((String)text).tokenize();
        if (diffStringArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffUtil", "convertToLines"));
        }
        return diffStringArray;
    }

    @NotNull
    public static FileType[] chooseContentTypes(@NotNull DiffContent[] contents) {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "com/intellij/openapi/diff/impl/DiffUtil", "chooseContentTypes"));
        }
        LanguageFileType commonType = FileTypes.PLAIN_TEXT;
        for (DiffContent content : contents) {
            FileType contentType = content.getContentType();
            if (!DiffContentUtil.isTextType((FileType)contentType)) continue;
            commonType = contentType;
        }
        FileType[] result = new FileType[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            FileType contentType = contents[i].getContentType();
            result[i] = DiffContentUtil.isTextType((FileType)contentType) ? contentType : commonType;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffUtil", "chooseContentTypes"));
        }
        return result;
    }

    public static boolean isWritable(@NotNull DiffContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/openapi/diff/impl/DiffUtil", "isWritable"));
        }
        Document document = content.getDocument();
        return document != null && document.isWritable();
    }

    public static EditorEx createEditor(Document document, Project project, boolean isViewer) {
        return DiffUtil.createEditor(document, project, isViewer, null);
    }

    public static EditorEx createEditor(Document document, Project project, boolean isViewer, @Nullable FileType fileType) {
        EditorFactory factory = EditorFactory.getInstance();
        EditorEx editor = (EditorEx)(isViewer ? factory.createViewer(document, project) : factory.createEditor(document, project));
        editor.putUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY, Boolean.TRUE);
        editor.setSoftWrapAppliancePlace(SoftWrapAppliancePlaces.VCS_DIFF);
        editor.getGutterComponentEx().revalidateMarkup();
        if (fileType != null && project != null && !project.isDisposed()) {
            CodeStyleFacade codeStyleFacade = CodeStyleFacade.getInstance((Project)project);
            editor.getSettings().setTabSize(codeStyleFacade.getTabSize(fileType));
            editor.getSettings().setUseTabCharacter(codeStyleFacade.useTabCharacter(fileType));
        }
        return editor;
    }

    public static void drawBoldDottedFramingLines(@NotNull Graphics2D g, int startX, int endX, int startY, int bottomY, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/diff/impl/DiffUtil", "drawBoldDottedFramingLines"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/diff/impl/DiffUtil", "drawBoldDottedFramingLines"));
        }
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)startY, null, (Color)color, (boolean)false);
        UIUtil.drawBoldDottedLine((Graphics2D)g, (int)startX, (int)endX, (int)bottomY, null, (Color)color, (boolean)false);
    }

    public static void drawDoubleShadowedLine(@NotNull Graphics2D g, int startX, int endX, int y, @NotNull Color color) {
        if (g == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "g", "com/intellij/openapi/diff/impl/DiffUtil", "drawDoubleShadowedLine"));
        }
        if (color == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "color", "com/intellij/openapi/diff/impl/DiffUtil", "drawDoubleShadowedLine"));
        }
        UIUtil.drawLine((Graphics2D)g, (int)startX, (int)y, (int)endX, (int)y, null, (Color)DiffUtil.getFramingColor(color));
        UIUtil.drawLine((Graphics2D)g, (int)startX, (int)(y + 1), (int)endX, (int)(y + 1), null, (Color)color);
    }

    @Nullable
    public static Color getFramingColor(@Nullable Color backgroundColor) {
        return backgroundColor != null ? backgroundColor.darker() : null;
    }

    @NotNull
    public static TextDiffType makeTextDiffType(@NotNull LineFragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/DiffUtil", "makeTextDiffType"));
        }
        TextDiffType type = TextDiffType.create(fragment.getType());
        if (DiffUtil.isInlineWrapper((Fragment)fragment)) {
            TextDiffType textDiffType = TextDiffType.deriveInstanceForInlineWrapperFragment(type);
            if (textDiffType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffUtil", "makeTextDiffType"));
            }
            return textDiffType;
        }
        TextDiffType textDiffType = type;
        if (textDiffType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/diff/impl/DiffUtil", "makeTextDiffType"));
        }
        return textDiffType;
    }

    public static boolean isInlineWrapper(@NotNull Fragment fragment) {
        if (fragment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fragment", "com/intellij/openapi/diff/impl/DiffUtil", "isInlineWrapper"));
        }
        return fragment instanceof LineFragment && ((LineFragment)fragment).getChildrenIterator() != null;
    }

    private static boolean isUnknownFileType(@NotNull DiffContent diffContent) {
        if (diffContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffContent", "com/intellij/openapi/diff/impl/DiffUtil", "isUnknownFileType"));
        }
        return FileTypes.UNKNOWN.equals(diffContent.getContentType());
    }

    private static boolean isEmptyFileType(@NotNull DiffContent diffContent) {
        if (diffContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "diffContent", "com/intellij/openapi/diff/impl/DiffUtil", "isEmptyFileType"));
        }
        return diffContent.getContentType() == null;
    }

    public static boolean oneIsUnknown(@Nullable DiffContent content1, @Nullable DiffContent content2) {
        if (content1 == null && content2 == null) {
            return true;
        }
        if (content1 != null && content2 != null) {
            return DiffUtil.isUnknownFileType(content1) || DiffUtil.isUnknownFileType(content2) || DiffUtil.isEmptyFileType(content1) && DiffUtil.isEmptyFileType(content2);
        }
        if (content1 != null) {
            return DiffUtil.isUnknownFileType(content1) || DiffUtil.isEmptyFileType(content1);
        }
        return DiffUtil.isUnknownFileType(content2) || DiffUtil.isEmptyFileType(content2);
    }

    public static boolean isDiffEditor(@NotNull Editor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/diff/impl/DiffUtil", "isDiffEditor"));
        }
        return editor.getUserData(DiffManagerImpl.EDITOR_IS_DIFF_KEY) != null;
    }
}

