/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.service;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.importing.ImportSpecBuilder;
import com.intellij.openapi.externalSystem.model.ExternalSystemDataKeys;
import com.intellij.openapi.externalSystem.service.project.ProjectRenameAware;
import com.intellij.openapi.externalSystem.service.project.autoimport.ExternalSystemAutoImporter;
import com.intellij.openapi.externalSystem.service.project.manage.ExternalProjectsManager;
import com.intellij.openapi.externalSystem.service.ui.ExternalToolWindowManager;
import com.intellij.openapi.externalSystem.service.vcs.ExternalSystemVcsRegistrar;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.util.ExternalSystemUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupActivity;
import com.intellij.openapi.startup.StartupManager;
import org.jetbrains.annotations.NotNull;

public class ExternalSystemStartupActivity
implements StartupActivity {
    public void runActivity(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/externalSystem/service/ExternalSystemStartupActivity", "runActivity"));
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return;
        }
        Runnable task = new Runnable(){

            @Override
            public void run() {
                ExternalProjectsManager.getInstance(project).init();
                for (ExternalSystemManager manager : ExternalSystemApiUtil.getAllManagers()) {
                    if (!(manager instanceof StartupActivity)) continue;
                    ((StartupActivity)manager).runActivity(project);
                }
                if (project.getUserData(ExternalSystemDataKeys.NEWLY_IMPORTED_PROJECT) != Boolean.TRUE) {
                    for (ExternalSystemManager manager : (ExternalSystemManager[])ExternalSystemManager.EP_NAME.getExtensions()) {
                        boolean isNewProject;
                        boolean bl = isNewProject = project.getUserData(ExternalSystemDataKeys.NEWLY_CREATED_PROJECT) == Boolean.TRUE;
                        if (isNewProject) {
                            ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, manager.getSystemId()));
                            continue;
                        }
                        ExternalSystemUtil.refreshProjects(new ImportSpecBuilder(project, manager.getSystemId()).whenAutoImportEnabled());
                    }
                }
                ExternalSystemAutoImporter.letTheMagicBegin(project);
                ExternalToolWindowManager.handle(project);
                ExternalSystemVcsRegistrar.handle(project);
                ProjectRenameAware.beAware(project);
            }
        };
        if (project.isInitialized()) {
            task.run();
        } else {
            StartupManager.getInstance((Project)project).registerPostStartupActivity(task);
        }
    }
}

