/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.fileEditor.impl;

import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.ProjectComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.EditorComposite;
import com.intellij.openapi.fileEditor.impl.EditorWindow;
import com.intellij.openapi.fileEditor.impl.EditorsSplitters;
import com.intellij.openapi.fileEditor.impl.text.TextEditorProvider;
import com.intellij.openapi.fileEditor.impl.text.TextEditorPsiDataProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.AsyncResult;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashMap;
import java.awt.Component;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public class TestEditorManagerImpl
extends FileEditorManagerEx
implements ApplicationComponent,
ProjectComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.idea.test.TestEditorManagerImpl");
    private final Project myProject;
    private final Map<VirtualFile, Editor> myVirtualFile2Editor = new HashMap();
    private VirtualFile myActiveFile = null;
    private static final LightVirtualFile LIGHT_VIRTUAL_FILE = new LightVirtualFile("Dummy.java");

    public TestEditorManagerImpl(Project project) {
        this.myProject = project;
        this.registerExtraEditorDataProvider(new TextEditorPsiDataProvider(), null);
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor, boolean searchForSplitter) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
        }
        FileEditorProvider provider = (FileEditorProvider)file.getUserData(FileEditorProvider.KEY);
        if (provider != null && provider.accept(this.getProject(), file)) {
            Pair pair = Pair.create((Object)new FileEditor[]{provider.createEditor(this.getProject(), file)}, (Object)new FileEditorProvider[]{provider});
            if (pair == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
            }
            return pair;
        }
        Editor editor = this.openTextEditor(new OpenFileDescriptor(this.myProject, file), focusEditor);
        assert (editor != null);
        TextEditor fileEditor = TextEditorProvider.getInstance().getTextEditor(editor);
        Pair pair = Pair.create((Object)new FileEditor[]{fileEditor}, (Object)new FileEditorProvider[]{TestEditorManagerImpl.getProvider()});
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> openFileWithProviders(@NotNull VirtualFile file, boolean focusEditor, @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
        }
        Pair<FileEditor[], FileEditorProvider[]> pair = this.openFileWithProviders(file, focusEditor, false);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openFileWithProviders"));
        }
        return pair;
    }

    @Override
    public boolean isInsideChange() {
        return false;
    }

    @Override
    @NotNull
    public ActionCallback notifyPublisher(@NotNull Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "notifyPublisher"));
        }
        runnable.run();
        ActionCallback.Done done = new ActionCallback.Done();
        if (done == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "notifyPublisher"));
        }
        return done;
    }

    @Override
    public EditorsSplitters getSplittersFor(Component c) {
        return null;
    }

    @Override
    public void createSplitter(int orientation, EditorWindow window) {
    }

    @Override
    public void changeSplitterOrientation() {
    }

    @Override
    public void flipTabs() {
    }

    @Override
    public boolean tabsMode() {
        return false;
    }

    @Override
    public boolean isInSplitter() {
        return false;
    }

    @Override
    public boolean hasOpenedFile() {
        return false;
    }

    @Override
    public VirtualFile getCurrentFile() {
        return this.myActiveFile;
    }

    @Override
    public Pair<FileEditor, FileEditorProvider> getSelectedEditorWithProvider(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getSelectedEditorWithProvider"));
        }
        return null;
    }

    @Override
    public boolean isChanged(@NotNull EditorComposite editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "isChanged"));
        }
        return false;
    }

    @Override
    public EditorWindow getNextWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getNextWindow"));
        }
        return null;
    }

    @Override
    public EditorWindow getPrevWindow(@NotNull EditorWindow window) {
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getPrevWindow"));
        }
        return null;
    }

    public void addTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addTopComponent"));
        }
    }

    public void removeTopComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeTopComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeTopComponent"));
        }
    }

    public void addBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addBottomComponent"));
        }
    }

    public void removeBottomComponent(@NotNull FileEditor editor, @NotNull JComponent component) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeBottomComponent"));
        }
        if (component == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeBottomComponent"));
        }
    }

    @Override
    public void closeAllFiles() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Iterator<Editor> it = this.myVirtualFile2Editor.values().iterator();
        while (it.hasNext()) {
            Editor editor = it.next();
            it.remove();
            if (editor == null || editor.isDisposed()) continue;
            editorFactory.releaseEditor(editor);
        }
    }

    private static FileEditorProvider getProvider() {
        return new FileEditorProvider(){

            public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "accept"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "accept"));
                }
                return false;
            }

            @NotNull
            public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "createEditor"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "createEditor"));
                }
                throw new IncorrectOperationException();
            }

            public void disposeEditor(@NotNull FileEditor editor) {
                if (editor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "disposeEditor"));
                }
            }

            @NotNull
            public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
                if (sourceElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "readState"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "readState"));
                }
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "readState"));
                }
                throw new IncorrectOperationException();
            }

            public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
                if (state == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "writeState"));
                }
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "writeState"));
                }
                if (targetElement == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "writeState"));
                }
            }

            @NotNull
            public String getEditorTypeId() {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl$1", "getEditorTypeId"));
                }
                return "";
            }

            @NotNull
            public FileEditorPolicy getPolicy() {
                throw new IncorrectOperationException();
            }
        };
    }

    @Override
    public EditorWindow getCurrentWindow() {
        return null;
    }

    @Override
    @NotNull
    public AsyncResult<EditorWindow> getActiveWindow() {
        AsyncResult.Done done = new AsyncResult.Done(null);
        if (done == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getActiveWindow"));
        }
        return done;
    }

    @Override
    public void setCurrentWindow(EditorWindow window) {
    }

    @Override
    public VirtualFile getFile(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getFile"));
        }
        return LIGHT_VIRTUAL_FILE;
    }

    @Override
    public void updateFilePresentation(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "updateFilePresentation"));
        }
    }

    @Override
    public void unsplitWindow() {
    }

    @Override
    public void unsplitAllWindow() {
    }

    @Override
    @NotNull
    public EditorWindow[] getWindows() {
        EditorWindow[] editorWindowArray = new EditorWindow[]{};
        if (editorWindowArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getWindows"));
        }
        return editorWindowArray;
    }

    public FileEditor getSelectedEditor(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getSelectedEditor"));
        }
        Editor editor = this.getEditor(file);
        return editor == null ? null : TextEditorProvider.getInstance().getTextEditor(editor);
    }

    public boolean isFileOpen(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "isFileOpen"));
        }
        return this.getEditor(file) != null;
    }

    @NotNull
    public FileEditor[] getEditors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getEditors"));
        }
        FileEditor e = this.getSelectedEditor(file);
        if (e == null) {
            FileEditor[] fileEditorArray = new FileEditor[]{};
            if (fileEditorArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getEditors"));
            }
            return fileEditorArray;
        }
        FileEditor[] fileEditorArray = new FileEditor[]{e};
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getEditors"));
        }
        return fileEditorArray;
    }

    @NotNull
    public FileEditor[] getAllEditors(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getAllEditors"));
        }
        FileEditor[] fileEditorArray = this.getEditors(file);
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getAllEditors"));
        }
        return fileEditorArray;
    }

    @Override
    @NotNull
    public VirtualFile[] getSiblings(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getSiblings"));
        }
        throw new UnsupportedOperationException();
    }

    public void disposeComponent() {
        this.closeAllFiles();
    }

    public void initComponent() {
    }

    public void projectClosed() {
        this.closeAllFiles();
    }

    public void projectOpened() {
    }

    public void closeFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "closeFile"));
        }
        Editor editor = this.myVirtualFile2Editor.remove(file);
        if (editor != null) {
            EditorFactory.getInstance().releaseEditor(editor);
        }
        if (Comparing.equal((Object)file, (Object)this.myActiveFile)) {
            this.myActiveFile = null;
        }
    }

    @Override
    public void closeFile(@NotNull VirtualFile file, @NotNull EditorWindow window) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "closeFile"));
        }
        if (window == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "window", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "closeFile"));
        }
        this.closeFile(file);
    }

    @NotNull
    public VirtualFile[] getSelectedFiles() {
        VirtualFile[] virtualFileArray;
        if (this.myActiveFile == null) {
            virtualFileArray = VirtualFile.EMPTY_ARRAY;
        } else {
            VirtualFile[] virtualFileArray2 = new VirtualFile[1];
            virtualFileArray = virtualFileArray2;
            virtualFileArray2[0] = this.myActiveFile;
        }
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getSelectedFiles"));
        }
        return virtualFileArray;
    }

    @NotNull
    public FileEditor[] getSelectedEditors() {
        FileEditor[] fileEditorArray = new FileEditor[]{};
        if (fileEditorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getSelectedEditors"));
        }
        return fileEditorArray;
    }

    public Editor getSelectedTextEditor() {
        return this.myActiveFile != null ? this.getEditor(this.myActiveFile) : null;
    }

    @Override
    public JComponent getComponent() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public VirtualFile[] getOpenFiles() {
        VirtualFile[] virtualFileArray = VfsUtilCore.toVirtualFileArray(this.myVirtualFile2Editor.keySet());
        if (virtualFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getOpenFiles"));
        }
        return virtualFileArray;
    }

    public Editor getEditor(VirtualFile file) {
        return this.myVirtualFile2Editor.get(file);
    }

    @NotNull
    public FileEditor[] getAllEditors() {
        FileEditor[] result = new FileEditor[this.myVirtualFile2Editor.size()];
        int i = 0;
        for (Map.Entry<VirtualFile, Editor> entry : this.myVirtualFile2Editor.entrySet()) {
            TextEditor textEditor = TextEditorProvider.getInstance().getTextEditor(entry.getValue());
            result[i++] = textEditor;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getAllEditors"));
        }
        return result;
    }

    public void showEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComoponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "showEditorAnnotation"));
        }
        if (annotationComoponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationComoponent", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "showEditorAnnotation"));
        }
    }

    public void removeEditorAnnotation(@NotNull FileEditor editor, @NotNull JComponent annotationComoponent) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeEditorAnnotation"));
        }
        if (annotationComoponent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "annotationComoponent", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeEditorAnnotation"));
        }
    }

    public Editor openTextEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openTextEditor"));
        }
        VirtualFile file = descriptor.getFile();
        Editor editor = this.myVirtualFile2Editor.get(file);
        if (editor == null) {
            PsiFile psiFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
            LOG.assertTrue(psiFile != null, (Object)file);
            Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            LOG.assertTrue(document != null, (Object)psiFile);
            editor = EditorFactory.getInstance().createEditor(document, this.myProject);
            EditorHighlighter highlighter = HighlighterFactory.createHighlighter((Project)this.myProject, (VirtualFile)file);
            ((EditorEx)editor).setHighlighter(highlighter);
            ((EditorEx)editor).setFile(file);
            this.myVirtualFile2Editor.put(file, editor);
        }
        if (descriptor.getOffset() >= 0) {
            editor.getCaretModel().moveToOffset(descriptor.getOffset());
        } else if (descriptor.getLine() >= 0 && descriptor.getColumn() >= 0) {
            editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(descriptor.getLine(), descriptor.getColumn()));
        }
        editor.getSelectionModel().removeSelection();
        this.myActiveFile = file;
        return editor;
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addFileEditorManagerListener"));
        }
    }

    public void addFileEditorManagerListener(@NotNull FileEditorManagerListener listener, @NotNull Disposable parentDisposable) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addFileEditorManagerListener"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "addFileEditorManagerListener"));
        }
    }

    public void removeFileEditorManagerListener(@NotNull FileEditorManagerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "removeFileEditorManagerListener"));
        }
    }

    @NotNull
    public List<FileEditor> openEditor(@NotNull OpenFileDescriptor descriptor, boolean focusEditor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openEditor"));
        }
        List<FileEditor> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "openEditor"));
        }
        return list;
    }

    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getProject"));
        }
        return project;
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        throw new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Pair<FileEditor[], FileEditorProvider[]> getEditorsWithProviders(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getEditorsWithProviders"));
        }
        Pair pair = Pair.create((Object)new FileEditor[0], (Object)new FileEditorProvider[0]);
        if (pair == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getEditorsWithProviders"));
        }
        return pair;
    }

    @Override
    public int getWindowSplitCount() {
        return 0;
    }

    @Override
    public boolean hasSplitOrUndockedWindows() {
        return false;
    }

    @NotNull
    public String getComponentName() {
        if ("TestEditorManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getComponentName"));
        }
        return "TestEditorManager";
    }

    @Override
    @NotNull
    public EditorsSplitters getSplitters() {
        throw new IncorrectOperationException();
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        if (requestor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "requestor", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getReady"));
        }
        ActionCallback.Done done = new ActionCallback.Done();
        if (done == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "getReady"));
        }
        return done;
    }

    public void setSelectedEditor(@NotNull VirtualFile file, @NotNull String fileEditorProviderId) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "setSelectedEditor"));
        }
        if (fileEditorProviderId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileEditorProviderId", "com/intellij/openapi/fileEditor/impl/TestEditorManagerImpl", "setSelectedEditor"));
        }
    }
}

