/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.keymap.impl.ui;

import com.intellij.openapi.actionSystem.ex.QuickList;
import com.intellij.openapi.actionSystem.ex.QuickListsManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.KeyMapBundle;
import com.intellij.openapi.keymap.impl.ui.KeymapListener;
import com.intellij.openapi.keymap.impl.ui.QuickListPanel;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ListUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBList;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class QuickListsPanel
extends JPanel
implements SearchableConfigurable,
Configurable.NoScroll {
    private final DefaultListModel myQuickListsModel = new DefaultListModel();
    private JBList myQuickListsList = new JBList((ListModel)this.myQuickListsModel);
    private final JPanel myRightPanel = new JPanel(new BorderLayout());
    private int myCurrentIndex = -1;
    private QuickListPanel myQuickListPanel = null;
    private final KeymapListener myKeymapListener = (KeymapListener)ApplicationManager.getApplication().getMessageBus().syncPublisher(KeymapListener.CHANGE_TOPIC);

    public QuickListsPanel() {
        super(new BorderLayout());
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setFirstComponent((JComponent)this.createQuickListsPanel());
        splitter.setSecondComponent((JComponent)this.myRightPanel);
        this.add((Component)splitter, "Center");
    }

    public void reset() {
        QuickList[] allQuickLists;
        this.myQuickListsModel.removeAllElements();
        for (QuickList list : allQuickLists = QuickListsManager.getInstance().getAllQuickLists()) {
            this.myQuickListsModel.addElement(list);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QuickListsPanel.this.myQuickListsModel.size() > 0) {
                    QuickListsPanel.this.myQuickListsList.setSelectedIndex(0);
                }
            }
        });
    }

    public boolean isModified() {
        Object[] modelLists;
        Object[] storedLists = QuickListsManager.getInstance().getAllQuickLists();
        return !Comparing.equal((Object[])storedLists, (Object[])(modelLists = this.getCurrentQuickListIds()));
    }

    public void apply() {
        QuickList[] currentQuickLists;
        QuickListsManager.getInstance().removeAllQuickLists();
        for (QuickList quickList : currentQuickLists = this.getCurrentQuickListIds()) {
            QuickListsManager.getInstance().registerQuickList(quickList);
        }
        QuickListsManager.getInstance().registerActions();
    }

    private JPanel createQuickListsPanel() {
        this.myQuickListsList = new JBList((ListModel)this.myQuickListsModel);
        this.myQuickListsList.setSelectionMode(0);
        this.myQuickListsList.setCellRenderer((ListCellRenderer)((Object)new MyQuickListCellRenderer()));
        this.myQuickListsList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                QuickListsPanel.this.myRightPanel.removeAll();
                Object selectedValue = QuickListsPanel.this.myQuickListsList.getSelectedValue();
                if (selectedValue instanceof QuickList) {
                    QuickList quickList = (QuickList)selectedValue;
                    QuickListsPanel.this.updateRightPanel(quickList);
                    QuickListsPanel.this.myQuickListsList.repaint();
                } else {
                    QuickListsPanel.this.addDescriptionLabel();
                }
                QuickListsPanel.this.myRightPanel.revalidate();
            }
        });
        this.addDescriptionLabel();
        ToolbarDecorator toolbarDecorator = ToolbarDecorator.createDecorator((JList)this.myQuickListsList).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                QuickList quickList = new QuickList(QuickListsPanel.this.createUniqueName(), "", ArrayUtil.EMPTY_STRING_ARRAY, false);
                QuickListsPanel.this.myQuickListsModel.addElement(quickList);
                QuickListsPanel.this.myQuickListsList.clearSelection();
                ListScrollingUtil.selectItem((JList)QuickListsPanel.this.myQuickListsList, (Object)quickList);
                QuickListsPanel.this.myKeymapListener.processCurrentKeymapChanged(QuickListsPanel.this.getCurrentQuickListIds());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                ListUtil.removeSelectedItems((JList)QuickListsPanel.this.myQuickListsList);
                QuickListsPanel.this.myQuickListsList.repaint();
                QuickListsPanel.this.myKeymapListener.processCurrentKeymapChanged(QuickListsPanel.this.getCurrentQuickListIds());
            }
        }).disableUpDownActions();
        return toolbarDecorator.createPanel();
    }

    private void addDescriptionLabel() {
        JLabel descLabel = new JLabel("<html>Quick Lists allow you to define commonly used groups of actions (for example, refactoring or VCS actions) and to assign keyboard shortcuts to such groups.</html>");
        descLabel.setBorder(new EmptyBorder(0, 25, 0, 25));
        this.myRightPanel.add((Component)descLabel, "Center");
    }

    private String createUniqueName() {
        int i;
        String str = KeyMapBundle.message((String)"unnamed.list.display.name", (Object[])new Object[0]);
        ArrayList<String> names = new ArrayList<String>();
        for (i = 0; i < this.myQuickListsModel.getSize(); ++i) {
            names.add(((QuickList)this.myQuickListsModel.getElementAt(i)).getDisplayName());
        }
        if (!names.contains(str)) {
            return str;
        }
        i = 1;
        while (names.contains(str + i)) {
            ++i;
        }
        return str + i;
    }

    private void updateRightPanel(QuickList quickList) {
        final int index = this.myQuickListsList.getSelectedIndex();
        if (this.myQuickListPanel != null && this.myCurrentIndex > -1 && this.myCurrentIndex < this.myQuickListsModel.getSize()) {
            this.updateList(this.myCurrentIndex);
            this.myKeymapListener.processCurrentKeymapChanged(this.getCurrentQuickListIds());
        }
        this.myQuickListPanel = new QuickListPanel(quickList, this.getCurrentQuickListIds());
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                QuickListsPanel.this.updateList(index);
            }
        };
        this.myQuickListPanel.addNameListener(documentAdapter);
        this.myQuickListPanel.addDescriptionListener(documentAdapter);
        this.myRightPanel.add((Component)this.myQuickListPanel.getPanel(), "Center");
        this.myCurrentIndex = index;
    }

    private void updateList(int index) {
        if (this.myQuickListPanel == null) {
            return;
        }
        QuickList oldQuickList = (QuickList)this.myQuickListsModel.getElementAt(index);
        QuickList newQuickList = this.createNewQuickListAt();
        if (oldQuickList != null) {
            newQuickList.getExternalInfo().copy(oldQuickList.getExternalInfo());
        }
        this.myQuickListsModel.setElementAt(newQuickList, index);
        if (oldQuickList != null && !newQuickList.getName().equals(oldQuickList.getName())) {
            this.myKeymapListener.quickListRenamed(oldQuickList, newQuickList);
        }
    }

    private QuickList createNewQuickListAt() {
        ListModel model = this.myQuickListPanel.getActionsList().getModel();
        int size = model.getSize();
        String[] ids = new String[size];
        for (int i = 0; i < size; ++i) {
            ids[i] = (String)model.getElementAt(i);
        }
        return new QuickList(this.myQuickListPanel.getDisplayName(), this.myQuickListPanel.getDescription(), ids, false);
    }

    public QuickList[] getCurrentQuickListIds() {
        if (this.myCurrentIndex > -1 && this.myQuickListsModel.getSize() > this.myCurrentIndex) {
            this.updateList(this.myCurrentIndex);
        }
        int size = this.myQuickListsModel.size();
        QuickList[] lists = new QuickList[size];
        for (int i = 0; i < lists.length; ++i) {
            lists[i] = (QuickList)this.myQuickListsModel.getElementAt(i);
        }
        return lists;
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/keymap/impl/ui/QuickListsPanel", "getId"));
        }
        return string;
    }

    public Runnable enableSearch(String option) {
        return null;
    }

    @Nls
    public String getDisplayName() {
        return "Quick Lists";
    }

    public String getHelpTopic() {
        return "reference.idesettings.quicklists";
    }

    public JComponent createComponent() {
        return this;
    }

    public void disposeUIResources() {
    }

    private static class MyQuickListCellRenderer
    extends ColoredListCellRenderer {
        private MyQuickListCellRenderer() {
        }

        protected void customizeCellRenderer(JList list, Object value, int index, boolean selected, boolean hasFocus) {
            this.setBackground(UIUtil.getListBackground((boolean)selected));
            QuickList quickList = (QuickList)value;
            this.append(quickList.getDisplayName());
        }
    }
}

