/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class LabelTextReplacingUtil {
    public static void replaceText(JComponent component) {
        Iterator<Component> children = IJSwingUtilities.getChildren(component);
        while (children.hasNext()) {
            AbstractButton button;
            String oldText;
            Component child = children.next();
            if (child instanceof JLabel) {
                JLabel label = (JLabel)child;
                oldText = label.getText();
                if (oldText == null) continue;
                label.setText(LabelTextReplacingUtil.doReplace(oldText));
                continue;
            }
            if (!(child instanceof AbstractButton) || (oldText = (button = (AbstractButton)child).getText()) == null) continue;
            button.setText(LabelTextReplacingUtil.doReplace(oldText));
        }
    }

    private static String doReplace(String oldText) {
        String newText = StringUtil.replace((String)oldText, (String)"$PRODUCT$", (String)ApplicationNamesInfo.getInstance().getProductName());
        newText = StringUtil.replace((String)newText, (String)"$FULLNAME$", (String)ApplicationNamesInfo.getInstance().getFullProductName());
        return newText;
    }
}

