/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.updateSettings.impl;

import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.options.BaseConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.updateSettings.impl.ChannelStatus;
import com.intellij.openapi.updateSettings.impl.LabelTextReplacingUtil;
import com.intellij.openapi.updateSettings.impl.UpdateChecker;
import com.intellij.openapi.updateSettings.impl.UpdateCheckerComponent;
import com.intellij.openapi.updateSettings.impl.UpdateSettings;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.net.NetUtils;
import com.intellij.util.text.DateFormatUtil;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpdateSettingsConfigurable
extends BaseConfigurable
implements SearchableConfigurable,
Configurable.NoScroll {
    private UpdatesSettingsPanel myUpdatesSettingsPanel;
    private boolean myCheckNowEnabled = true;

    public void setCheckNowEnabled(boolean enabled) {
        this.myCheckNowEnabled = enabled;
    }

    public JComponent createComponent() {
        this.myUpdatesSettingsPanel = new UpdatesSettingsPanel();
        this.myUpdatesSettingsPanel.myCheckNow.setVisible(this.myCheckNowEnabled);
        return this.myUpdatesSettingsPanel.myPanel;
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"updates.settings.title", (Object[])new Object[0]);
    }

    @NotNull
    public String getHelpTopic() {
        if ("preferences.updates" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable", "getHelpTopic"));
        }
        return "preferences.updates";
    }

    @NotNull
    public String getId() {
        String string = this.getHelpTopic();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/updateSettings/impl/UpdateSettingsConfigurable", "getId"));
        }
        return string;
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public void apply() throws ConfigurationException {
        UpdateCheckerComponent checker;
        UpdateSettings settings = UpdateSettings.getInstance();
        boolean wasEnabled = settings.CHECK_NEEDED;
        settings.CHECK_NEEDED = this.myUpdatesSettingsPanel.myCheckForUpdates.isSelected();
        if (wasEnabled != settings.CHECK_NEEDED && (checker = (UpdateCheckerComponent)ApplicationManager.getApplication().getComponent(UpdateCheckerComponent.class)) != null) {
            if (wasEnabled) {
                checker.cancelChecks();
            } else {
                checker.queueNextCheck();
            }
        }
        settings.UPDATE_CHANNEL_TYPE = this.myUpdatesSettingsPanel.getSelectedChannelType().getCode();
        settings.SECURE_CONNECTION = this.myUpdatesSettingsPanel.myUseSecureConnection.isSelected();
    }

    public void reset() {
        UpdateSettings settings = UpdateSettings.getInstance();
        this.myUpdatesSettingsPanel.myCheckForUpdates.setSelected(settings.CHECK_NEEDED);
        this.myUpdatesSettingsPanel.myUseSecureConnection.setSelected(settings.SECURE_CONNECTION);
        this.myUpdatesSettingsPanel.updateLastCheckedLabel();
        this.myUpdatesSettingsPanel.setSelectedChannelType(ChannelStatus.fromCode(settings.UPDATE_CHANNEL_TYPE));
    }

    public boolean isModified() {
        if (this.myUpdatesSettingsPanel == null) {
            return false;
        }
        UpdateSettings settings = UpdateSettings.getInstance();
        if (settings.CHECK_NEEDED != this.myUpdatesSettingsPanel.myCheckForUpdates.isSelected()) {
            return true;
        }
        if (settings.SECURE_CONNECTION != this.myUpdatesSettingsPanel.myUseSecureConnection.isSelected()) {
            return true;
        }
        Object channel = this.myUpdatesSettingsPanel.myUpdateChannels.getSelectedItem();
        return channel != null && !channel.equals(ChannelStatus.fromCode(settings.UPDATE_CHANNEL_TYPE));
    }

    public void disposeUIResources() {
        this.myUpdatesSettingsPanel = null;
    }

    private static class UpdatesSettingsPanel {
        private JPanel myPanel;
        private JButton myCheckNow;
        private JCheckBox myCheckForUpdates;
        private JLabel myBuildNumber;
        private JLabel myVersionNumber;
        private JLabel myLastCheckedDate;
        private JComboBox myUpdateChannels;
        private JCheckBox myUseSecureConnection;

        public UpdatesSettingsPanel() {
            this.$$$setupUI$$$();
            ApplicationInfo appInfo = ApplicationInfo.getInstance();
            String majorVersion = appInfo.getMajorVersion();
            String versionNumber = "";
            if (majorVersion != null && majorVersion.trim().length() > 0) {
                String minorVersion = appInfo.getMinorVersion();
                versionNumber = minorVersion != null && minorVersion.trim().length() > 0 ? majorVersion + "." + minorVersion : majorVersion + ".0";
            }
            this.myVersionNumber.setText(appInfo.getVersionName() + " " + versionNumber);
            this.myBuildNumber.setText(appInfo.getBuild().asString());
            this.myCheckNow.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    Project project = (Project)CommonDataKeys.PROJECT.getData(DataManager.getInstance().getDataContext((Component)UpdatesSettingsPanel.this.myCheckNow));
                    UpdateSettings settings = new UpdateSettings();
                    settings.loadState(UpdateSettings.getInstance().getState());
                    settings.UPDATE_CHANNEL_TYPE = UpdatesSettingsPanel.this.getSelectedChannelType().getCode();
                    settings.SECURE_CONNECTION = UpdatesSettingsPanel.this.myUseSecureConnection.isSelected();
                    UpdateChecker.updateAndShowResult(project, settings);
                    UpdatesSettingsPanel.this.updateLastCheckedLabel();
                }
            });
            LabelTextReplacingUtil.replaceText(this.myPanel);
            UpdateSettings settings = UpdateSettings.getInstance();
            this.myUpdateChannels.setModel(new CollectionComboBoxModel(ChannelStatus.all(), (Object)ChannelStatus.fromCode(settings.UPDATE_CHANNEL_TYPE)));
            if (!NetUtils.isSniEnabled()) {
                this.myUseSecureConnection.setEnabled(false);
                this.myUseSecureConnection.setToolTipText(IdeBundle.message((String)"update.sni.disabled.notification", (Object[])new Object[0]));
            }
        }

        private void updateLastCheckedLabel() {
            long time = UpdateSettings.getInstance().LAST_TIME_CHECKED;
            this.myLastCheckedDate.setText(time == 0L ? IdeBundle.message((String)"updates.last.check.never", (Object[])new Object[0]) : DateFormatUtil.formatPrettyDateTime((long)time));
        }

        public ChannelStatus getSelectedChannelType() {
            return (ChannelStatus)this.myUpdateChannels.getSelectedItem();
        }

        public void setSelectedChannelType(ChannelStatus channelType) {
            this.myUpdateChannels.setSelectedItem(channelType != null ? channelType : ChannelStatus.RELEASE);
        }

        private /* synthetic */ void $$$setupUI$$$() {
            JLabel jLabel;
            JLabel jLabel2;
            JLabel jLabel3;
            JCheckBox jCheckBox;
            JComboBox jComboBox;
            JButton jButton;
            JCheckBox jCheckBox2;
            JPanel jPanel;
            this.myPanel = jPanel = new JPanel();
            jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(10, 0, 20, 0), -1, -1, false, false));
            jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 3, 8, 2, 0, 0, null, null, null));
            this.myCheckForUpdates = jCheckBox2 = new JCheckBox();
            jCheckBox2.setSelected(true);
            this.$$$loadButtonText$$$(jCheckBox2, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.checkbox"));
            jPanel2.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myCheckNow = jButton = new JButton();
            this.$$$loadButtonText$$$(jButton, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.check.now.button"));
            jPanel2.add((Component)jButton, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myUpdateChannels = jComboBox = new JComboBox();
            jPanel2.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
            this.myUseSecureConnection = jCheckBox = new JCheckBox();
            this.$$$loadButtonText$$$(jCheckBox, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.secure"));
            jPanel2.add((Component)jCheckBox, new GridConstraints(1, 0, 1, 3, 8, 0, 0, 0, null, null, null));
            JLabel jLabel4 = new JLabel();
            this.$$$loadLabelText$$$(jLabel4, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.current.version"));
            jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myVersionNumber = jLabel3 = new JLabel();
            jLabel3.setText("4.5.4");
            jPanel.add((Component)jLabel3, new GridConstraints(2, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            JLabel jLabel5 = new JLabel();
            this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.build.number"));
            jPanel.add((Component)jLabel5, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myBuildNumber = jLabel2 = new JLabel();
            jLabel2.setText("3352");
            jPanel.add((Component)jLabel2, new GridConstraints(3, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            JLabel jLabel6 = new JLabel();
            this.$$$loadLabelText$$$(jLabel6, ResourceBundle.getBundle("messages/IdeBundle").getString("updates.settings.last.check"));
            jPanel.add((Component)jLabel6, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
            this.myLastCheckedDate = jLabel = new JLabel();
            jLabel.setText("01.05.2005");
            jPanel.add((Component)jLabel, new GridConstraints(1, 1, 1, 1, 8, 1, 0, 0, null, null, null));
            Spacer spacer = new Spacer();
            jPanel.add((Component)spacer, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 1, null, null, null));
            Spacer spacer2 = new Spacer();
            jPanel.add((Component)spacer2, new GridConstraints(4, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        }

        public /* synthetic */ JComponent $$$getRootComponent$$$() {
            return this.myPanel;
        }

        private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            jLabel.setText(stringBuffer.toString());
            if (bl) {
                jLabel.setDisplayedMnemonic(c);
                jLabel.setDisplayedMnemonicIndex(n);
            }
        }

        private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            char c = '\u0000';
            int n = -1;
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) == '&') {
                    if (++i == string.length()) break;
                    if (!bl && string.charAt(i) != '&') {
                        bl = true;
                        c = string.charAt(i);
                        n = stringBuffer.length();
                    }
                }
                stringBuffer.append(string.charAt(i));
            }
            abstractButton.setText(stringBuffer.toString());
            if (bl) {
                abstractButton.setMnemonic(c);
                abstractButton.setDisplayedMnemonicIndex(n);
            }
        }
    }
}

