/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.packageDependencies.ui;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.packageDependencies.ui.PackageDependenciesNode;
import com.intellij.psi.PsiFile;
import com.intellij.util.PlatformIcons;
import java.util.Set;
import javax.swing.Icon;

public class ModuleGroupNode
extends PackageDependenciesNode {
    private final ModuleGroup myModuleGroup;

    public ModuleGroupNode(ModuleGroup moduleGroup, Project project) {
        super(project);
        this.myModuleGroup = moduleGroup;
    }

    @Override
    public void fillFiles(Set<PsiFile> set, boolean recursively) {
        super.fillFiles(set, recursively);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            PackageDependenciesNode child = (PackageDependenciesNode)this.getChildAt(i);
            child.fillFiles(set, true);
        }
    }

    @Override
    public Icon getIcon() {
        return PlatformIcons.CLOSED_MODULE_GROUP_ICON;
    }

    @Override
    public String toString() {
        return this.myModuleGroup == null ? AnalysisScopeBundle.message((String)"unknown.node.text", (Object[])new Object[0]) : this.myModuleGroup.toString();
    }

    public String getModuleGroupName() {
        return this.myModuleGroup.presentableText();
    }

    public ModuleGroup getModuleGroup() {
        return this.myModuleGroup;
    }

    public boolean equals(Object o) {
        if (this.isEquals()) {
            return super.equals(o);
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModuleGroupNode)) {
            return false;
        }
        ModuleGroupNode moduleNode = (ModuleGroupNode)o;
        return Comparing.equal((Object)this.myModuleGroup, (Object)moduleNode.myModuleGroup);
    }

    public int hashCode() {
        return this.myModuleGroup == null ? 0 : this.myModuleGroup.hashCode();
    }
}

