/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServersTreeNode;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ServersTreeAction<T extends ServersTreeNode>
extends AnAction {
    protected ServersTreeAction(String text, String description, Icon icon) {
        super(text, description, icon);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "update"));
        }
        Presentation presentation = e.getPresentation();
        T targetNode = this.getTargetNode(e);
        boolean visible = false;
        boolean enabled = false;
        if (targetNode != null && (visible = this.isVisible4(targetNode))) {
            enabled = this.isEnabled4(targetNode);
        }
        presentation.setVisible(visible);
        presentation.setEnabled(enabled);
        this.updatePresentation(presentation, targetNode);
    }

    private T getTargetNode(AnActionEvent e) {
        ServersToolWindowContent content = ServersTreeAction.getContent(e);
        if (content == null) {
            return null;
        }
        Set selectedElements = content.getBuilder().getSelectedElements();
        if (selectedElements.size() != 1) {
            return null;
        }
        ServersTreeNode node = (ServersTreeNode)selectedElements.iterator().next();
        Class<T> targetNodeClass = this.getTargetNodeClass();
        if (!targetNodeClass.isInstance(node)) {
            return null;
        }
        return (T)((ServersTreeNode)targetNodeClass.cast(node));
    }

    private static ServersToolWindowContent getContent(AnActionEvent e) {
        return (ServersToolWindowContent)e.getData(ServersToolWindowContent.KEY);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "actionPerformed"));
        }
        T targetNode = this.getTargetNode(e);
        if (targetNode != null && this.isVisible4(targetNode) && this.isEnabled4(targetNode)) {
            this.doActionPerformed(ServersTreeAction.getContent(e), e, targetNode);
        }
    }

    protected boolean isVisible4(T node) {
        return true;
    }

    protected boolean isEnabled4(T node) {
        return true;
    }

    protected void updatePresentation(@NotNull Presentation presentation, @Nullable T node) {
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "updatePresentation"));
        }
    }

    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e, T node) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/ServersTreeAction", "doActionPerformed"));
        }
        this.doActionPerformed(node);
    }

    protected void doActionPerformed(T node) {
        throw new UnsupportedOperationException();
    }

    protected abstract Class<T> getTargetNodeClass();
}

