/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.testFramework.LightPlatformTestCase;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import com.intellij.util.PathUtil;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class LightTempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final VirtualFile mySourceRoot;
    private final boolean myUsePlatformSourceRoot;

    public LightTempDirTestFixtureImpl() {
        final VirtualFile fsRoot = VirtualFileManager.getInstance().findFileByUrl("temp:///");
        Assert.assertNotNull((Object)fsRoot);
        this.mySourceRoot = (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl$1", "run"));
                }
                result.setResult((Object)fsRoot.createChildDirectory((Object)this, "root"));
            }
        }.execute().getResultObject();
        this.myUsePlatformSourceRoot = false;
    }

    public LightTempDirTestFixtureImpl(boolean usePlatformSourceRoot) {
        this.myUsePlatformSourceRoot = usePlatformSourceRoot;
        this.mySourceRoot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDown() throws Exception {
        try {
            this.deleteAll();
        }
        finally {
            super.tearDown();
        }
    }

    @Override
    @NotNull
    public VirtualFile copyFile(final @NotNull VirtualFile file, final @NotNull String targetPath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyFile"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyFile"));
        }
        final String path = PathUtil.getParentPath((String)targetPath);
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile targetDir = LightTempDirTestFixtureImpl.this.findOrCreateDir(path);
                    String newName = PathUtil.getFileName((String)targetPath);
                    VirtualFile existing = targetDir.findChild(newName);
                    if (existing != null) {
                        existing.setBinaryContent(file.contentsToByteArray());
                        return existing;
                    }
                    return VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)targetDir, (String)newName);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "findOrCreateDir"));
        }
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    return LightTempDirTestFixtureImpl.this.findOrCreateChildDir(LightTempDirTestFixtureImpl.this.getSourceRoot(), path);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "findOrCreateDir"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                assert (from != null) : "Cannot find testdata directory " + dataDir;
                try {
                    UsefulTestCase.refreshRecursively(from);
                    VirtualFile tempDir = LightTempDirTestFixtureImpl.this.getSourceRoot();
                    if (targetDir.length() > 0) {
                        tempDir = LightTempDirTestFixtureImpl.this.findOrCreateChildDir(tempDir, targetDir);
                    }
                    VfsUtil.copyDirectory((Object)this, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    private VirtualFile findOrCreateChildDir(VirtualFile root, String relativePath) throws IOException {
        if (relativePath.length() == 0) {
            return root;
        }
        String trimPath = StringUtil.trimStart((String)relativePath, (String)"/");
        List dirs = StringUtil.split((String)trimPath, (String)"/");
        for (String dirName : dirs) {
            if (dirName.equals(".")) continue;
            if (dirName.equals("..")) {
                if ((root = root.getParent()) != null) continue;
                throw new IllegalArgumentException("Invalid path: " + relativePath);
            }
            VirtualFile dir = root.findChild(dirName);
            if (dir != null) {
                root = dir;
                continue;
            }
            try {
                root = root.createChildDirectory((Object)this, dirName);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return root;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        if ("temp:///root" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "getTempDirPath"));
        }
        return "temp:///root";
    }

    @Override
    public VirtualFile getFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "getFile"));
        }
        VirtualFile sourceRoot = this.getSourceRoot();
        VirtualFile result = sourceRoot.findFileByRelativePath(path);
        if (result == null) {
            sourceRoot.refresh(false, true);
            return sourceRoot.findFileByRelativePath(path);
        }
        return result;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath) {
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "createFile"));
        }
        final String path = PathUtil.getParentPath((String)targetPath);
        final String name = PathUtil.getFileName((String)targetPath);
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile targetDir = LightTempDirTestFixtureImpl.this.findOrCreateDir(path);
                    return targetDir.createChildData((Object)this, name);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String targetPath, final String text) throws IOException {
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "createFile"));
        }
        final VirtualFile file = this.createFile(targetPath);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                try {
                    VfsUtil.saveText((VirtualFile)file, (String)text);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    public void deleteAll() {
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                VirtualFile[] toDelete = LightTempDirTestFixtureImpl.this.myUsePlatformSourceRoot ? LightTempDirTestFixtureImpl.this.getSourceRoot().getChildren() : new VirtualFile[]{LightTempDirTestFixtureImpl.this.mySourceRoot};
                for (VirtualFile file : toDelete) {
                    try {
                        file.delete((Object)this);
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
            }
        });
    }

    @NotNull
    private VirtualFile getSourceRoot() {
        if (this.myUsePlatformSourceRoot) {
            VirtualFile virtualFile = LightPlatformTestCase.getSourceRoot();
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "getSourceRoot"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.mySourceRoot;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/LightTempDirTestFixtureImpl", "getSourceRoot"));
        }
        return virtualFile;
    }
}

