/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private final ArrayList<File> myFilesToDelete = new ArrayList();
    private File myTempDir;

    @Override
    @NotNull
    public VirtualFile copyFile(@NotNull VirtualFile file, @NotNull String targetPath) {
        VirtualFile virtualFile;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyFile"));
        }
        if (targetPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetPath", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyFile"));
        }
        try {
            this.createTempDirectory();
            VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
            virtualFile = VfsUtilCore.copyFile((Object)this, (VirtualFile)file, (VirtualFile)tempDir);
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot copy " + file, e);
        }
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String dataDir, @NotNull String targetDir) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        VirtualFile virtualFile = this.copyAll(dataDir, targetDir, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String dataDir, final @NotNull String targetDir, final @NotNull VirtualFileFilter filter) {
        if (dataDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (targetDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetDir", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile tempDir = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/'));
                    if (targetDir.length() > 0) {
                        assert (!targetDir.contains("/")) : "nested directories not implemented";
                        VirtualFile child = tempDir.findChild(targetDir);
                        if (child == null) {
                            child = tempDir.createChildDirectory((Object)this, targetDir);
                        }
                        tempDir = child;
                    }
                    VirtualFile from = LocalFileSystem.getInstance().refreshAndFindFileByPath(dataDir);
                    assert (from != null) : dataDir + " not found";
                    VfsUtil.copyDirectory(null, (VirtualFile)from, (VirtualFile)tempDir, (VirtualFileFilter)filter);
                    return tempDir;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "copyAll"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.createTempDirectory().getAbsolutePath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "getTempDirPath"));
        }
        return string;
    }

    public File createTempFile(String fileName) throws IOException {
        String prefix = StringUtil.getPackageName((String)fileName);
        if (prefix.length() < 3) {
            prefix = prefix + "___";
        }
        String suffix = "." + StringUtil.getShortName((String)fileName);
        return FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)prefix, (String)suffix, (boolean)true);
    }

    @Override
    @Nullable
    public VirtualFile getFile(final @NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "getFile"));
        }
        final Ref result = new Ref(null);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                block2: {
                    try {
                        String fullPath = TempDirTestFixtureImpl.this.myTempDir.getCanonicalPath().replace(File.separatorChar, '/') + "/" + path;
                        VirtualFile file = LocalFileSystem.getInstance().refreshAndFindFileByPath(fullPath);
                        result.set((Object)file);
                    }
                    catch (IOException e) {
                        if ($assertionsDisabled) break block2;
                        throw new AssertionError((Object)("Cannot find " + path + ": " + e));
                    }
                }
            }
        });
        return (VirtualFile)result.get();
    }

    @Override
    @NotNull
    public VirtualFile createFile(final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        final File file = this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                File file1 = new File(file, name);
                FileUtil.createIfDoesntExist((File)file1);
                return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file1);
            }
        });
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "findOrCreateDir"));
        }
        VirtualFile virtualFile = VfsUtil.createDirectories((String)new File(this.createTempDirectory(), name).getPath());
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "findOrCreateDir"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String name, final String text) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        final VirtualFile file = this.createFile(name);
        new WriteAction(){

            protected void run(@NotNull Result result) throws Throwable {
                if (result == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$4", "run"));
                }
                VfsUtil.saveText((VirtualFile)file, (String)text);
            }
        }.execute().throwException();
        VirtualFile virtualFile = file;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createFile"));
        }
        return virtualFile;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        for (File fileToDelete : this.myFilesToDelete) {
            boolean deleted = FileUtil.delete((File)fileToDelete);
            assert (deleted) : "Can't delete " + fileToDelete;
        }
        super.tearDown();
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        File file;
        try {
            if (this.myTempDir == null) {
                File tempHome = this.getTempHome();
                this.myTempDir = tempHome == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)tempHome, (String)"unitTest", null, (boolean)false);
                this.myFilesToDelete.add(this.myTempDir);
            }
            file = this.myTempDir;
        }
        catch (IOException e) {
            throw new RuntimeException("Cannot create temp dir", e);
        }
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl", "createTempDirectory"));
        }
        return file;
    }
}

