/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger.impl.ui.tree.actions;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.nodes.HeadlessValueEvaluationCallback;
import com.intellij.xdebugger.impl.ui.tree.nodes.WatchMessageNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XFetchValueActionBase
extends AnAction {
    @Nullable
    private static TreePath[] getSelectedNodes(DataContext dataContext) {
        XDebuggerTree tree = XDebuggerTree.getTree(dataContext);
        return tree == null ? null : tree.getSelectionPaths();
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "update"));
        }
        TreePath[] paths = XFetchValueActionBase.getSelectedNodes(e.getDataContext());
        if (paths != null) {
            for (TreePath path : paths) {
                Object node = path.getLastPathComponent();
                if (node instanceof XValueNodeImpl) {
                    if (!((XValueNodeImpl)node).isComputed()) continue;
                    e.getPresentation().setEnabled(true);
                    return;
                }
                if (!(node instanceof WatchMessageNode)) continue;
                e.getPresentation().setEnabled(true);
                return;
            }
        }
        e.getPresentation().setEnabled(false);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "actionPerformed"));
        }
        TreePath[] paths = XFetchValueActionBase.getSelectedNodes(e.getDataContext());
        if (paths == null) {
            return;
        }
        ValueCollector valueCollector = this.createCollector(e);
        for (TreePath path : paths) {
            Object node = path.getLastPathComponent();
            if (node instanceof XValueNodeImpl) {
                XValueNodeImpl valueNode = (XValueNodeImpl)node;
                XFullValueEvaluator fullValueEvaluator = valueNode.getFullValueEvaluator();
                if (fullValueEvaluator == null || !fullValueEvaluator.isShowValuePopup()) {
                    valueCollector.add(StringUtil.notNullize((String)DebuggerUIUtil.getNodeRawValue(valueNode)));
                    continue;
                }
                new CopyValueEvaluationCallback(valueNode, valueCollector).startFetchingValue(fullValueEvaluator);
                continue;
            }
            if (!(node instanceof WatchMessageNode)) continue;
            valueCollector.add(((WatchMessageNode)node).getExpression().getExpression());
        }
        valueCollector.processed = true;
        valueCollector.finish(e.getProject());
    }

    @NotNull
    protected ValueCollector createCollector(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "createCollector"));
        }
        ValueCollector valueCollector = new ValueCollector(XDebuggerTree.getTree(e.getDataContext()));
        if (valueCollector == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase", "createCollector"));
        }
        return valueCollector;
    }

    protected abstract void handle(Project var1, String var2, XDebuggerTree var3);

    private static final class CopyValueEvaluationCallback
    extends HeadlessValueEvaluationCallback {
        private final int myValueIndex;
        private final ValueCollector myValueCollector;

        public CopyValueEvaluationCallback(@NotNull XValueNodeImpl node, @NotNull ValueCollector valueCollector) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "<init>"));
            }
            if (valueCollector == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueCollector", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "<init>"));
            }
            super(node);
            this.myValueCollector = valueCollector;
            this.myValueIndex = valueCollector.acquire();
        }

        @Override
        protected void evaluationComplete(@NotNull String value, @NotNull Project project) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluationComplete"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$CopyValueEvaluationCallback", "evaluationComplete"));
            }
            this.myValueCollector.evaluationComplete(this.myValueIndex, value, project);
        }
    }

    protected class ValueCollector {
        private final List<String> values = new SmartList();
        private final XDebuggerTree myTree;
        private volatile boolean processed;

        public ValueCollector(XDebuggerTree tree) {
            this.myTree = tree;
        }

        public void add(@NotNull String value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "add"));
            }
            this.values.add(value);
        }

        public void finish(Project project) {
            if (this.processed && !this.values.contains(null) && !project.isDisposed()) {
                this.handleInCollector(project, StringUtil.join(this.values, (String)"\n"), this.myTree);
            }
        }

        public void handleInCollector(Project project, String value, XDebuggerTree tree) {
            XFetchValueActionBase.this.handle(project, value, tree);
        }

        public int acquire() {
            int index = this.values.size();
            this.values.add(null);
            return index;
        }

        public void evaluationComplete(final int index, final @NotNull String value, final Project project) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/xdebugger/impl/ui/tree/actions/XFetchValueActionBase$ValueCollector", "evaluationComplete"));
            }
            AppUIUtil.invokeOnEdt(new Runnable(){

                @Override
                public void run() {
                    ValueCollector.this.values.set(index, value);
                    ValueCollector.this.finish(project);
                }
            });
        }
    }
}

