/*
 * Decompiled with CFR 0.152.
 */
package com.siyeh.ig.psiutils;

import com.intellij.psi.JavaRecursiveElementVisitor;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiVariable;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import org.jetbrains.annotations.NotNull;

class VariablePassedAsArgumentVisitor
extends JavaRecursiveElementVisitor {
    @NotNull
    private final PsiVariable variable;
    private boolean passed;

    public VariablePassedAsArgumentVisitor(@NotNull PsiVariable variable) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "<init>"));
        }
        this.passed = false;
        this.variable = variable;
    }

    public void visitElement(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/siyeh/ig/psiutils/VariablePassedAsArgumentVisitor", "visitElement"));
        }
        if (!this.passed) {
            super.visitElement(element);
        }
    }

    public void visitCallExpression(PsiCallExpression callExpression) {
        super.visitCallExpression(callExpression);
        if (this.passed) {
            return;
        }
        this.visitCall((PsiCall)callExpression);
    }

    public void visitEnumConstant(PsiEnumConstant enumConstant) {
        if (this.passed) {
            return;
        }
        super.visitEnumConstant(enumConstant);
        this.visitCall((PsiCall)enumConstant);
    }

    private void visitCall(PsiCall call) {
        PsiExpressionList argumentList = call.getArgumentList();
        if (argumentList == null) {
            return;
        }
        for (PsiExpression argument : argumentList.getExpressions()) {
            if (!VariableAccessUtils.mayEvaluateToVariable(argument, this.variable)) continue;
            this.passed = true;
            break;
        }
    }

    public boolean isPassed() {
        return this.passed;
    }
}

