/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import java.net.InetSocketAddress;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.io.NettyUtil;

public abstract class SingleConnectionNetService
extends NetService {
    protected volatile Channel processChannel;

    protected SingleConnectionNetService(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/builtInWebServer/SingleConnectionNetService", "<init>"));
        }
        super(project);
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    @Override
    protected void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise, int port, @NotNull OSProcessHandler processHandler, @NotNull Consumer<String> errorOutputConsumer) {
        if (promise == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "promise", "org/jetbrains/builtInWebServer/SingleConnectionNetService", "connectToProcess"));
        }
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "org/jetbrains/builtInWebServer/SingleConnectionNetService", "connectToProcess"));
        }
        if (errorOutputConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorOutputConsumer", "org/jetbrains/builtInWebServer/SingleConnectionNetService", "connectToProcess"));
        }
        Bootstrap bootstrap = NettyUtil.oioClientBootstrap();
        this.configureBootstrap(bootstrap, errorOutputConsumer);
        Channel channel = NettyUtil.connect(bootstrap, new InetSocketAddress(NetUtils.getLoopbackAddress(), port), promise);
        if (channel != null) {
            this.processChannel = channel;
            promise.setResult(processHandler);
        }
    }

    @Override
    protected void closeProcessConnections() {
        Channel currentProcessChannel = this.processChannel;
        if (currentProcessChannel != null) {
            this.processChannel = null;
            NettyUtil.closeAndReleaseFactory(currentProcessChannel);
        }
    }
}

