/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.util.Function;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.ConsumerFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.EvaluateResult;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.io.JsonUtil;

public final class ValueModifierUtil {
    private static final Pattern KEY_NOTATION_PROPERTY_NAME_PATTERN = Pattern.compile("[\\p{L}_$]+[\\d\\p{L}_$]*");

    @NotNull
    public static Promise<Void> setValue(final @NotNull Variable variable, String newValue, final @NotNull EvaluateContext evaluateContext, final @NotNull ValueModifier modifier) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        Promise<Void> promise = evaluateContext.evaluate(newValue).then(new ConsumerFunction<EvaluateResult>(){

            public void consume(EvaluateResult result) {
                modifier.setValue(variable, result.value, evaluateContext);
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ValueModifierUtil", "setValue"));
        }
        return promise;
    }

    @NotNull
    public static Promise<Value> evaluateGet(final @NotNull Variable variable, @NotNull Object host, @NotNull EvaluateContext evaluateContext, @NotNull String selfName) {
        if (variable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "variable", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (evaluateContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluateContext", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        if (selfName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selfName", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        StringBuilder builder = new StringBuilder(selfName);
        ValueModifierUtil.appendUnquotedName(builder, variable.getName());
        Promise<Value> promise = evaluateContext.evaluate(builder.toString(), Collections.singletonMap(selfName, host), false).then(new Function<EvaluateResult, Value>(){

            public Value fun(EvaluateResult result) {
                variable.setValue(result.value);
                return result.value;
            }
        });
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ValueModifierUtil", "evaluateGet"));
        }
        return promise;
    }

    @NotNull
    public static String propertyNamesToString(@NotNull List<String> list, boolean quotedAware) {
        if (list == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "org/jetbrains/debugger/ValueModifierUtil", "propertyNamesToString"));
        }
        StringBuilder builder = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            String name = list.get(i);
            ValueModifierUtil.doAppendName(builder, name, quotedAware && (name.charAt(0) == '\"' || name.charAt(0) == '\''));
        }
        String string = builder.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/ValueModifierUtil", "propertyNamesToString"));
        }
        return string;
    }

    public static void appendUnquotedName(@NotNull StringBuilder builder, @NotNull String name) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/debugger/ValueModifierUtil", "appendUnquotedName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/ValueModifierUtil", "appendUnquotedName"));
        }
        ValueModifierUtil.doAppendName(builder, name, false);
    }

    private static void doAppendName(@NotNull StringBuilder builder, @NotNull String name, boolean quoted) {
        boolean useKeyNotation;
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "org/jetbrains/debugger/ValueModifierUtil", "doAppendName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/debugger/ValueModifierUtil", "doAppendName"));
        }
        boolean bl = useKeyNotation = !quoted && KEY_NOTATION_PROPERTY_NAME_PATTERN.matcher(name).matches();
        if (builder.length() != 0) {
            builder.append(useKeyNotation ? (char)'.' : '[');
        }
        if (useKeyNotation) {
            builder.append(name);
        } else {
            if (quoted) {
                builder.append(name);
            } else {
                JsonUtil.escape(name, builder);
            }
            builder.append(']');
        }
    }
}

