/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.PromiseManager;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.ValueManager;

public abstract class VariablesHost<VALUE_MANAGER extends ValueManager> {
    private static final PromiseManager<VariablesHost, List<Variable>> VARIABLES_LOADER = new PromiseManager<VariablesHost, List<Variable>>(VariablesHost.class){

        @Override
        public boolean isUpToDate(@NotNull VariablesHost host, @NotNull List<Variable> data) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/VariablesHost$1", "isUpToDate"));
            }
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "org/jetbrains/debugger/VariablesHost$1", "isUpToDate"));
            }
            return ((ValueManager)host.valueManager).getCacheStamp() == host.cacheStamp;
        }

        @Override
        @NotNull
        public Promise<List<Variable>> load(@NotNull VariablesHost host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "org/jetbrains/debugger/VariablesHost$1", "load"));
            }
            if (((ValueManager)host.valueManager).isObsolete()) {
                Promise<List<Variable>> promise = ValueManager.reject();
                if (promise == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariablesHost$1", "load"));
                }
                return promise;
            }
            Promise<List<Variable>> promise = host.load();
            if (promise == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariablesHost$1", "load"));
            }
            return promise;
        }
    };
    private volatile Promise<List<Variable>> result;
    private volatile int cacheStamp;
    public final VALUE_MANAGER valueManager;

    public VariablesHost(@NotNull VALUE_MANAGER manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/debugger/VariablesHost", "<init>"));
        }
        this.cacheStamp = -1;
        this.valueManager = manager;
    }

    @NotNull
    public final Promise<List<Variable>> get() {
        Promise<List<Variable>> promise = VARIABLES_LOADER.get(this);
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VariablesHost", "get"));
        }
        return promise;
    }

    @Nullable
    public final Promise.State getState() {
        return VARIABLES_LOADER.getState(this);
    }

    public final void set(@NotNull List<Variable> result) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/debugger/VariablesHost", "set"));
        }
        this.updateCacheStamp();
        VARIABLES_LOADER.set(this, result);
    }

    @NotNull
    protected abstract Promise<List<Variable>> load();

    public final void updateCacheStamp() {
        this.cacheStamp = ((ValueManager)this.valueManager).getCacheStamp();
    }

    public Promise<Void> clearCaches() {
        this.cacheStamp = -1;
        VARIABLES_LOADER.reset(this);
        return Promise.DONE;
    }
}

