/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.DebugEventListener;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.Vm;

public abstract class VmBase
implements Vm,
Vm.AttachStateManager {
    private EvaluateContext evaluateContext;
    private final DebugEventListener debugListener;

    protected VmBase(@NotNull DebugEventListener debugListener) {
        if (debugListener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "debugListener", "org/jetbrains/debugger/VmBase", "<init>"));
        }
        this.debugListener = debugListener;
    }

    @Override
    @Nullable
    public final synchronized EvaluateContext getEvaluateContext() {
        if (this.evaluateContext == null) {
            this.evaluateContext = this.computeEvaluateContext();
        }
        return this.evaluateContext;
    }

    @Nullable
    protected EvaluateContext computeEvaluateContext() {
        return null;
    }

    @Override
    @NotNull
    public final DebugEventListener getDebugListener() {
        DebugEventListener debugEventListener = this.debugListener;
        if (debugEventListener == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VmBase", "getDebugListener"));
        }
        return debugEventListener;
    }

    @Override
    @NotNull
    public Vm.AttachStateManager getAttachStateManager() {
        VmBase vmBase = this;
        if (vmBase == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VmBase", "getAttachStateManager"));
        }
        return vmBase;
    }

    @Override
    public boolean isAttached() {
        return true;
    }

    @Override
    @NotNull
    public Promise<Void> detach() {
        Promise<Void> promise = Promise.DONE;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/VmBase", "detach"));
        }
        return promise;
    }
}

