/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.sourcemap;

import com.google.gson.stream.JsonToken;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CharSequenceSubSequence;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.debugger.sourcemap.Base64VLQ;
import org.jetbrains.debugger.sourcemap.MappingEntry;
import org.jetbrains.debugger.sourcemap.MappingList;
import org.jetbrains.debugger.sourcemap.SourceMap;
import org.jetbrains.debugger.sourcemap.SourceResolver;
import org.jetbrains.io.JsonReaderEx;

public final class SourceMapDecoder {
    public static final int UNMAPPED = -1;
    private static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_SOURCE_POSITION = new Comparator<MappingEntry>(){

        @Override
        public int compare(@NotNull MappingEntry o1, @NotNull MappingEntry o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$1", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$1", "compare"));
            }
            if (o1.getSourceLine() == o2.getSourceLine()) {
                return o1.getSourceColumn() - o2.getSourceColumn();
            }
            return o1.getSourceLine() - o2.getSourceLine();
        }
    };
    public static final Comparator<MappingEntry> MAPPING_COMPARATOR_BY_GENERATED_POSITION = new Comparator<MappingEntry>(){

        @Override
        public int compare(@NotNull MappingEntry o1, @NotNull MappingEntry o2) {
            if (o1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o1", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$2", "compare"));
            }
            if (o2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o2", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$2", "compare"));
            }
            if (o1.getGeneratedLine() == o2.getGeneratedLine()) {
                return o1.getGeneratedColumn() - o2.getGeneratedColumn();
            }
            return o1.getGeneratedLine() - o2.getGeneratedLine();
        }
    };

    @Nullable
    public static SourceMap decode(@NotNull String contents, @NotNull SourceResolverFactory sourceResolverFactory) throws IOException {
        if (contents == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contents", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "decode"));
        }
        if (sourceResolverFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceResolverFactory", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "decode"));
        }
        if (contents.isEmpty()) {
            throw new IOException("source map contents cannot be empty");
        }
        String in = contents;
        if (contents.startsWith(")]}")) {
            in = new CharSequenceSubSequence((CharSequence)contents, contents.indexOf(10) + 1, contents.length());
        }
        return SourceMapDecoder.decode((CharSequence)in, sourceResolverFactory);
    }

    @Nullable
    public static SourceMap decode(@NotNull CharSequence in, @NotNull SourceResolverFactory sourceResolverFactory) throws IOException {
        if (in == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "in", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "decode"));
        }
        if (sourceResolverFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceResolverFactory", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "decode"));
        }
        JsonReaderEx reader = new JsonReaderEx(in);
        ArrayList<MappingEntry> mappings = new ArrayList<MappingEntry>();
        return SourceMapDecoder.parseMap(reader, 0, 0, mappings, sourceResolverFactory);
    }

    @Nullable
    private static SourceMap parseMap(JsonReaderEx reader, int line, int column, List<MappingEntry> mappings, @NotNull SourceResolverFactory sourceResolverFactory) throws IOException {
        if (sourceResolverFactory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceResolverFactory", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "parseMap"));
        }
        reader.beginObject();
        String sourceRoot = null;
        JsonReaderEx sourcesReader = null;
        List names = null;
        String encodedMappings = null;
        String file = null;
        int version = -1;
        SmartList sourcesContent = null;
        while (reader.hasNext()) {
            String propertyName = reader.nextName();
            if (propertyName.equals("sections")) {
                throw new IOException("sections is not supported yet");
            }
            if (propertyName.equals("version")) {
                version = reader.nextInt();
                continue;
            }
            if (propertyName.equals("sourceRoot")) {
                sourceRoot = SourceMapDecoder.readSourcePath(reader);
                continue;
            }
            if (propertyName.equals("sources")) {
                sourcesReader = reader.subReader();
                reader.skipValue();
                continue;
            }
            if (propertyName.equals("names")) {
                reader.beginArray();
                if (reader.hasNext()) {
                    names = new ArrayList();
                    do {
                        if (reader.peek() == JsonToken.BEGIN_OBJECT) {
                            reader.skipValue();
                            names.add("POLYMER UNKNOWN NAME");
                            continue;
                        }
                        names.add(reader.nextString(true));
                    } while (reader.hasNext());
                } else {
                    names = Collections.emptyList();
                }
                reader.endArray();
                continue;
            }
            if (propertyName.equals("mappings")) {
                encodedMappings = reader.nextString();
                continue;
            }
            if (propertyName.equals("file")) {
                file = reader.nextString();
                continue;
            }
            if (propertyName.equals("sourcesContent")) {
                reader.beginArray();
                if (reader.peek() != JsonToken.END_ARRAY) {
                    sourcesContent = new SmartList();
                    do {
                        if (reader.peek() == JsonToken.STRING) {
                            sourcesContent.add(StringUtilRt.convertLineSeparators((String)reader.nextString()));
                            continue;
                        }
                        reader.skipValue();
                    } while (reader.hasNext());
                }
                reader.endArray();
                continue;
            }
            reader.skipValue();
        }
        reader.close();
        if (StringUtil.isEmpty(encodedMappings)) {
            return null;
        }
        if (version != 3) {
            throw new IOException("Unsupported sourcemap version: " + version);
        }
        if (sourcesReader == null) {
            throw new IOException("sources is not specified");
        }
        List<String> sources = SourceMapDecoder.readSources(sourcesReader, sourceRoot);
        if (sources.isEmpty()) {
            return null;
        }
        List[] reverseMappingsBySourceUrl = new List[sources.size()];
        SourceMapDecoder.readMappings(encodedMappings, line, column, mappings, reverseMappingsBySourceUrl, names);
        MappingList[] sourceToEntries = new MappingList[reverseMappingsBySourceUrl.length];
        for (int i = 0; i < reverseMappingsBySourceUrl.length; ++i) {
            List entries = reverseMappingsBySourceUrl[i];
            if (entries == null) continue;
            Collections.sort(entries, MAPPING_COMPARATOR_BY_SOURCE_POSITION);
            sourceToEntries[i] = new SourceMappingList(entries);
        }
        return new SourceMap(file, new GeneratedMappingList(mappings), sourceToEntries, sourceResolverFactory.create(sources, (List<String>)sourcesContent), !ContainerUtil.isEmpty(names));
    }

    @Nullable
    private static String readSourcePath(JsonReaderEx reader) {
        return PathUtil.toSystemIndependentName((String)StringUtil.nullize((String)reader.nextString().trim()));
    }

    private static void readMappings(@NotNull String value, int line, int column, @NotNull List<MappingEntry> mappings, @NotNull List<MappingEntry>[] reverseMappingsBySourceUrl, @Nullable List<String> names) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "readMappings"));
        }
        if (mappings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "readMappings"));
        }
        if (reverseMappingsBySourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reverseMappingsBySourceUrl", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "readMappings"));
        }
        if (StringUtil.isEmpty((String)value)) {
            return;
        }
        CharSequenceIterator charIterator = new CharSequenceIterator(value);
        int sourceIndex = 0;
        List<MappingEntry> reverseMappings = SourceMapDecoder.getMapping(reverseMappingsBySourceUrl, sourceIndex);
        int sourceLine = 0;
        int sourceColumn = 0;
        int nameIndex = 0;
        while (charIterator.hasNext()) {
            UnnamedEntry entry;
            if (charIterator.peek() == ',') {
                charIterator.next();
            } else {
                while (charIterator.peek() == ';') {
                    ++line;
                    column = 0;
                    charIterator.next();
                    if (charIterator.hasNext()) continue;
                    return;
                }
            }
            column += Base64VLQ.decode(charIterator);
            if (SourceMapDecoder.isSeparator(charIterator)) {
                mappings.add(new UnmappedEntry(line, column));
                continue;
            }
            int sourceIndexDelta = Base64VLQ.decode(charIterator);
            if (sourceIndexDelta != 0) {
                reverseMappings = SourceMapDecoder.getMapping(reverseMappingsBySourceUrl, sourceIndex += sourceIndexDelta);
            }
            sourceLine += Base64VLQ.decode(charIterator);
            sourceColumn += Base64VLQ.decode(charIterator);
            if (SourceMapDecoder.isSeparator(charIterator)) {
                entry = new UnnamedEntry(line, column, sourceIndex, sourceLine, sourceColumn);
            } else {
                nameIndex += Base64VLQ.decode(charIterator);
                assert (names != null);
                entry = new NamedEntry(names.get(nameIndex), line, column, sourceIndex, sourceLine, sourceColumn);
            }
            reverseMappings.add(entry);
            mappings.add(entry);
        }
    }

    private static List<String> readSources(@NotNull JsonReaderEx reader, @Nullable String sourceRootUrl) {
        SmartList sources;
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "readSources"));
        }
        reader.beginArray();
        if (reader.peek() == JsonToken.END_ARRAY) {
            sources = Collections.emptyList();
        } else {
            sources = new SmartList();
            do {
                String sourceUrl = SourceMapDecoder.readSourcePath(reader);
                sourceUrl = StringUtil.isEmpty((String)sourceRootUrl) ? sourceUrl : sourceRootUrl + '/' + sourceUrl;
                sources.add(sourceUrl);
            } while (reader.hasNext());
        }
        reader.endArray();
        return sources;
    }

    private static List<MappingEntry> getMapping(@NotNull List<MappingEntry>[] reverseMappingsBySourceUrl, int sourceIndex) {
        if (reverseMappingsBySourceUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reverseMappingsBySourceUrl", "org/jetbrains/debugger/sourcemap/SourceMapDecoder", "getMapping"));
        }
        List<MappingEntry> reverseMappings = reverseMappingsBySourceUrl[sourceIndex];
        if (reverseMappings == null) {
            reverseMappingsBySourceUrl[sourceIndex] = reverseMappings = new ArrayList<MappingEntry>();
        }
        return reverseMappings;
    }

    private static boolean isSeparator(CharSequenceIterator charIterator) {
        if (!charIterator.hasNext()) {
            return true;
        }
        char current = charIterator.peek();
        return current == ',' || current == ';';
    }

    private static final class GeneratedMappingList
    extends MappingList {
        public GeneratedMappingList(@NotNull List<MappingEntry> mappings) {
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$GeneratedMappingList", "<init>"));
            }
            super(mappings);
        }

        @Override
        public int getLine(@NotNull MappingEntry mapping) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$GeneratedMappingList", "getLine"));
            }
            return mapping.getGeneratedLine();
        }

        @Override
        public int getColumn(@NotNull MappingEntry mapping) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$GeneratedMappingList", "getColumn"));
            }
            return mapping.getGeneratedColumn();
        }

        @Override
        protected Comparator<MappingEntry> getComparator() {
            return MAPPING_COMPARATOR_BY_GENERATED_POSITION;
        }
    }

    private static final class SourceMappingList
    extends MappingList {
        public SourceMappingList(@NotNull List<MappingEntry> mappings) {
            if (mappings == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mappings", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$SourceMappingList", "<init>"));
            }
            super(mappings);
        }

        @Override
        public int getLine(@NotNull MappingEntry mapping) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$SourceMappingList", "getLine"));
            }
            return mapping.getSourceLine();
        }

        @Override
        public int getColumn(@NotNull MappingEntry mapping) {
            if (mapping == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mapping", "org/jetbrains/debugger/sourcemap/SourceMapDecoder$SourceMappingList", "getColumn"));
            }
            return mapping.getSourceColumn();
        }

        @Override
        protected Comparator<MappingEntry> getComparator() {
            return MAPPING_COMPARATOR_BY_SOURCE_POSITION;
        }
    }

    private static class CharSequenceIterator
    implements Base64VLQ.CharIterator {
        private final CharSequence content;
        private final int length;
        private int current = 0;

        CharSequenceIterator(CharSequence content) {
            this.content = content;
            this.length = content.length();
        }

        @Override
        public char next() {
            return this.content.charAt(this.current++);
        }

        char peek() {
            return this.content.charAt(this.current);
        }

        @Override
        public boolean hasNext() {
            return this.current < this.length;
        }
    }

    private static class NamedEntry
    extends UnnamedEntry {
        private final String name;

        NamedEntry(String name, int line, int column, int source, int sourceLine, int sourceColumn) {
            super(line, column, source, sourceLine, sourceColumn);
            this.name = name;
        }

        @Override
        public String getName() {
            return this.name;
        }
    }

    private static class UnnamedEntry
    extends UnmappedEntry {
        private final int source;
        private final int sourceLine;
        private final int sourceColumn;

        UnnamedEntry(int line, int column, int source, int sourceLine, int sourceColumn) {
            super(line, column);
            this.source = source;
            this.sourceLine = sourceLine;
            this.sourceColumn = sourceColumn;
        }

        @Override
        public int getSource() {
            return this.source;
        }

        @Override
        public int getSourceLine() {
            return this.sourceLine;
        }

        @Override
        public int getSourceColumn() {
            return this.sourceColumn;
        }
    }

    private static class UnmappedEntry
    extends MappingEntry {
        private final int line;
        private final int column;

        UnmappedEntry(int line, int column) {
            this.line = line;
            this.column = column;
        }

        @Override
        public int getGeneratedColumn() {
            return this.column;
        }

        @Override
        public int getGeneratedLine() {
            return this.line;
        }

        @Override
        public int getSourceLine() {
            return -1;
        }

        @Override
        public int getSourceColumn() {
            return -1;
        }
    }

    public static interface SourceResolverFactory {
        @NotNull
        public SourceResolver create(@NotNull List<String> var1, @Nullable List<String> var2);
    }
}

