/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.Function;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.debugger.Vm;

public abstract class ValueManager<VM extends Vm> {
    public static final RuntimeException OBSOLETE_CONTEXT_ERROR = Promise.createError("Obsolete context");
    public static final Promise<?> OBSOLETE_CONTEXT_PROMISE = Promise.reject(OBSOLETE_CONTEXT_ERROR);
    private final AtomicInteger cacheStamp = new AtomicInteger();
    private volatile boolean obsolete;
    protected final VM vm;

    protected ValueManager(VM vm) {
        this.vm = vm;
    }

    public void clearCaches() {
        this.cacheStamp.incrementAndGet();
    }

    @NotNull
    public Function getClearCachesTask() {
        Function<Object, Void> function = new Function<Object, Void>(){

            public Void fun(Object o) {
                ValueManager.this.clearCaches();
                return null;
            }
        };
        if (function == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getClearCachesTask"));
        }
        return function;
    }

    public final int getCacheStamp() {
        return this.cacheStamp.get();
    }

    public final boolean isObsolete() {
        return this.obsolete;
    }

    public final void markObsolete() {
        this.obsolete = true;
    }

    @NotNull
    public static <T> Promise<T> reject() {
        Promise<?> promise = OBSOLETE_CONTEXT_PROMISE;
        if (promise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "reject"));
        }
        return promise;
    }

    @NotNull
    public VM getVm() {
        VM VM = this.vm;
        if (VM == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/debugger/values/ValueManager", "getVm"));
        }
        return VM;
    }
}

