/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.util.text.CharArrayCharSequence;
import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ChannelBufferToString {
    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer) throws CharacterCodingException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        MyCharArrayCharSequence myCharArrayCharSequence = new MyCharArrayCharSequence(ChannelBufferToString.readIntoCharBuffer(CharsetUtil.getDecoder((Charset)CharsetUtil.UTF_8), buffer, buffer.readableBytes(), null));
        if (myCharArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        return myCharArrayCharSequence;
    }

    @NotNull
    public static CharSequence readChars(@NotNull ByteBuf buffer, int byteCount) throws CharacterCodingException {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        MyCharArrayCharSequence myCharArrayCharSequence = new MyCharArrayCharSequence(ChannelBufferToString.readIntoCharBuffer(CharsetUtil.getDecoder((Charset)CharsetUtil.UTF_8), buffer, byteCount, null));
        if (myCharArrayCharSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readChars"));
        }
        return myCharArrayCharSequence;
    }

    @NotNull
    public static CharBuffer readIntoCharBuffer(@NotNull CharsetDecoder decoder, @NotNull ByteBuf buffer, int byteCount, @Nullable CharBuffer charBuffer) throws CharacterCodingException {
        CoderResult cr;
        if (decoder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "decoder", "org/jetbrains/io/ChannelBufferToString", "readIntoCharBuffer"));
        }
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "readIntoCharBuffer"));
        }
        ByteBuffer in = buffer.nioBuffer(buffer.readerIndex(), byteCount);
        if (charBuffer == null) {
            charBuffer = CharBuffer.allocate((int)((float)in.remaining() * decoder.maxCharsPerByte()));
        }
        if (!(cr = decoder.decode(in, charBuffer, true)).isUnderflow()) {
            cr.throwException();
        }
        if (!(cr = decoder.flush(charBuffer)).isUnderflow()) {
            cr.throwException();
        }
        buffer.skipBytes(byteCount);
        CharBuffer charBuffer2 = charBuffer;
        if (charBuffer2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/ChannelBufferToString", "readIntoCharBuffer"));
        }
        return charBuffer2;
    }

    public static void writeIntAsAscii(int value, @NotNull ByteBuf buffer) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/ChannelBufferToString", "writeIntAsAscii"));
        }
        String string = Integer.toString(value);
        for (int i = 0; i < string.length(); ++i) {
            buffer.writeByte((int)string.charAt(i));
        }
    }

    public static final class MyCharArrayCharSequence
    extends CharArrayCharSequence {
        public MyCharArrayCharSequence(@NotNull CharBuffer charBuffer) {
            if (charBuffer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "charBuffer", "org/jetbrains/io/ChannelBufferToString$MyCharArrayCharSequence", "<init>"));
            }
            super(charBuffer.array(), charBuffer.arrayOffset(), charBuffer.position());
        }

        public CharSequence subSequence(int start, int end) {
            return start == 0 && end == this.length() ? this : new String(this.myChars, this.myStart + start, end - start);
        }
    }
}

