/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class LocalFileFinder {
    private static final int FILE_EXISTS_MAX_TIMEOUT_MILLIS = 10;
    private static final Cache<Character, Boolean> myWindowsDrivesMap = CacheBuilder.newBuilder().expireAfterWrite(5L, TimeUnit.MINUTES).build();

    private LocalFileFinder() {
    }

    @Nullable
    public static VirtualFile findFile(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/io/LocalFileFinder", "findFile"));
        }
        if (LocalFileFinder.windowsDriveExists(path)) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    public static boolean windowsDriveExists(@NotNull String path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "org/jetbrains/io/LocalFileFinder", "windowsDriveExists"));
        }
        if (!SystemInfo.isWindows) {
            return true;
        }
        if (path.length() > 2 && Character.isLetter(path.charAt(0)) && path.charAt(1) == ':') {
            char driveLetter = Character.toUpperCase(path.charAt(0));
            Boolean driveExists = (Boolean)myWindowsDrivesMap.getIfPresent((Object)Character.valueOf(driveLetter));
            if (driveExists != null) {
                return driveExists;
            }
            long t0 = System.currentTimeMillis();
            boolean exists = new File(driveLetter + ":" + File.separator).exists();
            if (System.currentTimeMillis() - t0 > 10L) {
                exists = false;
            }
            myWindowsDrivesMap.put((Object)Character.valueOf(driveLetter), (Object)exists);
            return exists;
        }
        return false;
    }
}

