/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.fastCgi;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.InetSocketAddress;
import java.util.Locale;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.PathInfo;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.jetbrains.io.Responses;
import org.jetbrains.io.fastCgi.FastCgiService;

public class FastCgiRequest {
    private static final int PARAMS = 4;
    private static final int BEGIN_REQUEST = 1;
    private static final int RESPONDER = 1;
    private static final int FCGI_KEEP_CONNECTION = 1;
    private static final int STDIN = 5;
    private static final int VERSION = 1;
    private ByteBuf buffer;
    final int requestId;

    public FastCgiRequest(int requestId, @NotNull ByteBufAllocator allocator) {
        if (allocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "allocator", "org/jetbrains/io/fastCgi/FastCgiRequest", "<init>"));
        }
        this.requestId = requestId;
        this.buffer = allocator.ioBuffer(4096);
        this.writeHeader(this.buffer, 1, 8);
        this.buffer.writeShort(1);
        this.buffer.writeByte(1);
        this.buffer.writeZero(5);
    }

    public void writeFileHeaders(@NotNull VirtualFile file, @NotNull Project project, @NotNull CharSequence canonicalRequestPath) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        if (canonicalRequestPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "canonicalRequestPath", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeFileHeaders"));
        }
        PathInfo root = WebServerPathToFileManager.getInstance(project).getRoot(file);
        FastCgiService.LOG.assertTrue(root != null);
        this.addHeader("DOCUMENT_ROOT", root.getRoot().getPath());
        this.addHeader("SCRIPT_FILENAME", file.getPath());
        this.addHeader("SCRIPT_NAME", canonicalRequestPath);
    }

    public final void addHeader(@NotNull String key, @Nullable CharSequence value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "org/jetbrains/io/fastCgi/FastCgiRequest", "addHeader"));
        }
        if (value == null) {
            return;
        }
        int keyLength = key.length();
        int valLength = value.length();
        this.writeHeader(this.buffer, 4, keyLength + valLength + (keyLength < 128 ? 1 : 4) + (valLength < 128 ? 1 : 4));
        if (keyLength < 128) {
            this.buffer.writeByte(keyLength);
        } else {
            this.buffer.writeByte(0x80 | keyLength >> 24);
            this.buffer.writeByte(keyLength >> 16);
            this.buffer.writeByte(keyLength >> 8);
            this.buffer.writeByte(keyLength);
        }
        if (valLength < 128) {
            this.buffer.writeByte(valLength);
        } else {
            this.buffer.writeByte(0x80 | valLength >> 24);
            this.buffer.writeByte(valLength >> 16);
            this.buffer.writeByte(valLength >> 8);
            this.buffer.writeByte(valLength);
        }
        ByteBufUtil.writeAscii((ByteBuf)this.buffer, (CharSequence)key);
        ByteBufUtil.writeUtf8((ByteBuf)this.buffer, (CharSequence)value);
    }

    public void writeHeaders(@NotNull FullHttpRequest request, @NotNull Channel clientChannel) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeHeaders"));
        }
        if (clientChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientChannel", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeHeaders"));
        }
        this.addHeader("REQUEST_URI", request.uri());
        this.addHeader("REQUEST_METHOD", request.method().name());
        InetSocketAddress remote = (InetSocketAddress)clientChannel.remoteAddress();
        this.addHeader("REMOTE_ADDR", remote.getAddress().getHostAddress());
        this.addHeader("REMOTE_PORT", Integer.toString(remote.getPort()));
        InetSocketAddress local = (InetSocketAddress)clientChannel.localAddress();
        this.addHeader("SERVER_SOFTWARE", Responses.getServerHeaderValue());
        this.addHeader("SERVER_NAME", Responses.getServerHeaderValue());
        this.addHeader("SERVER_ADDR", local.getAddress().getHostAddress());
        this.addHeader("SERVER_PORT", Integer.toString(local.getPort()));
        this.addHeader("GATEWAY_INTERFACE", "CGI/1.1");
        this.addHeader("SERVER_PROTOCOL", request.protocolVersion().text());
        this.addHeader("CONTENT_TYPE", request.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE));
        this.addHeader("REDIRECT_STATUS", "200");
        String queryString = "";
        int queryIndex = request.uri().indexOf(63);
        if (queryIndex != -1) {
            queryString = request.uri().substring(queryIndex + 1);
        }
        this.addHeader("QUERY_STRING", queryString);
        this.addHeader("CONTENT_LENGTH", String.valueOf(request.content().readableBytes()));
        for (Map.Entry entry : request.headers()) {
            this.addHeader("HTTP_" + ((String)entry.getKey()).replace('-', '_').toUpperCase(Locale.ENGLISH), (CharSequence)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void writeToServerChannel(@Nullable ByteBuf content, @NotNull Channel fastCgiChannel) {
        if (fastCgiChannel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fastCgiChannel", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeToServerChannel"));
        }
        if (fastCgiChannel.pipeline().first() == null) {
            throw new IllegalStateException("No handler in the pipeline");
        }
        boolean releaseContent = content != null;
        try {
            this.writeHeader(this.buffer, 4, 0);
            if (content != null) {
                this.writeHeader(this.buffer, 5, content.readableBytes());
            }
            fastCgiChannel.write((Object)this.buffer);
            this.buffer = null;
            if (content != null) {
                fastCgiChannel.write((Object)content);
                releaseContent = false;
                ByteBuf headerBuffer = fastCgiChannel.alloc().ioBuffer(8, 8);
                this.writeHeader(headerBuffer, 5, 0);
                fastCgiChannel.write((Object)headerBuffer);
            }
        }
        finally {
            if (releaseContent) {
                assert (content != null);
                content.release();
            }
        }
        fastCgiChannel.flush();
    }

    private void writeHeader(@NotNull ByteBuf buffer, int type, int length) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buffer", "org/jetbrains/io/fastCgi/FastCgiRequest", "writeHeader"));
        }
        buffer.writeByte(1);
        buffer.writeByte(type);
        buffer.writeShort(this.requestId);
        buffer.writeShort(length);
        buffer.writeZero(2);
    }
}

