/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io.jsonRpc;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.internal.Streams;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.text.CharSequenceBackedByArray;
import gnu.trove.THashMap;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntProcedure;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.io.JsonUtil;
import org.jetbrains.io.jsonRpc.Client;
import org.jetbrains.io.jsonRpc.ClientManager;
import org.jetbrains.io.jsonRpc.JsonServiceInvocator;
import org.jetbrains.io.jsonRpc.MessageServer;

public class JsonRpcServer
implements MessageServer {
    protected static final Logger LOG = Logger.getInstance(JsonRpcServer.class);
    private static final TypeAdapterFactory INT_LIST_TYPE_ADAPTER_FACTORY = new TypeAdapterFactory(){
        private IntArrayListTypeAdapter<TIntArrayList> typeAdapter;

        @Nullable
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (type.getType() != TIntArrayList.class) {
                return null;
            }
            if (this.typeAdapter == null) {
                this.typeAdapter = new IntArrayListTypeAdapter();
            }
            return this.typeAdapter;
        }
    };
    private final AtomicInteger messageIdCounter;
    private final ClientManager clientManager;
    private final Gson gson;
    private final Map<String, NotNullLazyValue> domains;

    public JsonRpcServer(@NotNull ClientManager clientManager) {
        if (clientManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clientManager", "org/jetbrains/io/jsonRpc/JsonRpcServer", "<init>"));
        }
        this.messageIdCounter = new AtomicInteger();
        this.domains = new THashMap();
        this.clientManager = clientManager;
        this.gson = new GsonBuilder().registerTypeAdapter(CharSequenceBackedByArray.class, (Object)new JsonSerializer<CharSequenceBackedByArray>(){

            public JsonElement serialize(CharSequenceBackedByArray src, Type typeOfSrc, JsonSerializationContext context) {
                return new JsonPrimitive(src.toString());
            }
        }).registerTypeAdapterFactory(INT_LIST_TYPE_ADAPTER_FACTORY).disableHtmlEscaping().create();
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        this.registerDomain(name, commands, false);
    }

    public void registerDomain(@NotNull String name, @NotNull NotNullLazyValue commands, boolean overridable) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (commands == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commands", "org/jetbrains/io/jsonRpc/JsonRpcServer", "registerDomain"));
        }
        if (this.domains.containsKey(name)) {
            if (overridable) {
                return;
            }
            throw new IllegalArgumentException(name + " is already registered");
        }
        this.domains.put(name, commands);
    }

    @Override
    public void messageReceived(@NotNull Client client, @NotNull CharSequence message, boolean isBinary) throws IOException {
        Object[] parameters;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "messageReceived"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "org/jetbrains/io/jsonRpc/JsonRpcServer", "messageReceived"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("IN " + message);
        }
        JsonReaderEx reader = new JsonReaderEx(message);
        if (!isBinary) {
            reader.beginArray();
        }
        int messageId = reader.peek() == JsonToken.NUMBER ? reader.nextInt() : -1;
        String domainName = reader.nextString();
        if (domainName.length() == 1) {
            AsyncPromise promise = (AsyncPromise)client.messageCallbackMap.remove(messageId);
            if (domainName.charAt(0) == 'r') {
                if (promise == null) {
                    LOG.error("Response with id " + messageId + " was already processed");
                    return;
                }
                promise.setResult(JsonUtil.nextAny(reader));
            } else {
                promise.setError(Promise.createError("error"));
            }
            return;
        }
        NotNullLazyValue domainHolder = this.domains.get(domainName);
        if (domainHolder == null) {
            LOG.error("Cannot find domain " + domainName);
            return;
        }
        Object domain = domainHolder.getValue();
        String command = reader.nextString();
        if (domain instanceof JsonServiceInvocator) {
            ((JsonServiceInvocator)domain).invoke(command, client, reader, messageId);
            return;
        }
        if (reader.hasNext()) {
            SmartList list = new SmartList();
            JsonUtil.readListBody(reader, list);
            parameters = ArrayUtil.toObjectArray((Collection)list);
        } else {
            parameters = ArrayUtilRt.EMPTY_OBJECT_ARRAY;
        }
        if (!isBinary) {
            reader.endArray();
        }
        try {
            boolean isStatic = domain instanceof Class;
            Method[] methods = isStatic ? ((Class)domain).getDeclaredMethods() : domain.getClass().getMethods();
            for (Method method : methods) {
                if (!method.getName().equals(command)) continue;
                method.setAccessible(true);
                Object result = method.invoke(isStatic ? null : domain, parameters);
                if (messageId != -1) {
                    client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, null, null, null, new Object[]{result}));
                }
                return;
            }
            throw new NoSuchMethodException(command);
        }
        catch (Throwable e) {
            throw new IOException(e);
        }
    }

    public void sendResponse(int messageId, @NotNull Client client, @Nullable CharSequence rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendResponse"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, null, null, rawMessage, ArrayUtil.EMPTY_OBJECT_ARRAY));
    }

    public void sendErrorResponse(int messageId, @NotNull Client client, @Nullable CharSequence rawMessage) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendErrorResponse"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), messageId, "e", null, rawMessage, ArrayUtil.EMPTY_OBJECT_ARRAY));
    }

    public void sendToClients(@NotNull String domain, @NotNull String name) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        this.sendToClients(domain, name, null, new Object[0]);
    }

    public <T> void sendToClients(@NotNull String domain, @NotNull String command, @Nullable List<AsyncPromise<Pair<Client, T>>> results, Object ... params) {
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendToClients"));
        }
        if (this.clientManager.hasClients()) {
            this.sendToClients(results == null ? -1 : this.messageIdCounter.getAndIncrement(), domain, command, results, params);
        }
    }

    private <T> void sendToClients(int messageId, @Nullable String domain, @Nullable String command, @Nullable List<AsyncPromise<Pair<Client, T>>> results, Object[] params) {
        this.clientManager.send(messageId, this.encodeMessage(ByteBufAllocator.DEFAULT, messageId, domain, command, null, params), results);
    }

    public boolean sendWithRawPart(@NotNull Client client, @NotNull String domain, @NotNull String command, @Nullable CharSequence rawMessage, Object ... params) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "sendWithRawPart"));
        }
        client.send(this.encodeMessage(client.getByteBufAllocator(), -1, domain, command, rawMessage, params));
        return true;
    }

    public void send(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "send"));
        }
        this.sendWithRawPart(client, domain, command, null, params);
    }

    @NotNull
    public <T> Promise<T> call(@NotNull Client client, @NotNull String domain, @NotNull String command, Object ... params) {
        ByteBuf message;
        if (client == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "client", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        if (domain == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "domain", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        int messageId = this.messageIdCounter.getAndIncrement();
        AsyncPromise result = client.send(messageId, message = this.encodeMessage(client.getByteBufAllocator(), messageId, domain, command, null, params));
        LOG.assertTrue(result != null);
        AsyncPromise asyncPromise = result;
        if (asyncPromise == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "call"));
        }
        return asyncPromise;
    }

    @NotNull
    private ByteBuf encodeMessage(@NotNull ByteBufAllocator byteBufAllocator, int messageId, @Nullable String domain, @Nullable String command, @Nullable CharSequence rawData, @Nullable Object[] params) {
        ByteBuf byteBuf;
        if (byteBufAllocator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byteBufAllocator", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeMessage"));
        }
        StringBuilder sb = new StringBuilder();
        try {
            this.doEncodeMessage(sb, messageId, domain, command, params == null ? ArrayUtil.EMPTY_OBJECT_ARRAY : params, rawData);
            if (LOG.isDebugEnabled()) {
                LOG.debug("OUT " + sb.toString());
            }
            byteBuf = ByteBufUtil.encodeString((ByteBufAllocator)byteBufAllocator, (CharBuffer)CharBuffer.wrap(sb), (Charset)CharsetUtil.UTF_8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        if (byteBuf == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeMessage"));
        }
        return byteBuf;
    }

    private void doEncodeMessage(@NotNull StringBuilder sb, int id, @Nullable String domain, @Nullable String command, @NotNull Object[] params, @Nullable CharSequence rawData) throws IOException {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/io/jsonRpc/JsonRpcServer", "doEncodeMessage"));
        }
        sb.append('[');
        boolean hasPrev = false;
        if (id != -1) {
            sb.append(id);
            hasPrev = true;
        }
        if (domain != null) {
            if (hasPrev) {
                sb.append(',');
            }
            sb.append('\"').append(domain).append("\",\"");
            if (command == null) {
                if (rawData != null) {
                    sb.append(rawData);
                }
                sb.append('\"');
                return;
            }
            sb.append(command).append('\"');
        }
        this.encodeParameters(sb, params, rawData);
        sb.append(']');
    }

    private void encodeParameters(@NotNull StringBuilder sb, @NotNull Object[] params, @Nullable CharSequence rawData) throws IOException {
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeParameters"));
        }
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "params", "org/jetbrains/io/jsonRpc/JsonRpcServer", "encodeParameters"));
        }
        JsonWriter writer = null;
        sb.append(',').append('[');
        boolean hasPrev = false;
        for (Object param : params) {
            if (hasPrev) {
                sb.append(',');
            } else {
                hasPrev = true;
            }
            if (param instanceof CharSequence) {
                JsonUtil.escape((CharSequence)param, sb);
                continue;
            }
            if (param == null) {
                sb.append("null");
                continue;
            }
            if (param instanceof Number || param instanceof Boolean) {
                sb.append(param.toString());
                continue;
            }
            if (param instanceof Consumer) {
                ((Consumer)param).consume((Object)sb);
                continue;
            }
            if (writer == null) {
                writer = new JsonWriter(Streams.writerForAppendable((Appendable)sb));
            }
            this.gson.getAdapter(param.getClass()).write(writer, param);
        }
        if (rawData != null) {
            if (hasPrev) {
                sb.append(',');
            }
            sb.append(rawData);
        }
        sb.append(']');
    }

    private static class IntArrayListTypeAdapter<T>
    extends TypeAdapter<T> {
        private IntArrayListTypeAdapter() {
        }

        public void write(final JsonWriter out, T value) throws IOException {
            final Ref error = new Ref();
            out.beginArray();
            ((TIntArrayList)value).forEach(new TIntProcedure(){

                public boolean execute(int value) {
                    try {
                        out.value((long)value);
                    }
                    catch (IOException e) {
                        error.set((Object)e);
                    }
                    return error.isNull();
                }
            });
            if (!error.isNull()) {
                throw (IOException)error.get();
            }
            out.endArray();
        }

        public T read(JsonReader in) throws IOException {
            throw new UnsupportedOperationException();
        }
    }
}

