/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jsonProtocol;

import java.io.IOException;
import java.io.Writer;
import org.jetbrains.annotations.NotNull;

public class StringWriter
extends Writer {
    private final StringBuilder builder;

    public StringWriter() {
        this.builder = new StringBuilder();
        this.lock = this.builder;
    }

    public StringWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.builder = new StringBuilder(initialSize);
        this.lock = this.builder;
    }

    @Override
    public void write(int c) {
        this.builder.append((char)c);
    }

    @Override
    public void write(@NotNull char[] chars, int off, int len) {
        if (chars == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chars", "org/jetbrains/jsonProtocol/StringWriter", "write"));
        }
        this.builder.append(chars, off, len);
    }

    @Override
    public void write(@NotNull String string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "org/jetbrains/jsonProtocol/StringWriter", "write"));
        }
        this.builder.append(string);
    }

    @Override
    public void write(@NotNull String str, int off, int length) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "org/jetbrains/jsonProtocol/StringWriter", "write"));
        }
        this.builder.append(str, off, off + length);
    }

    @Override
    @NotNull
    public StringWriter append(CharSequence charSequence) {
        this.builder.append(charSequence);
        StringWriter stringWriter = this;
        if (stringWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jsonProtocol/StringWriter", "append"));
        }
        return stringWriter;
    }

    @Override
    @NotNull
    public StringWriter append(CharSequence charSequence, int start, int end) {
        this.builder.append(charSequence, start, end);
        StringWriter stringWriter = this;
        if (stringWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jsonProtocol/StringWriter", "append"));
        }
        return stringWriter;
    }

    @Override
    @NotNull
    public StringWriter append(char c) {
        this.write(c);
        StringWriter stringWriter = this;
        if (stringWriter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jsonProtocol/StringWriter", "append"));
        }
        return stringWriter;
    }

    public String toString() {
        return this.builder.toString();
    }

    public StringBuilder getBuffer() {
        return this.builder;
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() throws IOException {
    }
}

