/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.execution.configurations.ParametersList;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.externalSystem.service.execution.cmd.ParametersListLexer;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.PanelWithAnchor;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.TextFieldCompletionProvider;
import com.intellij.util.execution.ParametersListUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenArgumentsCompletionProvider;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.MavenSelectProjectPopup;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

public class MavenRunnerParametersPanel
implements PanelWithAnchor {
    private JPanel panel;
    protected LabeledComponent<TextFieldWithBrowseButton> workingDirComponent;
    protected LabeledComponent<EditorTextField> goalsComponent;
    private LabeledComponent<EditorTextField> profilesComponent;
    private JBLabel myFakeLabel;
    private JCheckBox myResolveToWorkspaceCheckBox;
    private FixedSizeButton showProjectTreeButton;
    private JComponent anchor;

    public MavenRunnerParametersPanel(final @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel", "<init>"));
        }
        this.$$$setupUI$$$();
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).addBrowseFolderListener(RunnerBundle.message("maven.select.maven.project.file", new Object[0]), "", project, new FileChooserDescriptor(false, true, false, false, false, false){

            public boolean isFileSelectable(VirtualFile file) {
                if (!super.isFileSelectable(file)) {
                    return false;
                }
                return file.findChild("pom.xml") != null;
            }
        });
        if (!project.isDefault()) {
            TextFieldCompletionProvider profilesCompletionProvider = new TextFieldCompletionProvider(true){

                protected final void addCompletionVariants(@NotNull String text, int offset, @NotNull String prefix, @NotNull CompletionResultSet result) {
                    if (text == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "addCompletionVariants"));
                    }
                    if (prefix == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefix", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "addCompletionVariants"));
                    }
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "addCompletionVariants"));
                    }
                    MavenProjectsManager manager = MavenProjectsManager.getInstance(project);
                    for (String profile : manager.getAvailableProfiles()) {
                        result.addElement((LookupElement)LookupElementBuilder.create((String)ParametersListUtil.join((String[])new String[]{profile})));
                    }
                }

                @NotNull
                protected String getPrefix(@NotNull String currentTextPrefix) {
                    if (currentTextPrefix == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentTextPrefix", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "getPrefix"));
                    }
                    ParametersListLexer lexer = new ParametersListLexer(currentTextPrefix);
                    while (lexer.nextToken()) {
                        if (lexer.getTokenEnd() != currentTextPrefix.length()) continue;
                        String prefix = lexer.getCurrentToken();
                        if (prefix.startsWith("-") || prefix.startsWith("!")) {
                            prefix = prefix.substring(1);
                        }
                        String string = prefix;
                        if (string == null) {
                            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "getPrefix"));
                        }
                        return string;
                    }
                    if ("" == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/execution/MavenRunnerParametersPanel$2", "getPrefix"));
                    }
                    return "";
                }
            };
            this.profilesComponent.setComponent((JComponent)profilesCompletionProvider.createEditor(project));
            this.goalsComponent.setComponent((JComponent)new MavenArgumentsCompletionProvider(project).createEditor(project));
        }
        this.showProjectTreeButton.setIcon(AllIcons.Actions.Module);
        MavenSelectProjectPopup.attachToWorkingDirectoryField(MavenProjectsManager.getInstance(project), ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).getTextField(), (JButton)this.showProjectTreeButton, this.goalsComponent.getComponent());
        this.setAnchor((JComponent)this.profilesComponent.getLabel());
    }

    public JComponent createComponent() {
        return this.panel;
    }

    public void disposeUIResources() {
    }

    public String getDisplayName() {
        return RunnerBundle.message("maven.runner.parameters.title", new Object[0]);
    }

    protected void setData(MavenRunnerParameters data) {
        data.setWorkingDirPath(((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).getText());
        data.setGoals(ParametersListUtil.parse((String)((EditorTextField)this.goalsComponent.getComponent()).getText()));
        data.setResolveToWorkspace(this.myResolveToWorkspaceCheckBox.isSelected());
        LinkedHashMap<String, Boolean> profilesMap = new LinkedHashMap<String, Boolean>();
        List profiles = ParametersListUtil.parse((String)((EditorTextField)this.profilesComponent.getComponent()).getText());
        for (String profile : profiles) {
            Boolean isEnabled = true;
            if (profile.startsWith("-") || profile.startsWith("!")) {
                if ((profile = profile.substring(1)).isEmpty()) continue;
                isEnabled = false;
            }
            profilesMap.put(profile, isEnabled);
        }
        data.setProfilesMap(profilesMap);
    }

    protected void getData(MavenRunnerParameters data) {
        ((TextFieldWithBrowseButton)this.workingDirComponent.getComponent()).setText(data.getWorkingDirPath());
        ((EditorTextField)this.goalsComponent.getComponent()).setText(ParametersList.join(data.getGoals()));
        this.myResolveToWorkspaceCheckBox.setSelected(data.isResolveToWorkspace());
        ParametersList parametersList = new ParametersList();
        for (Map.Entry<String, Boolean> entry : data.getProfilesMap().entrySet()) {
            String profileName = entry.getKey();
            if (!entry.getValue().booleanValue()) {
                profileName = '-' + profileName;
            }
            parametersList.add(profileName);
        }
        ((EditorTextField)this.profilesComponent.getComponent()).setText(parametersList.getParametersString());
    }

    public JComponent getAnchor() {
        return this.anchor;
    }

    public void setAnchor(JComponent anchor) {
        this.anchor = anchor;
        this.workingDirComponent.setAnchor(anchor);
        this.goalsComponent.setAnchor(anchor);
        this.profilesComponent.setAnchor(anchor);
        this.myFakeLabel.setAnchor(anchor);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        FixedSizeButton fixedSizeButton;
        LabeledComponent labeledComponent;
        JCheckBox jCheckBox;
        JBLabel jBLabel;
        LabeledComponent labeledComponent2;
        LabeledComponent labeledComponent3;
        JPanel jPanel;
        this.panel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.goalsComponent = labeledComponent3 = new LabeledComponent();
        labeledComponent3.setLabelLocation("West");
        labeledComponent3.setLabelInsets(new Insets(0, 0, 0, 0));
        labeledComponent3.setComponentClass("com.intellij.ui.EditorTextField");
        labeledComponent3.setText("&Command line");
        jPanel.add((Component)labeledComponent3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 2, new Insets(0, 0, 0, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.profilesComponent = labeledComponent2 = new LabeledComponent();
        labeledComponent2.setLabelLocation("West");
        labeledComponent2.setComponentClass("com.intellij.ui.EditorTextField");
        labeledComponent2.setText("&Profiles (separated with space)");
        jPanel2.add((Component)labeledComponent2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jBLabel2.setText("add prefix '-' to disable profile, e.g. \"-test\"");
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 1, 1, 1, 8, 0, 2, 0, null, null, null, 1));
        this.myFakeLabel = jBLabel = new JBLabel();
        jPanel2.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myResolveToWorkspaceCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setToolTipText("In case of multi-project workspace, dependencies will be looked for in the workspace first, and only after that in local repository.");
        jCheckBox.setText("Resolve Workspace artifacts");
        jCheckBox.setMnemonic('W');
        jCheckBox.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jCheckBox, new GridConstraints(3, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel3, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        this.workingDirComponent = labeledComponent = new LabeledComponent();
        labeledComponent.setLabelLocation("West");
        labeledComponent.setComponentClass("com.intellij.openapi.ui.TextFieldWithBrowseButton");
        labeledComponent.setText("Working &directory");
        jPanel3.add((Component)labeledComponent, "Center");
        this.showProjectTreeButton = fixedSizeButton = new FixedSizeButton();
        fixedSizeButton.setToolTipText("Select maven project");
        jPanel3.add((Component)fixedSizeButton, "East");
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.panel;
    }
}

