/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.output.parser.androidPlugin;

import com.android.tools.idea.gradle.output.GradleMessage;
import com.android.tools.idea.gradle.output.parser.OutputLineReader;
import com.android.tools.idea.gradle.output.parser.ParserUtil;
import com.android.tools.idea.gradle.output.parser.ParsingFailedException;
import com.android.tools.idea.gradle.output.parser.PatternAwareOutputParser;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class XmlValidationErrorParser
implements PatternAwareOutputParser {
    private static final Pattern FATAL_ERROR = Pattern.compile("\\[Fatal Error\\] :(\\d+):(\\d+): (.+)");
    private static final Pattern FILE_REFERENCE = Pattern.compile("Failed to parse (.+)");

    @Override
    public boolean parse(@NotNull String line, @NotNull OutputLineReader reader, @NotNull List<GradleMessage> messages) throws ParsingFailedException {
        if (line == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/android/tools/idea/gradle/output/parser/androidPlugin/XmlValidationErrorParser", "parse"));
        }
        if (reader == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reader", "com/android/tools/idea/gradle/output/parser/androidPlugin/XmlValidationErrorParser", "parse"));
        }
        if (messages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "messages", "com/android/tools/idea/gradle/output/parser/androidPlugin/XmlValidationErrorParser", "parse"));
        }
        Matcher m1 = FATAL_ERROR.matcher(line);
        if (!m1.matches()) {
            String sourcePath;
            Matcher m2 = FILE_REFERENCE.matcher(line);
            if (m2.matches() && new File(sourcePath = m2.group(1)).exists()) {
                String message = line;
                String exceptionMessage = ParserUtil.digestStackTrace(reader);
                if (exceptionMessage != null) {
                    message = exceptionMessage + ": " + message;
                }
                messages.add(new GradleMessage(GradleMessage.Kind.ERROR, message, sourcePath, -1, -1));
                return true;
            }
            return false;
        }
        String message = m1.group(3);
        int lineNumber = Integer.parseInt(m1.group(1));
        int column = Integer.parseInt(m1.group(2));
        String sourcePath = null;
        String nextLine = reader.peek(0);
        if (nextLine == null) {
            return false;
        }
        Matcher m2 = FILE_REFERENCE.matcher(nextLine);
        if (m2.matches()) {
            reader.readLine();
            sourcePath = m2.group(1);
            if (!new File(sourcePath).exists()) {
                sourcePath = null;
            }
        }
        messages.add(new GradleMessage(GradleMessage.Kind.ERROR, message, sourcePath, lineNumber, column));
        return true;
    }
}

